/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.openconnectome;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.ViewerSetupImgLoader;
import bdv.cache.CacheControl;
import bdv.img.cache.VolatileCachedCellImg;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.openconnectome.OpenConnectomeTokenInfo;
import bdv.img.openconnectome.OpenConnectomeVolatileArrayLoader;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;

public class OpenConnectomeImageLoader
extends AbstractViewerSetupImgLoader<UnsignedByteType, VolatileUnsignedByteType>
implements ViewerImgLoader {
    private final int numScales;
    private final double[][] mipmapResolutions;
    private final long[][] imageDimensions;
    private final int[][] blockDimensions;
    private final AffineTransform3D[] mipmapTransforms;
    private final VolatileGlobalCellCache cache;
    private final OpenConnectomeVolatileArrayLoader loader;

    public OpenConnectomeImageLoader(String baseUrl, String token, String mode) {
        super(new UnsignedByteType(), new VolatileUnsignedByteType());
        OpenConnectomeTokenInfo info = OpenConnectomeImageLoader.tryFetchTokenInfo(baseUrl, token, 20);
        this.numScales = info.dataset.cube_dimension.size();
        this.mipmapResolutions = info.getLevelScales(mode);
        this.imageDimensions = info.getLevelDimensions(mode);
        this.blockDimensions = info.getLevelCellDimensions();
        this.mipmapTransforms = info.getLevelTransforms(mode);
        this.cache = new VolatileGlobalCellCache(this.numScales, 10);
        System.out.println(info.getOffsets(mode)[0][2] + " " + this.imageDimensions[0][2]);
        this.loader = new OpenConnectomeVolatileArrayLoader(baseUrl, token, mode, Math.round(info.getOffsets(mode)[0][2]));
    }

    public static final String[] fetchTokenList(String baseUrl) throws JsonSyntaxException, JsonIOException, IOException {
        Gson gson = new Gson();
        URL url = new URL(baseUrl + "/public_tokens/");
        String[] tokens = (String[])gson.fromJson((Reader)new InputStreamReader(url.openStream()), String[].class);
        return tokens;
    }

    public static final OpenConnectomeTokenInfo fetchTokenInfo(String baseUrl, String token) throws JsonSyntaxException, JsonIOException, IOException {
        Gson gson = new Gson();
        URL url = new URL(baseUrl + "/" + token + "/info/");
        System.out.println("Fetching token from " + url);
        return (OpenConnectomeTokenInfo)gson.fromJson((Reader)new InputStreamReader(url.openStream()), OpenConnectomeTokenInfo.class);
    }

    public static final String[] tryFetchTokenList(String baseUrl, int maxNumTrials) {
        String[] tokens = null;
        for (int i = 0; i < maxNumTrials && tokens == null; ++i) {
            try {
                tokens = OpenConnectomeImageLoader.fetchTokenList(baseUrl);
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return tokens;
    }

    public static final OpenConnectomeTokenInfo tryFetchTokenInfo(String baseUrl, String token, int maxNumTrials) {
        OpenConnectomeTokenInfo info = null;
        for (int i = 0; i < maxNumTrials && info == null; ++i) {
            try {
                info = OpenConnectomeImageLoader.fetchTokenInfo(baseUrl, token);
                break;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return info;
    }

    public RandomAccessibleInterval<UnsignedByteType> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.prepareCachedImage(timepointId, 0, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
    }

    @Override
    public RandomAccessibleInterval<VolatileUnsignedByteType> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.prepareCachedImage(timepointId, 0, level, LoadingStrategy.VOLATILE, (NativeType)this.volatileType);
    }

    public double[][] getMipmapResolutions() {
        return this.mipmapResolutions;
    }

    public int numMipmapLevels() {
        return this.numScales;
    }

    public AffineTransform3D[] getMipmapTransforms() {
        return this.mipmapTransforms;
    }

    protected <T extends NativeType<T>> VolatileCachedCellImg<T, VolatileByteArray> prepareCachedImage(int timepointId, int setupId, int level, LoadingStrategy loadingStrategy, T type) {
        long[] dimensions = this.imageDimensions[level];
        int[] cellDimensions = this.blockDimensions[level];
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        int priority = this.numScales - 1 - level;
        CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
        return this.cache.createImg(grid, timepointId, setupId, level, cacheHints, this.loader, type);
    }

    @Override
    public CacheControl getCacheControl() {
        return this.cache;
    }

    @Override
    public ViewerSetupImgLoader<?, ?> getSetupImgLoader(int setupId) {
        return this;
    }
}

