/*
 * Decompiled with CFR 0.152.
 */
package bdv.spimdata.tools;

import bdv.export.ExportMipmapInfo;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.MipmapInfo;
import bdv.img.hdf5.Partition;
import bdv.img.hdf5.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.sequence.TimePoint;

public class MergePartitionList {
    public static ArrayList<Partition> getMergedHdf5PartitionList(AbstractSequenceDescription<?, ?, ?> seq1, AbstractSequenceDescription<?, ?, ?> seq2) {
        ArrayList<Partition> partitions = MergePartitionList.getPartitions(seq1);
        partitions.addAll(MergePartitionList.getPartitions(seq2));
        return partitions;
    }

    public static Map<Integer, ExportMipmapInfo> getHdf5PerSetupExportMipmapInfos(AbstractSequenceDescription<?, ?, ?> seq) throws IllegalArgumentException {
        Hdf5ImageLoader imgLoader = MergePartitionList.getHdf5ImageLoader(seq);
        HashMap<Integer, ExportMipmapInfo> perSetupMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        Iterator iterator = seq.getViewSetups().keySet().iterator();
        while (iterator.hasNext()) {
            int setupId = (Integer)iterator.next();
            MipmapInfo info = imgLoader.getSetupImgLoader(setupId).getMipmapInfo();
            perSetupMipmapInfo.put(setupId, new ExportMipmapInfo(Util.castToInts(info.getResolutions()), info.getSubdivisions()));
        }
        return perSetupMipmapInfo;
    }

    public static ArrayList<Partition> getPartitions(AbstractSequenceDescription<?, ?, ?> seq) throws IllegalArgumentException {
        Hdf5ImageLoader imgLoader = MergePartitionList.getHdf5ImageLoader(seq);
        ArrayList<Partition> partitions = new ArrayList<Partition>(imgLoader.getPartitions());
        if (partitions.isEmpty()) {
            HashMap<Integer, Integer> timepointIdentityMap = new HashMap<Integer, Integer>();
            for (TimePoint tp : seq.getTimePoints().getTimePointsOrdered()) {
                timepointIdentityMap.put(tp.getId(), tp.getId());
            }
            HashMap<Integer, Integer> setupIdentityMap = new HashMap<Integer, Integer>();
            Iterator iterator = seq.getViewSetups().keySet().iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                setupIdentityMap.put(s, s);
            }
            partitions.add(new Partition(imgLoader.getHdf5File().getAbsolutePath(), timepointIdentityMap, setupIdentityMap));
        }
        return partitions;
    }

    public static Hdf5ImageLoader getHdf5ImageLoader(AbstractSequenceDescription<?, ?, ?> seq) throws IllegalArgumentException {
        BasicImgLoader imgLoader = seq.getImgLoader();
        if (imgLoader instanceof Hdf5ImageLoader) {
            return (Hdf5ImageLoader)imgLoader;
        }
        throw new IllegalArgumentException("invalid ImgLoader class " + imgLoader.getClass() + " (expected Hdf5ImageLoader)");
    }
}

