/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools;

import bdv.cache.CacheControl;
import bdv.export.ProgressWriter;
import bdv.util.DelayedPackDialog;
import bdv.util.Prefs;
import bdv.viewer.BasicViewerState;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.ViewerPanel;
import bdv.viewer.overlay.ScaleBarOverlayRenderer;
import bdv.viewer.render.MultiResolutionRenderer;
import bdv.viewer.render.RenderTarget;
import bdv.viewer.render.awt.BufferedImageRenderResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.realtransform.AffineTransform3D;

public class RecordMovieDialog
extends DelayedPackDialog
implements OverlayRenderer {
    private static final long serialVersionUID = 1L;
    private final ViewerPanel viewer;
    private final int maxTimepoint;
    private final ProgressWriter progressWriter;
    private final JTextField pathTextField;
    private final JSpinner spinnerMinTimepoint;
    private final JSpinner spinnerMaxTimepoint;
    private final JSpinner spinnerWidth;
    private final JSpinner spinnerHeight;

    public RecordMovieDialog(Frame owner, ViewerPanel viewer, ProgressWriter progressWriter) {
        super(owner, "record movie", false);
        this.viewer = viewer;
        this.maxTimepoint = viewer.state().getNumTimepoints() - 1;
        this.progressWriter = progressWriter;
        JPanel boxes = new JPanel();
        this.getContentPane().add((Component)boxes, "North");
        boxes.setLayout(new BoxLayout(boxes, 3));
        JPanel saveAsPanel = new JPanel();
        saveAsPanel.setLayout(new BorderLayout(0, 0));
        boxes.add(saveAsPanel);
        saveAsPanel.add((Component)new JLabel("save to"), "West");
        this.pathTextField = new JTextField("./record/");
        saveAsPanel.add((Component)this.pathTextField, "Center");
        this.pathTextField.setColumns(20);
        JButton browseButton = new JButton("Browse");
        saveAsPanel.add((Component)browseButton, "East");
        JPanel timepointsPanel = new JPanel();
        boxes.add(timepointsPanel);
        timepointsPanel.add(new JLabel("timepoints from"));
        this.spinnerMinTimepoint = new JSpinner();
        this.spinnerMinTimepoint.setModel(new SpinnerNumberModel(0, 0, this.maxTimepoint, 1));
        timepointsPanel.add(this.spinnerMinTimepoint);
        timepointsPanel.add(new JLabel("to"));
        this.spinnerMaxTimepoint = new JSpinner();
        this.spinnerMaxTimepoint.setModel(new SpinnerNumberModel(this.maxTimepoint, 0, this.maxTimepoint, 1));
        timepointsPanel.add(this.spinnerMaxTimepoint);
        JPanel widthPanel = new JPanel();
        boxes.add(widthPanel);
        widthPanel.add(new JLabel("width"));
        this.spinnerWidth = new JSpinner();
        this.spinnerWidth.setModel(new SpinnerNumberModel(800, 10, 5000, 1));
        widthPanel.add(this.spinnerWidth);
        JPanel heightPanel = new JPanel();
        boxes.add(heightPanel);
        heightPanel.add(new JLabel("height"));
        this.spinnerHeight = new JSpinner();
        this.spinnerHeight.setModel(new SpinnerNumberModel(600, 10, 5000, 1));
        heightPanel.add(this.spinnerHeight);
        JPanel buttonsPanel = new JPanel();
        boxes.add(buttonsPanel);
        buttonsPanel.setLayout(new BorderLayout(0, 0));
        final JButton recordButton = new JButton("Record");
        buttonsPanel.add((Component)recordButton, "East");
        this.spinnerMinTimepoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int min = (Integer)RecordMovieDialog.this.spinnerMinTimepoint.getValue();
                int max = (Integer)RecordMovieDialog.this.spinnerMaxTimepoint.getValue();
                if (max < min) {
                    RecordMovieDialog.this.spinnerMaxTimepoint.setValue(min);
                }
            }
        });
        this.spinnerMaxTimepoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int max;
                int min = (Integer)RecordMovieDialog.this.spinnerMinTimepoint.getValue();
                if (min > (max = ((Integer)RecordMovieDialog.this.spinnerMaxTimepoint.getValue()).intValue())) {
                    RecordMovieDialog.this.spinnerMinTimepoint.setValue(max);
                }
            }
        });
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser.setSelectedFile(new File(RecordMovieDialog.this.pathTextField.getText()));
                int returnVal = fileChooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = fileChooser.getSelectedFile();
                    RecordMovieDialog.this.pathTextField.setText(file.getAbsolutePath());
                }
            }
        });
        recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dirname = RecordMovieDialog.this.pathTextField.getText();
                final File dir = new File(dirname);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    System.err.println("Invalid export directory " + dirname);
                    return;
                }
                final int minTimepointIndex = (Integer)RecordMovieDialog.this.spinnerMinTimepoint.getValue();
                final int maxTimepointIndex = (Integer)RecordMovieDialog.this.spinnerMaxTimepoint.getValue();
                final int width = (Integer)RecordMovieDialog.this.spinnerWidth.getValue();
                final int height = (Integer)RecordMovieDialog.this.spinnerHeight.getValue();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            recordButton.setEnabled(false);
                            RecordMovieDialog.this.recordMovie(width, height, minTimepointIndex, maxTimepointIndex, dir);
                            recordButton.setEnabled(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }.start();
            }
        });
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        Object hideKey = new Object();
        AbstractAction hideAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordMovieDialog.this.setVisible(false);
            }
        };
        im.put(KeyStroke.getKeyStroke(27, 0), hideKey);
        am.put(hideKey, hideAction);
        this.pack();
    }

    public void recordMovie(final int width, final int height, int minTimepointIndex, int maxTimepointIndex, File dir) throws IOException {
        BasicViewerState renderState = new BasicViewerState(this.viewer.state().snapshot());
        int canvasW = this.viewer.getDisplay().getWidth();
        int canvasH = this.viewer.getDisplay().getHeight();
        AffineTransform3D affine = new AffineTransform3D();
        renderState.getViewerTransform(affine);
        affine.set(affine.get(0, 3) - (double)(canvasW / 2), 0, 3);
        affine.set(affine.get(1, 3) - (double)(canvasH / 2), 1, 3);
        affine.scale((double)width / (double)canvasW);
        affine.set(affine.get(0, 3) + (double)(width / 2), 0, 3);
        affine.set(affine.get(1, 3) + (double)(height / 2), 1, 3);
        renderState.setViewerTransform(affine);
        ScaleBarOverlayRenderer scalebar = Prefs.showScaleBarInMovie() ? new ScaleBarOverlayRenderer() : null;
        class MyTarget
        implements RenderTarget<BufferedImageRenderResult> {
            final BufferedImageRenderResult renderResult = new BufferedImageRenderResult();

            MyTarget() {
            }

            @Override
            public BufferedImageRenderResult getReusableRenderResult() {
                return this.renderResult;
            }

            @Override
            public BufferedImageRenderResult createRenderResult() {
                return new BufferedImageRenderResult();
            }

            @Override
            public void setRenderResult(BufferedImageRenderResult renderResult) {
            }

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        }
        MyTarget target = new MyTarget();
        MultiResolutionRenderer renderer = new MultiResolutionRenderer(target, () -> {}, new double[]{1.0}, 0L, 1, null, false, this.viewer.getOptionValues().getAccumulateProjectorFactory(), new CacheControl.Dummy());
        this.progressWriter.setProgress(0.0);
        for (int timepoint = minTimepointIndex; timepoint <= maxTimepointIndex; ++timepoint) {
            renderState.setCurrentTimepoint(timepoint);
            renderer.requestRepaint();
            renderer.paint(renderState);
            BufferedImage bi = target.renderResult.getBufferedImage();
            if (Prefs.showScaleBarInMovie()) {
                Graphics2D g2 = bi.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setClip(0, 0, width, height);
                scalebar.setViewerState(renderState);
                scalebar.paint(g2);
            }
            ImageIO.write((RenderedImage)bi, "png", new File(String.format("%s/img-%03d.png", dir, timepoint)));
            this.progressWriter.setProgress((double)(timepoint - minTimepointIndex + 1) / (double)(maxTimepointIndex - minTimepointIndex + 1));
        }
    }

    @Override
    public void drawOverlays(Graphics g) {
    }

    @Override
    public void setCanvasSize(int width, int height) {
        this.spinnerWidth.setValue(width);
        this.spinnerHeight.setValue(height);
    }
}

