/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.AbstractTransformedBoxModel;
import bdv.tools.boundingbox.IntervalCorners;
import bdv.tools.boundingbox.TransformedBoxOverlay;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.DragBehaviour;

final class DragBoxCornerBehaviour
implements DragBehaviour {
    private final TransformedBoxOverlay boxOverlay;
    private boolean moving = false;
    private final AbstractTransformedBoxModel model;
    private final double[] initMin = new double[3];
    private final double[] initMax = new double[3];
    private final double[] initCorner = new double[3];
    private int cornerId;
    private final AffineTransform3D transform = new AffineTransform3D();

    public DragBoxCornerBehaviour(TransformedBoxOverlay boxOverlay, AbstractTransformedBoxModel model) {
        this.boxOverlay = boxOverlay;
        this.model = model;
    }

    public void init(int x, int y) {
        this.cornerId = this.boxOverlay.getHighlightedCornerIndex();
        if (this.cornerId < 0) {
            return;
        }
        RealInterval interval = this.model.getInterval();
        IntervalCorners.corner(interval, this.cornerId, this.initCorner);
        interval.realMin(this.initMin);
        interval.realMax(this.initMax);
        this.moving = true;
    }

    public void drag(int x, int y) {
        if (!this.moving) {
            return;
        }
        this.boxOverlay.getBoxToViewerTransform(this.transform);
        double[] gPos = new double[3];
        this.transform.apply(this.initCorner, gPos);
        double[] lPos = this.boxOverlay.renderBoxHelper.reproject(x, y, gPos[2]);
        this.transform.applyInverse(gPos, lPos);
        double[] min = new double[3];
        double[] max = new double[3];
        for (int d = 0; d < 3; ++d) {
            double p = gPos[d];
            if ((this.cornerId & 1 << d) == 0) {
                min[d] = p;
                max[d] = this.initMax[d] = Math.max(this.initMax[d], p);
                continue;
            }
            min[d] = this.initMin[d] = Math.min(this.initMin[d], p);
            max[d] = p;
        }
        this.model.setInterval((RealInterval)new FinalRealInterval(min, max));
    }

    public void end(int x, int y) {
        this.moving = false;
    }
}

