/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.IntervalCorners;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;

public final class RenderBoxHelper {
    private double depth = 10.0;
    private double scale = 0.1;
    private final double[] origin = new double[3];
    private boolean perspective = false;
    private final List<double[]> intersectionPoints = new ArrayList<double[]>();
    static final int numCorners = 8;
    final double[][] corners = new double[8][3];
    final double[][] projectedCorners = new double[8][2];

    public void setPerspectiveProjection(boolean b) {
        this.perspective = b;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.origin[2] = -depth;
    }

    public void setOrigin(double x, double y) {
        this.origin[0] = x;
        this.origin[1] = y;
    }

    public void project(double[] point, double[] projection) {
        double f = this.perspective ? this.scale * this.depth / (point[2] - this.origin[2]) : this.scale;
        projection[0] = (point[0] - this.origin[0]) * f + this.origin[0];
        projection[1] = (point[1] - this.origin[1]) * f + this.origin[1];
    }

    public double[] project(double[] point) {
        double[] projection = new double[2];
        this.project(point, projection);
        return projection;
    }

    public double[] reproject(double x, double y, double z) {
        double[] point = new double[3];
        double f = this.perspective ? (z - this.origin[2]) / (this.scale * this.depth) : 1.0 / this.scale;
        point[0] = (x - this.origin[0]) * f + this.origin[0];
        point[1] = (y - this.origin[1]) * f + this.origin[1];
        point[2] = z;
        return point;
    }

    private void splitEdge(int ia, int ib, GeneralPath before, GeneralPath behind) {
        double[] a = this.corners[ia];
        double[] b = this.corners[ib];
        double[] pa = this.projectedCorners[ia];
        double[] pb = this.projectedCorners[ib];
        if (a[2] <= 0.0) {
            before.moveTo(pa[0], pa[1]);
            if (b[2] <= 0.0) {
                before.lineTo(pb[0], pb[1]);
            } else {
                double[] t = new double[3];
                double d = a[2] / (a[2] - b[2]);
                t[0] = (b[0] - a[0]) * d + a[0];
                t[1] = (b[1] - a[1]) * d + a[1];
                double[] pt = this.project(t);
                before.lineTo(pt[0], pt[1]);
                behind.moveTo(pt[0], pt[1]);
                behind.lineTo(pb[0], pb[1]);
                this.intersectionPoints.add(new double[]{pt[0], pt[1]});
            }
        } else {
            behind.moveTo(pa[0], pa[1]);
            if (b[2] > 0.0) {
                behind.lineTo(pb[0], pb[1]);
            } else {
                double[] t = new double[3];
                double d = a[2] / (a[2] - b[2]);
                t[0] = (b[0] - a[0]) * d + a[0];
                t[1] = (b[1] - a[1]) * d + a[1];
                double[] pt = this.project(t);
                behind.lineTo(pt[0], pt[1]);
                before.moveTo(pt[0], pt[1]);
                before.lineTo(pb[0], pb[1]);
                this.intersectionPoints.add(new double[]{pt[0], pt[1]});
            }
        }
    }

    public void renderBox(RealInterval sourceInterval, AffineTransform3D transform, GeneralPath front, GeneralPath back, GeneralPath intersection) {
        for (int i = 0; i < 8; ++i) {
            transform.apply(IntervalCorners.corner(sourceInterval, i), this.corners[i]);
            this.project(this.corners[i], this.projectedCorners[i]);
        }
        this.intersectionPoints.clear();
        this.splitEdge(0, 1, front, back);
        this.splitEdge(2, 3, front, back);
        this.splitEdge(4, 5, front, back);
        this.splitEdge(6, 7, front, back);
        this.splitEdge(0, 2, front, back);
        this.splitEdge(1, 3, front, back);
        this.splitEdge(4, 6, front, back);
        this.splitEdge(5, 7, front, back);
        this.splitEdge(0, 4, front, back);
        this.splitEdge(1, 5, front, back);
        this.splitEdge(2, 6, front, back);
        this.splitEdge(3, 7, front, back);
        if (this.intersectionPoints.size() > 2) {
            double x0 = this.intersectionPoints.stream().mapToDouble(e -> e[0]).average().getAsDouble();
            double y0 = this.intersectionPoints.stream().mapToDouble(e -> e[1]).average().getAsDouble();
            this.intersectionPoints.sort(new PolarOrder(new double[]{x0, y0}));
            Iterator<double[]> hull = this.intersectionPoints.iterator();
            if (hull.hasNext()) {
                double[] first = hull.next();
                intersection.moveTo(first[0], first[1]);
                while (hull.hasNext()) {
                    double[] next = hull.next();
                    intersection.lineTo(next[0], next[1]);
                }
                intersection.closePath();
            }
        }
    }

    private static final class PolarOrder
    implements Comparator<double[]> {
        private final double[] p;

        public PolarOrder(double[] p) {
            this.p = p;
        }

        @Override
        public int compare(double[] q1, double[] q2) {
            double dx1 = q1[0] - this.p[0];
            double dy1 = q1[1] - this.p[1];
            double dx2 = q2[0] - this.p[0];
            double dy2 = q2[1] - this.p[1];
            if (dy1 >= 0.0 && dy2 < 0.0) {
                return -1;
            }
            if (dy2 >= 0.0 && dy1 < 0.0) {
                return 1;
            }
            if (dy1 == 0.0 && dy2 == 0.0) {
                if (dx1 >= 0.0 && dx2 < 0.0) {
                    return -1;
                }
                if (dx2 >= 0.0 && dx1 < 0.0) {
                    return 1;
                }
                return 0;
            }
            return -PolarOrder.ccw(this.p, q1, q2);
        }

        private static int ccw(double[] a, double[] b, double[] c) {
            double area2 = (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
            if (area2 < 0.0) {
                return -1;
            }
            if (area2 > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

