/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.brightness;

import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mpicbg.spim.data.XmlHelpers;
import net.imglib2.type.numeric.ARGBType;
import org.jdom2.Content;
import org.jdom2.Element;

@Deprecated
public class SetupAssignments {
    private final ArrayList<ConverterSetup> setups;
    private final ArrayList<MinMaxGroup> minMaxGroups;
    private final Map<ConverterSetup, MinMaxGroup> setupToGroup;
    private final double fullRangeMin;
    private final double fullRangeMax;
    private final double defaultRangeMin;
    private final double defaultRangeMax;
    private static final double minIntervalSize = 0.0;
    private UpdateListener updateListener;
    private static final WeakHashMap<SetupAssignments, Integer> maxIds = new WeakHashMap();
    private static final SetupAssignments nullSetupAssignmentsKey = new SetupAssignments(new ArrayList<ConverterSetup>(), 0.0, 1.0);

    public SetupAssignments(ArrayList<ConverterSetup> converterSetups, double defaultRangeMin, double defaultRangeMax) {
        this(converterSetups, -2.147483648E9, 2.147483647E9, defaultRangeMin, defaultRangeMax);
    }

    public SetupAssignments(ArrayList<ConverterSetup> converterSetups, double fullRangeMin, double fullRangeMax, double defaultRangeMin, double defaultRangeMax) {
        this.setups = new ArrayList<ConverterSetup>(converterSetups);
        this.minMaxGroups = new ArrayList();
        this.setupToGroup = new HashMap<ConverterSetup, MinMaxGroup>();
        this.fullRangeMin = fullRangeMin;
        this.fullRangeMax = fullRangeMax;
        this.defaultRangeMin = defaultRangeMin;
        this.defaultRangeMax = defaultRangeMax;
        for (ConverterSetup setup : this.setups) {
            double displayRangeMin = Math.max(defaultRangeMin, Math.min(defaultRangeMax, setup.getDisplayRangeMin()));
            double displayRangeMax = Math.max(defaultRangeMin, Math.min(defaultRangeMax, setup.getDisplayRangeMax()));
            if (setup.getDisplayRangeMin() != displayRangeMin || setup.getDisplayRangeMax() != displayRangeMax) {
                setup.setDisplayRange(displayRangeMin, displayRangeMax);
            }
            MinMaxGroup group = new MinMaxGroup(fullRangeMin, fullRangeMax, defaultRangeMin, defaultRangeMax, displayRangeMin, displayRangeMax, 0.0);
            this.minMaxGroups.add(group);
            this.setupToGroup.put(setup, group);
            group.addSetup(setup);
        }
        this.updateListener = null;
    }

    public void moveSetupToGroup(ConverterSetup setup, MinMaxGroup group) {
        MinMaxGroup oldGroup = this.setupToGroup.get(setup);
        if (oldGroup == group) {
            return;
        }
        this.setupToGroup.put(setup, group);
        group.addSetup(setup);
        boolean oldGroupIsEmpty = oldGroup.removeSetup(setup);
        if (oldGroupIsEmpty) {
            this.minMaxGroups.remove(oldGroup);
        }
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public boolean removeSetupFromGroup(ConverterSetup setup, MinMaxGroup group) {
        if (this.setupToGroup.get(setup) != group) {
            return false;
        }
        if (group.setups.size() == 1) {
            return false;
        }
        MinMaxGroup newGroup = new MinMaxGroup(group.getFullRangeMin(), group.getFullRangeMax(), group.getRangeMin(), group.getRangeMax(), setup.getDisplayRangeMin(), setup.getDisplayRangeMax(), 0.0);
        this.minMaxGroups.add(newGroup);
        this.setupToGroup.put(setup, newGroup);
        newGroup.addSetup(setup);
        boolean groupIsEmpty = group.removeSetup(setup);
        if (groupIsEmpty) {
            this.minMaxGroups.remove(group);
        }
        if (this.updateListener != null) {
            this.updateListener.update();
        }
        return true;
    }

    public void setUpdateListener(UpdateListener l) {
        this.updateListener = l;
    }

    public List<MinMaxGroup> getMinMaxGroups() {
        return Collections.unmodifiableList(this.minMaxGroups);
    }

    public List<ConverterSetup> getConverterSetups() {
        return Collections.unmodifiableList(this.setups);
    }

    public MinMaxGroup getMinMaxGroup(ConverterSetup setup) {
        return this.setupToGroup.get(setup);
    }

    public void addSetup(ConverterSetup setup) {
        MinMaxGroup group = new MinMaxGroup(this.fullRangeMin, this.fullRangeMax, this.defaultRangeMin, this.defaultRangeMax, setup.getDisplayRangeMin(), setup.getDisplayRangeMax(), 0.0);
        this.minMaxGroups.add(group);
        this.setupToGroup.put(setup, group);
        group.addSetup(setup);
        this.setups.add(setup);
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public void removeSetup(ConverterSetup setup) {
        MinMaxGroup group = this.setupToGroup.get(setup);
        if (group == null) {
            return;
        }
        boolean groupIsEmpty = group.removeSetup(setup);
        if (groupIsEmpty) {
            this.minMaxGroups.remove(group);
        }
        this.setups.remove(setup);
        this.setupToGroup.remove(setup);
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    public Element toXml() {
        Element elem = new Element("SetupAssignments");
        Element elemConverterSetups = new Element("ConverterSetups");
        for (ConverterSetup setup : this.setups) {
            Element elemConverterSetup = new Element("ConverterSetup");
            elemConverterSetup.addContent((Content)XmlHelpers.intElement((String)"id", (int)setup.getSetupId()));
            elemConverterSetup.addContent((Content)XmlHelpers.doubleElement((String)"min", (double)setup.getDisplayRangeMin()));
            elemConverterSetup.addContent((Content)XmlHelpers.doubleElement((String)"max", (double)setup.getDisplayRangeMax()));
            elemConverterSetup.addContent((Content)XmlHelpers.intElement((String)"color", (int)setup.getColor().get()));
            elemConverterSetup.addContent((Content)XmlHelpers.intElement((String)"groupId", (int)this.minMaxGroups.indexOf(this.setupToGroup.get(setup))));
            elemConverterSetups.addContent((Content)elemConverterSetup);
        }
        elem.addContent((Content)elemConverterSetups);
        Element elemMinMaxGroups = new Element("MinMaxGroups");
        for (int i = 0; i < this.minMaxGroups.size(); ++i) {
            MinMaxGroup group = this.minMaxGroups.get(i);
            Element elemMinMaxGroup = new Element("MinMaxGroup");
            elemMinMaxGroup.addContent((Content)XmlHelpers.intElement((String)"id", (int)i));
            elemMinMaxGroup.addContent((Content)XmlHelpers.doubleElement((String)"fullRangeMin", (double)group.getFullRangeMin()));
            elemMinMaxGroup.addContent((Content)XmlHelpers.doubleElement((String)"fullRangeMax", (double)group.getFullRangeMax()));
            elemMinMaxGroup.addContent((Content)XmlHelpers.doubleElement((String)"rangeMin", (double)group.getRangeMin()));
            elemMinMaxGroup.addContent((Content)XmlHelpers.doubleElement((String)"rangeMax", (double)group.getRangeMax()));
            elemMinMaxGroup.addContent((Content)XmlHelpers.doubleElement((String)"currentMin", (double)group.getMinBoundedValue().getCurrentValue()));
            elemMinMaxGroup.addContent((Content)XmlHelpers.doubleElement((String)"currentMax", (double)group.getMaxBoundedValue().getCurrentValue()));
            elemMinMaxGroups.addContent((Content)elemMinMaxGroup);
        }
        elem.addContent((Content)elemMinMaxGroups);
        return elem;
    }

    public void restoreFromXml(Element parent) {
        int id;
        Element elemSetupAssignments = parent.getChild("SetupAssignments");
        if (elemSetupAssignments == null) {
            return;
        }
        Element elemConverterSetups = elemSetupAssignments.getChild("ConverterSetups");
        List converterSetupNodes = elemConverterSetups.getChildren("ConverterSetup");
        if (converterSetupNodes.size() != this.setups.size()) {
            throw new IllegalArgumentException();
        }
        Element elemMinMaxGroups = elemSetupAssignments.getChild("MinMaxGroups");
        List minMaxGroupNodes = elemMinMaxGroups.getChildren("MinMaxGroup");
        this.minMaxGroups.clear();
        for (int i = 0; i < minMaxGroupNodes.size(); ++i) {
            this.minMaxGroups.add(null);
        }
        for (Element elem : minMaxGroupNodes) {
            id = Integer.parseInt(elem.getChildText("id"));
            double fullRangeMin = Double.parseDouble(elem.getChildText("fullRangeMin"));
            double fullRangeMax = Double.parseDouble(elem.getChildText("fullRangeMax"));
            double rangeMin = Double.parseDouble(elem.getChildText("rangeMin"));
            double rangeMax = Double.parseDouble(elem.getChildText("rangeMax"));
            double currentMin = Double.parseDouble(elem.getChildText("currentMin"));
            double currentMax = Double.parseDouble(elem.getChildText("currentMax"));
            this.minMaxGroups.set(id, new MinMaxGroup(fullRangeMin, fullRangeMax, rangeMin, rangeMax, currentMin, currentMax, 0.0));
        }
        for (Element elem : converterSetupNodes) {
            id = Integer.parseInt(elem.getChildText("id"));
            double min = Double.parseDouble(elem.getChildText("min"));
            double max = Double.parseDouble(elem.getChildText("max"));
            int color = Integer.parseInt(elem.getChildText("color"));
            int groupId = Integer.parseInt(elem.getChildText("groupId"));
            ConverterSetup setup = this.getSetupById(id);
            setup.setDisplayRange(min, max);
            setup.setColor(new ARGBType(color));
            MinMaxGroup group = this.minMaxGroups.get(groupId);
            this.setupToGroup.put(setup, group);
            group.addSetup(setup);
        }
        if (this.updateListener != null) {
            this.updateListener.update();
        }
    }

    private ConverterSetup getSetupById(int id) {
        for (ConverterSetup setup : this.setups) {
            if (setup.getSetupId() != id) continue;
            return setup;
        }
        return null;
    }

    public static synchronized int getUnusedSetupId(SetupAssignments setupAssignments) {
        if (setupAssignments == null) {
            setupAssignments = nullSetupAssignmentsKey;
        }
        int maxId = maxIds.getOrDefault(setupAssignments, 0);
        for (ConverterSetup setup : setupAssignments.getConverterSetups()) {
            maxId = Math.max(setup.getSetupId(), maxId);
        }
        maxIds.put(setupAssignments, ++maxId);
        return maxId;
    }

    public static interface UpdateListener {
        public void update();
    }
}

