/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.transformation;

import bdv.tools.transformation.ManualTransformActiveListener;
import bdv.tools.transformation.TransformedSource;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerState;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.RunnableAction;

public class ManualTransformationEditor
implements TransformListener<AffineTransform3D> {
    private boolean active = false;
    private final InputActionBindings bindings;
    private final AffineTransform3D frozenTransform;
    private final AffineTransform3D liveTransform;
    private final ArrayList<TransformedSource<?>> sourcesToModify;
    private final ArrayList<TransformedSource<?>> sourcesToFix;
    private final ActionMap actionMap;
    private final InputMap inputMap;
    private final Listeners.List<ManualTransformActiveListener> manualTransformActiveListeners;
    private final Listeners<TransformListener<AffineTransform3D>> viewerTransformListeners;
    private final ViewerState viewerState;
    private final Consumer<String> viewerMessageDisplay;

    public ManualTransformationEditor(AbstractViewerPanel viewer, InputActionBindings inputActionBindings) {
        this(viewer.transformListeners(), viewer.state(), viewer::showMessage, inputActionBindings);
    }

    public ManualTransformationEditor(Listeners<TransformListener<AffineTransform3D>> viewerTransformListeners, ViewerState viewerState, Consumer<String> viewerMessageDisplay, InputActionBindings inputActionBindings) {
        this.viewerTransformListeners = viewerTransformListeners;
        this.viewerState = viewerState;
        this.viewerMessageDisplay = viewerMessageDisplay;
        this.bindings = inputActionBindings;
        this.frozenTransform = new AffineTransform3D();
        this.liveTransform = new AffineTransform3D();
        this.sourcesToModify = new ArrayList();
        this.sourcesToFix = new ArrayList();
        this.manualTransformActiveListeners = new Listeners.SynchronizedList();
        KeyStroke abortKey = KeyStroke.getKeyStroke(27, 0);
        RunnableAction abortAction = new RunnableAction("abort manual transformation", this::abort);
        KeyStroke resetKey = KeyStroke.getKeyStroke(82, 0);
        RunnableAction resetAction = new RunnableAction("reset manual transformation", this::reset);
        this.actionMap = new ActionMap();
        this.inputMap = new InputMap();
        this.actionMap.put("abort manual transformation", (Action)abortAction);
        this.inputMap.put(abortKey, "abort manual transformation");
        this.actionMap.put("reset manual transformation", (Action)resetAction);
        this.inputMap.put(resetKey, "reset manual transformation");
        this.bindings.addActionMap("manual transform", this.actionMap);
    }

    public synchronized void abort() {
        if (this.active) {
            AffineTransform3D identity = new AffineTransform3D();
            for (TransformedSource<?> source : this.sourcesToModify) {
                source.setIncrementalTransform(identity);
            }
            this.viewerState.setViewerTransform(this.frozenTransform);
            this.viewerMessageDisplay.accept("aborted manual transform");
            this.active = false;
            this.manualTransformActiveListeners.list.forEach(l -> l.manualTransformActiveChanged(this.active));
        }
    }

    public synchronized void reset() {
        if (this.active) {
            AffineTransform3D identity = new AffineTransform3D();
            for (TransformedSource<?> source : this.sourcesToModify) {
                source.setIncrementalTransform(identity);
                source.setFixedTransform(identity);
            }
            for (TransformedSource<?> source : this.sourcesToFix) {
                source.setIncrementalTransform(identity);
            }
            this.viewerState.setViewerTransform(this.frozenTransform);
            this.viewerMessageDisplay.accept("reset manual transform");
        }
    }

    public synchronized void setActive(boolean a) {
        if (this.active == a) {
            return;
        }
        if (a) {
            ViewerState state = this.viewerState.snapshot();
            ArrayList currentSources = new ArrayList();
            switch (state.getDisplayMode()) {
                case FUSED: {
                    currentSources.add(state.getCurrentSource());
                    break;
                }
                case FUSEDGROUP: {
                    currentSources.addAll(state.getSourcesInGroup(state.getCurrentGroup()));
                    break;
                }
                default: {
                    this.viewerMessageDisplay.accept("Can only do manual transformation when in FUSED mode.");
                    return;
                }
            }
            state.getViewerTransform(this.frozenTransform);
            this.sourcesToModify.clear();
            this.sourcesToFix.clear();
            for (SourceAndConverter<?> source : state.getSources()) {
                if (!(source.getSpimSource() instanceof TransformedSource)) continue;
                if (currentSources.contains(source)) {
                    this.sourcesToModify.add((TransformedSource)source.getSpimSource());
                    continue;
                }
                this.sourcesToFix.add((TransformedSource)source.getSpimSource());
            }
            this.active = true;
            this.viewerTransformListeners.add((Object)this);
            this.bindings.addInputMap("manual transform", this.inputMap, new String[0]);
            this.viewerMessageDisplay.accept("starting manual transform");
        } else {
            this.active = false;
            this.viewerTransformListeners.remove((Object)this);
            this.bindings.removeInputMap("manual transform");
            AffineTransform3D tmp = new AffineTransform3D();
            for (TransformedSource<?> source : this.sourcesToModify) {
                tmp.identity();
                source.setIncrementalTransform(tmp);
                source.getFixedTransform(tmp);
                tmp.preConcatenate(this.liveTransform);
                source.setFixedTransform(tmp);
            }
            tmp.identity();
            for (TransformedSource<?> source : this.sourcesToFix) {
                source.setIncrementalTransform(tmp);
            }
            this.viewerState.setViewerTransform(this.frozenTransform);
            this.viewerMessageDisplay.accept("fixed manual transform");
        }
        this.manualTransformActiveListeners.list.forEach(l -> l.manualTransformActiveChanged(this.active));
    }

    public synchronized void toggle() {
        this.setActive(!this.active);
    }

    @Override
    public void transformChanged(AffineTransform3D transform) {
        if (!this.active) {
            return;
        }
        this.liveTransform.set(transform);
        this.liveTransform.preConcatenate(this.frozenTransform.inverse());
        for (TransformedSource<?> source : this.sourcesToFix) {
            source.setIncrementalTransform(this.liveTransform.inverse());
        }
    }

    public Listeners<ManualTransformActiveListener> manualTransformActiveListeners() {
        return this.manualTransformActiveListeners;
    }
}

