/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.keymap;

import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapsListData;
import bdv.ui.settings.style.AbstractStyleManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.InputTriggerDescriptionsBuilder;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public abstract class AbstractKeymapManager<T extends AbstractKeymapManager<T>>
extends AbstractStyleManager<T, Keymap> {
    private final Keymap forwardSelectedKeymap = new Keymap();

    @Override
    public synchronized void setSelectedStyle(Keymap keymap) {
        super.setSelectedStyle(keymap);
        this.forwardSelectedKeymap.set((Keymap)this.selectedStyle);
    }

    public Keymap getForwardSelectedKeymap() {
        return this.forwardSelectedKeymap;
    }

    protected void loadStyles(File directory) throws IOException {
        this.userStyles.clear();
        Set names = this.builtinStyles.stream().map(Keymap::getName).collect(Collectors.toSet());
        Keymap selectedStyle = (Keymap)this.builtinStyles.get(0);
        File file = new File(directory, "/keymaps.yaml");
        KeymapsListData keymapsList = null;
        try (FileReader input = new FileReader(file);){
            keymapsList = (KeymapsListData)AbstractKeymapManager.createYaml().loadAs((Reader)input, KeymapsListData.class);
        }
        catch (FileNotFoundException e) {
            System.out.println("Keymap list file " + file + " not found. Using builtin styles.");
        }
        if (keymapsList != null) {
            for (Map.Entry<String, String> entry : keymapsList.getFileNameToKeymapName().entrySet()) {
                file = new File(directory, entry.getKey());
                try {
                    FileReader reader = new FileReader(file);
                    Throwable throwable = null;
                    try {
                        String name = entry.getValue();
                        InputTriggerConfig config = new InputTriggerConfig((Collection)YamlConfigIO.read((Reader)reader));
                        if (names.add(name)) {
                            this.userStyles.add(new Keymap(name, config));
                            continue;
                        }
                        System.out.println("Discarded style with duplicate name \"" + name + "\".");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (FileNotFoundException e) {
                    System.out.println("Keymap file " + file + " not found. Skipping.");
                }
            }
            selectedStyle = this.styleForName(keymapsList.defaultKeymapName).orElse(selectedStyle);
        }
        this.setSelectedStyle(selectedStyle);
    }

    protected void saveStyles(File directory) throws IOException {
        directory.mkdirs();
        KeymapsListData keymapsList = new KeymapsListData(((Keymap)this.selectedStyle).getName(), this.userStyles.stream().map(Keymap::getName).collect(Collectors.toList()));
        File file = new File(directory, "keymaps.yaml");
        try (FileWriter writer = new FileWriter(file);){
            AbstractKeymapManager.createYaml().dump((Object)keymapsList, (Writer)writer);
        }
        for (Keymap keymap : this.userStyles) {
            List descriptions = new InputTriggerDescriptionsBuilder(keymap.getConfig()).getDescriptions();
            file = new File(directory, keymapsList.keymapNameToFileName.get(keymap.getName()));
            FileWriter writer = new FileWriter(file);
            Throwable throwable = null;
            try {
                YamlConfigIO.write((Iterable)descriptions, (Writer)writer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    private static Yaml createYaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer();
        representer.addClassTag(KeymapsListData.class, new Tag("!keymapslist"));
        Constructor constructor = new Constructor();
        constructor.addTypeDescription(new TypeDescription(KeymapsListData.class, "!keymapslist"));
        return new Yaml((BaseConstructor)constructor, representer, dumperOptions);
    }
}

