/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.SourceBounds;
import bdv.viewer.render.Tile;
import bdv.viewer.render.VisibleSourcesOnScreenBounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class Tiling {
    public static int MIN_TILE_SIZE = 64;
    public static int MAX_TILE_SIZE = 1024;
    public static int MIN_ACCUMULATE_FORK_SIZE = 64;

    public static List<Tile> findTiles(VisibleSourcesOnScreenBounds onScreenBounds) {
        List<SourceBounds> bounds = onScreenBounds.sourceBoundsForVisibleSource();
        List<SourceAndConverter<?>> alwaysVisibleSources = onScreenBounds.alwaysVisibleSources();
        Tile tile = new Tile(bounds, alwaysVisibleSources, onScreenBounds.screenInterval());
        List<Tile> tiles = Tiling.split(tile);
        return tiles;
    }

    private static List<Tile> split(Tile tile) {
        int tileSizeY;
        int tileSizeX = tile.tileSizeX();
        if (tileSizeX * (tileSizeY = tile.tileSizeY()) <= MIN_TILE_SIZE) {
            return Collections.singletonList(tile);
        }
        Function<Tile[], List> splitRecursively = tiles -> {
            ArrayList<Tile> result = new ArrayList<Tile>(Tiling.split(tiles[0]));
            result.addAll(Tiling.split(tiles[1]));
            return result;
        };
        int dimension = tileSizeX > tileSizeY ? 0 : 1;
        int[] candidates = tile.splitCandidates(dimension);
        if (candidates.length > 0) {
            int bound = candidates[candidates.length / 2];
            return splitRecursively.apply(Tiling.split(tile, bound, dimension));
        }
        dimension = tileSizeX > tileSizeY ? 1 : 0;
        candidates = tile.splitCandidates(dimension);
        if (candidates.length > 0) {
            int bound = candidates[candidates.length / 2];
            return splitRecursively.apply(Tiling.split(tile, bound, dimension));
        }
        return Collections.singletonList(tile);
    }

    public static List<Tile> splitForRendering(List<Tile> tiles) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            Tiling.splitForTargetSizeY(tile, MAX_TILE_SIZE, result);
        }
        return result;
    }

    private static void splitForTargetSizeY(Tile tile, int targetSize, List<Tile> splitTiles) {
        int tileSizeY;
        int tileSizeX = tile.tileSizeX();
        int size = tileSizeX * (tileSizeY = tile.tileSizeY());
        if (size < targetSize) {
            splitTiles.add(tile);
            return;
        }
        double numTiles = Math.ceil((double)size / (double)targetSize);
        int h = (int)Math.ceil((double)tileSizeY / numTiles);
        List<SourceBounds> bounds = tile.sourceBounds();
        List<SourceAndConverter<?>> alwaysVisibleSources = tile.alwaysVisibleSources();
        int minX = tile.tileMinX();
        int maxX = tile.tileMaxX();
        for (int y = 0; y < tileSizeY; y += h) {
            int minY = tile.tileMinY() + y;
            int maxY = Math.min(tile.tileMaxY(), minY + h - 1);
            splitTiles.add(new Tile(bounds, alwaysVisibleSources, minX, minY, maxX, maxY));
        }
    }

    private static void splitForTargetSize(Tile tile, int targetSize, List<Tile> splitTiles) {
        int bound;
        int dimension;
        int tileSizeY;
        int tileSizeX = tile.tileSizeX();
        int size = tileSizeX * (tileSizeY = tile.tileSizeY());
        if (size < targetSize) {
            splitTiles.add(tile);
            return;
        }
        if (tileSizeX > tileSizeY) {
            dimension = 0;
            bound = tile.tileMinX() + tileSizeX / 2;
        } else {
            dimension = 1;
            bound = tile.tileMinY() + tileSizeY / 2;
        }
        Tile[] tiles = Tiling.split(tile, bound, dimension);
        Tiling.splitForTargetSize(tiles[0], targetSize, splitTiles);
        Tiling.splitForTargetSize(tiles[1], targetSize, splitTiles);
    }

    private static Tile[] split(Tile tile, int bound, int d) {
        ArrayList<SourceBounds> lowerSourceBounds = new ArrayList<SourceBounds>();
        ArrayList<SourceBounds> upperSourceBounds = new ArrayList<SourceBounds>();
        ToIntFunction<SourceBounds> min = d == 0 ? SourceBounds::minX : SourceBounds::minY;
        ToIntFunction<SourceBounds> max = d == 0 ? SourceBounds::maxX : SourceBounds::maxY;
        for (SourceBounds bounds : tile.sourceBounds()) {
            if (max.applyAsInt(bounds) < bound) {
                lowerSourceBounds.add(bounds);
                continue;
            }
            if (min.applyAsInt(bounds) >= bound) {
                upperSourceBounds.add(bounds);
                continue;
            }
            lowerSourceBounds.add(bounds);
            upperSourceBounds.add(bounds);
        }
        int lowerMinX = tile.tileMinX();
        int lowerMinY = tile.tileMinY();
        int lowerMaxX = d == 0 ? bound - 1 : tile.tileMaxX();
        int lowerMaxY = d == 1 ? bound - 1 : tile.tileMaxY();
        int upperMinX = d == 0 ? bound : tile.tileMinX();
        int upperMinY = d == 1 ? bound : tile.tileMinY();
        int upperMaxX = tile.tileMaxX();
        int upperMaxY = tile.tileMaxY();
        return new Tile[]{new Tile(lowerSourceBounds, tile.alwaysVisibleSources(), lowerMinX, lowerMinY, lowerMaxX, lowerMaxY), new Tile(upperSourceBounds, tile.alwaysVisibleSources(), upperMinX, upperMinY, upperMaxX, upperMaxY)};
    }
}

