/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.util.MipmapTransforms;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bdv.viewer.render.ScreenScales;
import bdv.viewer.render.SourceBounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;

class VisibleSourcesOnScreenBounds {
    private final List<SourceBounds> bounds = new ArrayList<SourceBounds>();
    private final List<SourceAndConverter<?>> unculledSources = new ArrayList();
    private final int screenMinX;
    private final int screenMinY;
    private final int screenMaxX;
    private final int screenMaxY;

    public VisibleSourcesOnScreenBounds(ViewerState viewerState, ScreenScales.ScreenScale screenScale) {
        this(viewerState, (Interval)Intervals.createMinSize((long[])new long[]{0L, 0L, screenScale.width(), screenScale.height()}), viewerState.getViewerTransform().preConcatenate(screenScale.scaleTransform()));
    }

    public VisibleSourcesOnScreenBounds(ViewerState viewerState, Interval screenInterval, AffineTransform3D screenTransform) {
        this.screenMinX = (int)screenInterval.min(0);
        this.screenMinY = (int)screenInterval.min(1);
        this.screenMaxX = (int)screenInterval.max(0);
        this.screenMaxY = (int)screenInterval.max(1);
        Set<SourceAndConverter<?>> sources = viewerState.getVisibleAndPresentSources();
        int t = viewerState.getCurrentTimepoint();
        double expand = viewerState.getInterpolation() == Interpolation.NEARESTNEIGHBOR ? 0.5 : 1.0;
        AffineTransform3D sourceToScreen = new AffineTransform3D();
        double[] sourceMin = new double[3];
        double[] sourceMax = new double[3];
        for (SourceAndConverter<?> source : sources) {
            if (!source.getSpimSource().doBoundingBoxCulling()) {
                this.unculledSources.add(source);
                continue;
            }
            Source<?> spimSource = source.getSpimSource();
            int level = MipmapTransforms.getBestMipMapLevel(screenTransform, spimSource, t);
            spimSource.getSourceTransform(t, level, sourceToScreen);
            sourceToScreen.preConcatenate(screenTransform);
            RandomAccessibleInterval<?> interval = spimSource.getSource(t, level);
            for (int d = 0; d < 3; ++d) {
                sourceMin[d] = interval.realMin(d) - expand;
                sourceMax[d] = interval.realMax(d) + expand;
            }
            FinalRealInterval bb = sourceToScreen.estimateBounds((RealInterval)new FinalRealInterval(sourceMin, sourceMax));
            if (!(bb.realMax(0) >= (double)this.screenMinX) || !(bb.realMin(0) <= (double)this.screenMaxX) || !(bb.realMax(1) >= (double)this.screenMinY) || !(bb.realMin(1) <= (double)this.screenMaxY) || !(bb.realMax(2) >= 0.0) || !(bb.realMin(2) <= 0.0)) continue;
            int minX = (int)Math.floor(bb.realMin(0));
            int maxX = (int)Math.ceil(bb.realMax(0));
            int minY = (int)Math.floor(bb.realMin(1));
            int maxY = (int)Math.ceil(bb.realMax(1));
            this.bounds.add(new SourceBounds(source, minX, minY, maxX, maxY));
        }
    }

    public List<SourceBounds> sourceBoundsForVisibleSource() {
        return this.bounds;
    }

    public List<SourceAndConverter<?>> alwaysVisibleSources() {
        return this.unculledSources;
    }

    public Interval screenInterval() {
        return Intervals.createMinMax((long[])new long[]{this.screenMinX, this.screenMinY, this.screenMaxX, this.screenMaxY});
    }

    public int estimateNumRenderedPixels() {
        int numPixels = 0;
        for (SourceBounds sourceBounds : this.bounds) {
            int minX = Math.max(sourceBounds.minX(), this.screenMinX);
            int minY = Math.max(sourceBounds.minY(), this.screenMinY);
            int maxX = Math.min(sourceBounds.maxX(), this.screenMaxX);
            int maxY = Math.min(sourceBounds.maxY(), this.screenMaxY);
            int sizeX = maxX - minX + 1;
            int sizeY = maxY - minY + 1;
            numPixels += sizeX * sizeY;
        }
        return numPixels += this.unculledSources.size() * (this.screenMaxX - this.screenMinX + 1) * (this.screenMaxY - this.screenMinY + 1);
    }

    public double estimateNumSourcesPerPixel() {
        int screenSize = (this.screenMaxX - this.screenMinX + 1) * (this.screenMaxY - this.screenMinY + 1);
        return (double)this.estimateNumRenderedPixels() / (double)screenSize;
    }
}

