/*
 * Decompiled with CFR 0.152.
 */
package bdv;

import bdv.ViewerImgLoader;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.UncheckedCache;
import net.imglib2.cache.ref.BoundedSoftRefLoaderCache;
import net.imglib2.cache.util.Caches;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public abstract class AbstractSpimSource<T extends NumericType<T>>
implements Source<T> {
    protected int currentTimePointIndex;
    protected boolean currentTimePointIsPresent;
    protected final AffineTransform3D[] currentSourceTransforms;
    protected final int setupId;
    protected final String name;
    protected final List<TimePoint> timePointsOrdered;
    protected final Map<ViewId, ViewRegistration> viewRegistrations;
    protected final Set<ViewId> missingViews;
    protected final VoxelDimensions voxelDimensions;
    protected final int numMipmapLevels;
    protected static final int numInterpolationMethods = 2;
    protected static final int iNearestNeighborMethod = 0;
    protected static final int iNLinearMethod = 1;
    protected final InterpolatorFactory<T, RandomAccessible<T>>[] interpolatorFactories;
    protected final UncheckedCache<ImgKey, RandomAccessibleInterval<T>> cachedSources;
    protected final UncheckedCache<ImgKey, RealRandomAccessible<T>> cachedInterpolatedSources;

    public AbstractSpimSource(AbstractSpimData<?> spimData, int setupId, String name) {
        this.setupId = setupId;
        this.name = name;
        AbstractSequenceDescription seq = spimData.getSequenceDescription();
        this.timePointsOrdered = seq.getTimePoints().getTimePointsOrdered();
        this.viewRegistrations = spimData.getViewRegistrations().getViewRegistrations();
        this.missingViews = seq.getMissingViews() == null ? new HashSet() : seq.getMissingViews().getMissingViews();
        this.voxelDimensions = ((BasicViewSetup)seq.getViewSetups().get(setupId)).getVoxelSize();
        this.numMipmapLevels = ((ViewerImgLoader)seq.getImgLoader()).getSetupImgLoader(setupId).numMipmapLevels();
        this.interpolatorFactories = new InterpolatorFactory[2];
        this.interpolatorFactories[0] = new NearestNeighborInterpolatorFactory();
        this.interpolatorFactories[1] = new ClampingNLinearInterpolatorFactory();
        CacheLoader loader = key -> this.getImage(this.timePointsOrdered.get(key.timepoint).getId(), key.level);
        this.cachedSources = Caches.unchecked((Cache)Caches.withLoader((LoaderCache)new BoundedSoftRefLoaderCache(3 * this.numMipmapLevels), (CacheLoader)loader));
        CacheLoader interpolLoader = key -> {
            NumericType zero = (NumericType)((NumericType)this.getType()).createVariable();
            zero.setZero();
            int i = key.method == Interpolation.NLINEAR ? 1 : 0;
            InterpolatorFactory<T, RandomAccessible<T>> factory = this.interpolatorFactories[i];
            return Views.interpolate((EuclideanSpace)Views.extendValue(this.getSource(key.timepoint, key.level), (Type)zero), factory);
        };
        this.cachedInterpolatedSources = Caches.unchecked((Cache)Caches.withLoader((LoaderCache)new BoundedSoftRefLoaderCache(3 * this.numMipmapLevels * 2), (CacheLoader)interpolLoader));
        this.currentSourceTransforms = new AffineTransform3D[this.numMipmapLevels];
        for (int level = 0; level < this.numMipmapLevels; ++level) {
            this.currentSourceTransforms[level] = new AffineTransform3D();
        }
    }

    protected void loadTimepoint(int timepointIndex) {
        this.currentTimePointIndex = timepointIndex;
        this.currentTimePointIsPresent = this.isPresent(timepointIndex);
        if (this.currentTimePointIsPresent) {
            int timepointId = this.timePointsOrdered.get(timepointIndex).getId();
            ViewId viewId = new ViewId(timepointId, this.setupId);
            AffineTransform3D reg = this.viewRegistrations.get(viewId).getModel();
            for (int level = 0; level < this.currentSourceTransforms.length; ++level) {
                AffineTransform3D mipmapTransform = this.getMipmapTransforms()[level];
                this.currentSourceTransforms[level].set(reg);
                this.currentSourceTransforms[level].concatenate(mipmapTransform);
            }
        } else {
            for (AffineTransform3D t : this.currentSourceTransforms) {
                t.identity();
            }
        }
    }

    protected abstract AffineTransform3D[] getMipmapTransforms();

    protected abstract RandomAccessibleInterval<T> getImage(int var1, int var2);

    @Override
    public boolean isPresent(int t) {
        return t >= 0 && t < this.timePointsOrdered.size() && !this.missingViews.contains(new ViewId(this.timePointsOrdered.get(t).getId(), this.setupId));
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return this.getSource(t, level, Thread.currentThread().getThreadGroup());
    }

    public synchronized RandomAccessibleInterval<T> getSource(int t, int level, ThreadGroup threadGroup) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentTimePointIsPresent ? (RandomAccessibleInterval)this.cachedSources.get((Object)new ImgKey(t, level, null, threadGroup)) : null;
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.getInterpolatedSource(t, level, method, Thread.currentThread().getThreadGroup());
    }

    public synchronized RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method, ThreadGroup threadGroup) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentTimePointIsPresent ? (RealRandomAccessible)this.cachedInterpolatedSources.get((Object)new ImgKey(t, level, method, threadGroup)) : null;
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        transform.set(this.currentSourceTransforms[level]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.voxelDimensions;
    }

    @Override
    public int getNumMipmapLevels() {
        return this.numMipmapLevels;
    }

    public int getSetupId() {
        return this.setupId;
    }

    protected static class ImgKey {
        protected final int timepoint;
        protected final int level;
        protected final Interpolation method;
        protected final ThreadGroup threadGroup;
        private final int hashcode;

        public ImgKey(int timepoint, int level, Interpolation method, ThreadGroup threadGroup) {
            this.timepoint = timepoint;
            this.level = level;
            this.method = method;
            this.threadGroup = threadGroup;
            int hash = 31 * timepoint + level;
            if (method != null) {
                hash = 31 * hash + method.hashCode();
            }
            if (threadGroup != null) {
                hash = 31 * hash + threadGroup.hashCode();
            }
            this.hashcode = hash;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImgKey) {
                ImgKey other = (ImgKey)obj;
                return this.timepoint == other.timepoint && this.level == other.level && this.method == other.method && this.threadGroup == other.threadGroup;
            }
            return false;
        }
    }
}

