/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.CopyBlock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.imglib2.RandomAccess;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;

class CopyBlockInstances {
    private static ClassCopyProvider<CopyBlock> provider;

    CopyBlockInstances() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends RealType<T>> CopyBlock<T> create(int numDimensions, Class<?> pixelTypeClass, Class<?> inAccessClass) {
        if (provider == null) {
            Class<CopyBlockInstances> clazz = CopyBlockInstances.class;
            // MONITORENTER : bdv.export.CopyBlockInstances.class
            if (provider == null) {
                provider = new ClassCopyProvider(Imp.class, CopyBlock.class, new Class[]{Integer.TYPE});
            }
            // MONITOREXIT : clazz
        }
        List<Serializable> key = Arrays.asList(numDimensions, pixelTypeClass, inAccessClass);
        return (CopyBlock)provider.newInstanceForKey(key, new Object[]{numDimensions});
    }

    public static class Imp<T extends RealType<T>>
    implements CopyBlock<T> {
        private final int n;

        public Imp(int n) {
            if (n < 1 || n > 3) {
                throw new IllegalArgumentException();
            }
            this.n = n;
        }

        @Override
        public void copyBlock(RandomAccess<T> in, RandomAccess<T> out, int[] dimensions) {
            if (this.n == 3) {
                this.copyBlock3D(out, dimensions[0], dimensions[1], dimensions[2], in);
            } else if (this.n == 2) {
                this.copyBlock2D(out, dimensions[0], dimensions[1], in);
            } else {
                this.copyBlock1D(out, dimensions[0], in);
            }
        }

        private void copyBlock3D(RandomAccess<T> out, int sx, int sy, int sz, RandomAccess<T> in) {
            for (int z = 0; z < sz; ++z) {
                this.copyBlock2D(out, sx, sy, in);
                out.fwd(2);
                in.fwd(2);
            }
            out.move(-sz, 2);
            in.move(-sz, 2);
        }

        private void copyBlock2D(RandomAccess<T> out, int sx, int sy, RandomAccess<T> in) {
            for (int y = 0; y < sy; ++y) {
                this.copyBlock1D(out, sx, in);
                out.fwd(1);
                in.fwd(1);
            }
            out.move(-sy, 1);
            in.move(-sy, 1);
        }

        private void copyBlock1D(RandomAccess<T> out, int sx, RandomAccess<T> in) {
            for (int x = 0; x < sx; ++x) {
                ((RealType)out.get()).set((Type)in.get());
                out.fwd(0);
                in.fwd(0);
            }
            out.move(-sx, 0);
            in.move(-sx, 0);
        }
    }
}

