/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.IHDF5Access;
import bdv.img.hdf5.Util;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import java.lang.reflect.Field;

class HDF5AccessHack
implements IHDF5Access {
    private final IHDF5Writer hdf5Writer;
    private final long[] reorderedDimensions = new long[3];
    private final long[] reorderedOffset = new long[3];
    private final long fileId;
    private long dataSetId;
    private long fileSpaceId;

    public HDF5AccessHack(IHDF5Writer hdf5Writer) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        this.hdf5Writer = hdf5Writer;
        Class<?> k = Class.forName("ch.systemsx.cisd.hdf5.HDF5Writer");
        Field f = k.getDeclaredField("baseWriter");
        f.setAccessible(true);
        Object baseWriter = f.get(hdf5Writer);
        Class<?> k2 = Class.forName("ch.systemsx.cisd.hdf5.HDF5BaseReader");
        Field f2 = k2.getDeclaredField("fileId");
        f2.setAccessible(true);
        this.fileId = (Long)f2.get(baseWriter);
    }

    @Override
    public void writeMipmapDescription(int setupIdPartition, ExportMipmapInfo mipmapInfo) {
        this.hdf5Writer.writeDoubleMatrix(Util.getResolutionsPath(setupIdPartition), mipmapInfo.getResolutions());
        this.hdf5Writer.writeIntMatrix(Util.getSubdivisionsPath(setupIdPartition), mipmapInfo.getSubdivisions());
    }

    @Override
    public void closeDataset() {
        H5.H5Sclose((long)this.fileSpaceId);
        H5.H5Dclose((long)this.dataSetId);
    }

    @Override
    public void createAndOpenDataset(String path, long[] dimensions, int[] cellDimensions, HDF5IntStorageFeatures features) {
        this.hdf5Writer.int16().createMDArray(path, Util.reorder(dimensions), Util.reorder(cellDimensions), features);
        this.dataSetId = H5.H5Dopen((long)this.fileId, (String)path, (long)HDF5Constants.H5P_DEFAULT);
        this.fileSpaceId = H5.H5Dget_space((long)this.dataSetId);
    }

    @Override
    public void writeBlockWithOffset(short[] data, long[] blockDimensions, long[] offset) {
        Util.reorder(blockDimensions, this.reorderedDimensions);
        Util.reorder(offset, this.reorderedOffset);
        long memorySpaceId = H5.H5Screate_simple((int)this.reorderedDimensions.length, (long[])this.reorderedDimensions, null);
        H5.H5Sselect_hyperslab((long)this.fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.reorderedOffset, null, (long[])this.reorderedDimensions, null);
        H5.H5Dwrite((long)this.dataSetId, (long)HDF5Constants.H5T_NATIVE_INT16, (long)memorySpaceId, (long)this.fileSpaceId, (long)HDF5Constants.H5P_DEFAULT, (Object)data);
        H5.H5Sclose((long)memorySpaceId);
    }

    @Override
    public void close() {
        this.hdf5Writer.close();
    }

    @Override
    public IHDF5Writer getIHDF5Writer() {
        return this.hdf5Writer;
    }
}

