/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.IHDF5Access;
import bdv.img.hdf5.Util;
import bdv.img.hdf5.ViewLevelId;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;

class HDF5Access
implements IHDF5Access {
    private final IHDF5Reader hdf5Reader;
    private final int[] reorderedDimensions = new int[3];
    private final long[] reorderedMin = new long[3];

    public HDF5Access(IHDF5Reader hdf5Reader) {
        this.hdf5Reader = hdf5Reader;
    }

    @Override
    public synchronized DimsAndExistence getDimsAndExistence(ViewLevelId id) {
        String cellsPath = Util.getCellsPath(id);
        HDF5DataSetInformation info = null;
        boolean exists = false;
        try {
            info = this.hdf5Reader.getDataSetInformation(cellsPath);
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exists) {
            return new DimsAndExistence(Util.reorder(info.getDimensions()), true);
        }
        return new DimsAndExistence(new long[]{1L, 1L, 1L}, false);
    }

    @Override
    public synchronized short[] readShortMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        MDShortArray array = this.hdf5Reader.int16().readMDArrayBlockWithOffset(Util.getCellsPath(timepoint, setup, level), this.reorderedDimensions, this.reorderedMin);
        return array.getAsFlatArray();
    }

    @Override
    public short[] readShortMDArrayBlockWithOffset(int timepoint, int setup, int level, int[] dimensions, long[] min, short[] dataBlock) throws InterruptedException {
        System.arraycopy(this.readShortMDArrayBlockWithOffset(timepoint, setup, level, dimensions, min), 0, dataBlock, 0, dataBlock.length);
        return dataBlock;
    }

    @Override
    public float[] readShortMDArrayBlockWithOffsetAsFloat(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Util.reorder(dimensions, this.reorderedDimensions);
        Util.reorder(min, this.reorderedMin);
        MDFloatArray array = this.hdf5Reader.float32().readMDArrayBlockWithOffset(Util.getCellsPath(timepoint, setup, level), this.reorderedDimensions, this.reorderedMin);
        float[] pixels = array.getAsFlatArray();
        HDF5Access.unsignedShort(pixels);
        return pixels;
    }

    @Override
    public float[] readShortMDArrayBlockWithOffsetAsFloat(int timepoint, int setup, int level, int[] dimensions, long[] min, float[] dataBlock) throws InterruptedException {
        System.arraycopy(this.readShortMDArrayBlockWithOffsetAsFloat(timepoint, setup, level, dimensions, min), 0, dataBlock, 0, dataBlock.length);
        return dataBlock;
    }

    @Override
    public void closeAllDataSets() {
    }

    @Override
    public void close() {
        this.closeAllDataSets();
        this.hdf5Reader.close();
    }

    protected static final void unsignedShort(float[] pixels) {
        for (int j = 0; j < pixels.length; ++j) {
            pixels[j] = (short)pixels[j] & 0xFFFF;
        }
    }
}

