/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.cache.SharedQueue;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.hdf5.DimsAndExistence;
import bdv.img.hdf5.HDF5Access;
import bdv.img.hdf5.HDF5AccessHack;
import bdv.img.hdf5.Hdf5VolatileShortArrayLoader;
import bdv.img.hdf5.IHDF5Access;
import bdv.img.hdf5.MipmapInfo;
import bdv.img.hdf5.Partition;
import bdv.img.hdf5.Util;
import bdv.img.hdf5.ViewLevelId;
import bdv.util.ConstantRandomAccessible;
import bdv.util.MipmapTransforms;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.ImgLoaderHints;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.list.ListCursor;
import net.imglib2.img.list.ListImg;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class Hdf5ImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader {
    protected File hdf5File;
    protected IHDF5Reader existingHdf5Reader;
    protected IHDF5Access hdf5Access;
    protected VolatileGlobalCellCache cache;
    protected Hdf5VolatileShortArrayLoader shortLoader;
    protected final HashMap<Integer, SetupImgLoader> setupImgLoaders;
    protected final ArrayList<Partition> partitions;
    protected int maxNumLevels;
    protected final HashMap<ViewLevelId, DimsAndExistence> cachedDimsAndExistence;
    protected final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    private volatile boolean isOpen = false;
    private SharedQueue createdSharedQueue;
    private int requestedNumFetcherThreads = -1;
    private SharedQueue requestedSharedQueue;

    public Hdf5ImageLoader(File hdf5File, ArrayList<Partition> hdf5Partitions, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this(hdf5File, hdf5Partitions, sequenceDescription, false);
    }

    public Hdf5ImageLoader(File hdf5File, ArrayList<Partition> hdf5Partitions, AbstractSequenceDescription<?, ?, ?> sequenceDescription, boolean doOpen) {
        this(hdf5File, null, hdf5Partitions, sequenceDescription, doOpen);
    }

    protected Hdf5ImageLoader(File hdf5File, IHDF5Reader existingHdf5Reader, ArrayList<Partition> hdf5Partitions, AbstractSequenceDescription<?, ?, ?> sequenceDescription, boolean doOpen) {
        this.existingHdf5Reader = existingHdf5Reader;
        this.hdf5File = hdf5File;
        this.setupImgLoaders = new HashMap();
        this.cachedDimsAndExistence = new HashMap();
        this.sequenceDescription = sequenceDescription;
        this.partitions = new ArrayList();
        if (hdf5Partitions != null) {
            this.partitions.addAll(hdf5Partitions);
        }
        if (doOpen) {
            this.open();
        }
    }

    @Override
    public synchronized void setNumFetcherThreads(int n) {
        this.requestedNumFetcherThreads = n;
    }

    @Override
    public void setCreatedSharedQueue(SharedQueue createdSharedQueue) {
        this.requestedSharedQueue = createdSharedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        if (!this.isOpen) {
            Hdf5ImageLoader hdf5ImageLoader = this;
            synchronized (hdf5ImageLoader) {
                if (this.isOpen) {
                    return;
                }
                this.isOpen = true;
                IHDF5Reader hdf5Reader = this.existingHdf5Reader != null ? this.existingHdf5Reader : HDF5Factory.openForReading((File)this.hdf5File);
                this.maxNumLevels = 0;
                List setups = this.sequenceDescription.getViewSetupsOrdered();
                for (BasicViewSetup setup : setups) {
                    int setupId = setup.getId();
                    double[][] resolutions = hdf5Reader.readDoubleMatrix(Util.getResolutionsPath(setupId));
                    AffineTransform3D[] transforms = new AffineTransform3D[resolutions.length];
                    for (int level = 0; level < resolutions.length; ++level) {
                        transforms[level] = MipmapTransforms.getMipmapTransformDefault(resolutions[level]);
                    }
                    int[][] subdivisions = hdf5Reader.readIntMatrix(Util.getSubdivisionsPath(setupId));
                    if (resolutions.length > this.maxNumLevels) {
                        this.maxNumLevels = resolutions.length;
                    }
                    this.setupImgLoaders.put(setupId, new SetupImgLoader(setupId, new MipmapInfo(resolutions, transforms, subdivisions)));
                }
                this.cachedDimsAndExistence.clear();
                try {
                    this.hdf5Access = new HDF5AccessHack(hdf5Reader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.hdf5Access = hdf5Reader.file().isClosed() ? new HDF5Access(HDF5Factory.openForReading((File)this.hdf5File)) : new HDF5Access(hdf5Reader);
                }
                this.shortLoader = new Hdf5VolatileShortArrayLoader(this.hdf5Access);
                int numFetcherThreads = this.requestedNumFetcherThreads >= 0 ? this.requestedNumFetcherThreads : 1;
                SharedQueue queue = this.requestedSharedQueue != null ? this.requestedSharedQueue : (this.createdSharedQueue = new SharedQueue(numFetcherThreads, this.maxNumLevels));
                this.cache = new VolatileGlobalCellCache(queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isOpen) {
            Hdf5ImageLoader hdf5ImageLoader = this;
            synchronized (hdf5ImageLoader) {
                if (!this.isOpen) {
                    return;
                }
                if (this.createdSharedQueue != null) {
                    this.createdSharedQueue.shutdown();
                }
                this.cache.clearCache();
                this.hdf5Access.closeAllDataSets();
                if (this.existingHdf5Reader == null) {
                    this.hdf5Access.close();
                }
                this.createdSharedQueue = null;
                this.isOpen = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCachedDimensionsFromHdf5(boolean background) {
        this.open();
        long t0 = System.currentTimeMillis();
        List timepoints = this.sequenceDescription.getTimePoints().getTimePointsOrdered();
        List setups = this.sequenceDescription.getViewSetupsOrdered();
        for (TimePoint timepoint : timepoints) {
            int t = timepoint.getId();
            for (BasicViewSetup setup : setups) {
                int s = setup.getId();
                int numLevels = this.getSetupImgLoader(s).numMipmapLevels();
                for (int l = 0; l < numLevels; ++l) {
                    this.getDimsAndExistence(new ViewLevelId(t, s, l));
                }
            }
            if (!background) continue;
            Hdf5ImageLoader hdf5ImageLoader = this;
            synchronized (hdf5ImageLoader) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        long t1 = System.currentTimeMillis() - t0;
        System.out.println("initCachedDimensionsFromHdf5 : " + t1 + " ms");
    }

    public File getHdf5File() {
        return this.hdf5File;
    }

    public ArrayList<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public VolatileGlobalCellCache getCacheControl() {
        this.open();
        return this.cache;
    }

    public Hdf5VolatileShortArrayLoader getShortArrayLoader() {
        this.open();
        return this.shortLoader;
    }

    public boolean existsImageData(ViewLevelId id) {
        return this.getDimsAndExistence(id).exists();
    }

    public DimsAndExistence getDimsAndExistence(ViewLevelId id) {
        this.open();
        DimsAndExistence dims = this.cachedDimsAndExistence.get(id);
        if (dims == null) {
            dims = this.hdf5Access.getDimsAndExistence(id);
            this.cachedDimsAndExistence.put(id, dims);
        }
        return dims;
    }

    public void printMipmapInfo() {
        this.open();
        for (BasicViewSetup setup : this.sequenceDescription.getViewSetupsOrdered()) {
            Object[] res;
            int level;
            int setupId = setup.getId();
            System.out.println("setup " + setupId);
            MipmapInfo mipmapInfo = this.getSetupImgLoader(setupId).getMipmapInfo();
            double[][] reslevels = mipmapInfo.getResolutions();
            int[][] subdiv = mipmapInfo.getSubdivisions();
            int numLevels = mipmapInfo.getNumLevels();
            System.out.println("    resolutions:");
            for (level = 0; level < numLevels; ++level) {
                res = reslevels[level];
                System.out.println("    " + level + ": " + net.imglib2.util.Util.printCoordinates((double[])res));
            }
            System.out.println("    subdivisions:");
            for (level = 0; level < numLevels; ++level) {
                res = subdiv[level];
                System.out.println("    " + level + ": " + net.imglib2.util.Util.printCoordinates((int[])res));
            }
            System.out.println("    level sizes:");
            int timepointId = ((TimePoint)this.sequenceDescription.getTimePoints().getTimePointsOrdered().get(0)).getId();
            for (int level2 = 0; level2 < numLevels; ++level2) {
                DimsAndExistence dims = this.getDimsAndExistence(new ViewLevelId(timepointId, setupId, level2));
                long[] dimensions = dims.getDimensions();
                System.out.println("    " + level2 + ": " + net.imglib2.util.Util.printCoordinates((long[])dimensions));
            }
        }
    }

    @Override
    public SetupImgLoader getSetupImgLoader(int setupId) {
        this.open();
        return this.setupImgLoaders.get(setupId);
    }

    public class SetupImgLoader
    extends AbstractViewerSetupImgLoader<UnsignedShortType, VolatileUnsignedShortType>
    implements MultiResolutionSetupImgLoader<UnsignedShortType> {
        private final int setupId;
        private final MipmapInfo mipmapInfo;

        protected SetupImgLoader(int setupId, MipmapInfo mipmapInfo) {
            super(new UnsignedShortType(), new VolatileUnsignedShortType());
            this.setupId = setupId;
            this.mipmapInfo = mipmapInfo;
        }

        private RandomAccessibleInterval<UnsignedShortType> loadImageCompletely(int timepointId, int level) {
            Hdf5ImageLoader.this.open();
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            if (!Hdf5ImageLoader.this.existsImageData(id)) {
                System.err.println(String.format("image data for timepoint %d setup %d level %d could not be found. Partition file missing?", id.getTimePointId(), id.getViewSetupId(), id.getLevel()));
                return this.getMissingDataImage(id, this.type);
            }
            ArrayImg img = null;
            DimsAndExistence dimsAndExistence = Hdf5ImageLoader.this.getDimsAndExistence(new ViewLevelId(timepointId, this.setupId, level));
            long[] dimsLong = dimsAndExistence.exists() ? dimsAndExistence.getDimensions() : null;
            int n = dimsLong.length;
            int[] dimsInt = new int[n];
            long[] min = new long[n];
            if (Intervals.numElements((Dimensions)new FinalDimensions(dimsLong)) <= Integer.MAX_VALUE) {
                for (int d = 0; d < dimsInt.length; ++d) {
                    dimsInt[d] = (int)dimsLong[d];
                }
                short[] data = null;
                try {
                    data = Hdf5ImageLoader.this.hdf5Access.readShortMDArrayBlockWithOffset(timepointId, this.setupId, level, dimsInt, min);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                img = ArrayImgs.unsignedShorts(data, (long[])dimsLong);
            } else {
                int[] cellDimensions = this.computeCellDimensions(dimsLong, this.mipmapInfo.getSubdivisions()[level]);
                CellImgFactory factory = new CellImgFactory((NativeType)this.type, cellDimensions);
                CellImg cellImg = factory.create(dimsLong);
                ListCursor cursor = ((ListImg)cellImg.getCells()).cursor();
                while (cursor.hasNext()) {
                    Cell cell = (Cell)cursor.next();
                    short[] dataBlock = ((ShortArray)cell.getData()).getCurrentStorageArray();
                    cell.dimensions(dimsInt);
                    cell.min(min);
                    try {
                        Hdf5ImageLoader.this.hdf5Access.readShortMDArrayBlockWithOffset(timepointId, this.setupId, level, dimsInt, min, dataBlock);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                img = cellImg;
            }
            return img;
        }

        private int[] computeCellDimensions(long[] dimsLong, int[] chunkSize) {
            int n = dimsLong.length;
            long[] dimsInChunks = new long[n];
            int elementsPerChunk = 1;
            for (int d = 0; d < n; ++d) {
                dimsInChunks[d] = (dimsLong[d] + (long)chunkSize[d] - 1L) / (long)chunkSize[d];
                elementsPerChunk *= chunkSize[d];
            }
            int[] cellDimensions = new int[n];
            long s = Integer.MAX_VALUE / elementsPerChunk;
            for (int d = 0; d < n; ++d) {
                long ns = s / dimsInChunks[d];
                if (ns <= 0L) {
                    cellDimensions[d] = chunkSize[d] * (int)(s % dimsInChunks[d]);
                    ++d;
                    while (d < n) {
                        cellDimensions[d] = chunkSize[d];
                        ++d;
                    }
                    break;
                }
                cellDimensions[d] = chunkSize[d] * (int)dimsInChunks[d];
                s = ns;
            }
            return cellDimensions;
        }

        public RandomAccessibleInterval<UnsignedShortType> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            if (Arrays.asList(hints).contains(ImgLoaderHints.LOAD_COMPLETELY)) {
                return this.loadImageCompletely(timepointId, level);
            }
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
        }

        @Override
        public RandomAccessibleInterval<VolatileUnsignedShortType> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BUDGETED, (NativeType)this.volatileType);
        }

        protected <T extends NativeType<T>> RandomAccessibleInterval<T> prepareCachedImage(int timepointId, int level, LoadingStrategy loadingStrategy, T type) {
            Hdf5ImageLoader.this.open();
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            if (!Hdf5ImageLoader.this.existsImageData(id)) {
                System.err.println(String.format("image data for timepoint %d setup %d level %d could not be found. Partition file missing?", id.getTimePointId(), id.getViewSetupId(), id.getLevel()));
                return this.getMissingDataImage(id, type);
            }
            long[] dimensions = Hdf5ImageLoader.this.getDimsAndExistence(id).getDimensions();
            int[] cellDimensions = this.mipmapInfo.getSubdivisions()[level];
            CellGrid grid = new CellGrid(dimensions, cellDimensions);
            int priority = this.mipmapInfo.getMaxLevel() - level;
            CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
            return Hdf5ImageLoader.this.cache.createImg(grid, timepointId, this.setupId, level, cacheHints, Hdf5ImageLoader.this.shortLoader, type);
        }

        protected <T> RandomAccessibleInterval<T> getMissingDataImage(ViewLevelId id, T constant) {
            long[] d = Hdf5ImageLoader.this.getDimsAndExistence(id).getDimensions();
            return Views.interval(new ConstantRandomAccessible<T>(constant, 3), (Interval)new FinalInterval(d));
        }

        public MipmapInfo getMipmapInfo() {
            return this.mipmapInfo;
        }

        public double[][] getMipmapResolutions() {
            return this.mipmapInfo.getResolutions();
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return this.mipmapInfo.getTransforms();
        }

        public int numMipmapLevels() {
            return this.mipmapInfo.getNumLevels();
        }

        public Dimensions getImageSize(int timepointId, int level) {
            ViewLevelId id = new ViewLevelId(timepointId, this.setupId, level);
            DimsAndExistence dims = Hdf5ImageLoader.this.getDimsAndExistence(id);
            if (dims.exists()) {
                return new FinalDimensions(dims.getDimensions());
            }
            return null;
        }

        public VoxelDimensions getVoxelSize(int timepointId) {
            return null;
        }
    }
}

