/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.img.hdf5.ViewLevelId;
import mpicbg.spim.data.sequence.ViewId;

public class Util {
    private static final String groupFormatString = "t%05d/s%02d/%d";
    private static final String cellsFormatString = "%s/cells";
    private static final String resolutionsFormatString = "s%02d/resolutions";
    private static final String subdivisionsFormatString = "s%02d/subdivisions";

    public static String getGroupPath(int timepointId, int setupId, int level) {
        return String.format(groupFormatString, timepointId, setupId, level);
    }

    public static String getGroupPath(ViewId viewId, int level) {
        return String.format(groupFormatString, viewId.getTimePointId(), viewId.getViewSetupId(), level);
    }

    public static String getGroupPath(ViewLevelId viewLevelId) {
        return String.format(groupFormatString, viewLevelId.getTimePointId(), viewLevelId.getViewSetupId(), viewLevelId.getLevel());
    }

    public static String getCellsPath(int timepoint, int setup, int level) {
        return String.format(cellsFormatString, Util.getGroupPath(timepoint, setup, level));
    }

    public static String getCellsPath(ViewId viewId, int level) {
        return String.format(cellsFormatString, Util.getGroupPath(viewId, level));
    }

    public static String getCellsPath(ViewLevelId viewLevelId) {
        return String.format(cellsFormatString, Util.getGroupPath(viewLevelId));
    }

    public static String getResolutionsPath(int setupId) {
        return String.format(resolutionsFormatString, setupId);
    }

    public static String getSubdivisionsPath(int setupId) {
        return String.format(subdivisionsFormatString, setupId);
    }

    public static long[] reorder(long[] in, long[] out) {
        assert (in.length == out.length);
        int i = 0;
        int o = in.length - 1;
        while (i < in.length) {
            out[o] = in[i];
            ++i;
            --o;
        }
        return out;
    }

    public static long[] reorder(long[] in) {
        return Util.reorder(in, new long[in.length]);
    }

    public static int[] reorder(int[] in, int[] out) {
        assert (in.length == out.length);
        int i = 0;
        int o = in.length - 1;
        while (i < in.length) {
            out[o] = in[i];
            ++i;
            --o;
        }
        return out;
    }

    public static int[] reorder(int[] in) {
        return Util.reorder(in, new int[in.length]);
    }

    public static long[] reorder(int[] in, long[] out) {
        assert (in.length == out.length);
        int i = 0;
        int o = in.length - 1;
        while (i < in.length) {
            out[o] = in[i];
            ++i;
            --o;
        }
        return out;
    }

    public static int[] castToInts(double[] doubles) {
        int[] ints = new int[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ints[i] = (int)doubles[i];
        }
        return ints;
    }

    public static int[][] castToInts(double[][] doubles) {
        int[][] ints = new int[doubles.length][];
        for (int l = 0; l < doubles.length; ++l) {
            ints[l] = Util.castToInts(doubles[l]);
        }
        return ints;
    }

    public static double[] castToDoubles(int[] ints) {
        double[] doubles = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            doubles[i] = ints[i];
        }
        return doubles;
    }

    public static double[][] castToDoubles(int[][] ints) {
        double[][] doubles = new double[ints.length][];
        for (int l = 0; l < ints.length; ++l) {
            doubles[l] = Util.castToDoubles(ints[l]);
        }
        return doubles;
    }
}

