/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.bookmarks;

import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.XmlHelpers;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Content;
import org.jdom2.Element;

public class Bookmarks {
    private final HashMap<String, AffineTransform3D> bookmarks = new HashMap();

    public Element toXml() {
        Element elem = new Element("Bookmarks");
        for (Map.Entry<String, AffineTransform3D> entry : this.bookmarks.entrySet()) {
            String key = entry.getKey();
            AffineTransform3D transform = entry.getValue();
            Element elemBookmark = new Element("Bookmark");
            elemBookmark.addContent((Content)XmlHelpers.textElement((String)"key", (String)key));
            elemBookmark.addContent((Content)XmlHelpers.affineTransform3DElement((String)"transform", (AffineGet)transform));
            elem.addContent((Content)elemBookmark);
        }
        return elem;
    }

    public void restoreFromXml(Element parent) {
        this.bookmarks.clear();
        Element elemBookmarks = parent.getChild("Bookmarks");
        if (elemBookmarks == null) {
            return;
        }
        for (Element elem : elemBookmarks.getChildren("Bookmark")) {
            String key = XmlHelpers.getText((Element)elem, (String)"key");
            AffineTransform3D transform = XmlHelpers.getAffineTransform3D((Element)elem, (String)"transform");
            this.bookmarks.put(key, transform);
        }
    }

    public void put(String key, AffineTransform3D transform) {
        this.bookmarks.put(key, transform);
    }

    public AffineTransform3D get(String key) {
        return this.bookmarks.get(key);
    }
}

