/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.brightness.SliderPanel;
import bdv.util.BoundedInterval;
import bdv.util.BoundedValue;
import bdv.viewer.AbstractViewerPanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractTransformedBoxSelectionDialog<R>
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected final OkCancelPanel buttons;
    protected R result;
    private final Object monitor = new Object();

    public AbstractTransformedBoxSelectionDialog(Window owner, String title) {
        super(owner, title);
        this.buttons = new OkCancelPanel();
        this.buttons.onOk(this::ok);
        this.buttons.onCancel(this::cancel);
        this.getContentPane().add((Component)this.buttons, "South");
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractTransformedBoxSelectionDialog.this.cancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        this.setVisible(false);
        Object object = this.monitor;
        synchronized (object) {
            this.createResult(false);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ok() {
        this.setVisible(false);
        Object object = this.monitor;
        synchronized (object) {
            this.createResult(true);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getResult() {
        Object object = this.monitor;
        synchronized (object) {
            this.result = null;
            SwingUtilities.invokeLater(() -> this.setVisible(true));
            while (true) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        return this.result;
    }

    protected abstract void createResult(boolean var1);

    public static class OkCancelPanel
    extends JPanel {
        private final ArrayList<Runnable> runOnOk = new ArrayList();
        private final ArrayList<Runnable> runOnCancel = new ArrayList();

        public OkCancelPanel() {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(e -> this.runOnCancel.forEach(Runnable::run));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(e -> this.runOnOk.forEach(Runnable::run));
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createHorizontalGlue());
            this.add(cancelButton);
            this.add(okButton);
        }

        public synchronized void onOk(Runnable runnable) {
            this.runOnOk.add(runnable);
        }

        public synchronized void onCancel(Runnable runnable) {
            this.runOnCancel.add(runnable);
        }
    }

    public static class TimepointSelectionPanel
    extends JPanel {
        final BoundedInterval timeRange;
        final BoundedValue timeValue;
        final BoxSelectionOptions.TimepointSelection mode;

        public TimepointSelectionPanel(AbstractViewerPanel viewer, BoxSelectionOptions options) {
            this.setLayout(new BoxLayout(this, 3));
            this.mode = options.values.getTimepointSelection();
            if (this.mode == BoxSelectionOptions.TimepointSelection.SINGLE || this.mode == BoxSelectionOptions.TimepointSelection.RANGE) {
                int tmaxViewer = viewer.state().getNumTimepoints() - 1;
                int tmin = Math.max(0, Math.min(tmaxViewer, options.values.getRangeMinTimepoint()));
                int tmax = Math.max(tmin, Math.min(tmaxViewer, options.values.getRangeMaxTimepoint()));
                if (this.mode == BoxSelectionOptions.TimepointSelection.SINGLE) {
                    int t0 = Math.max(tmin, Math.min(tmax, options.values.getInitialMinTimepoint()));
                    this.timeValue = new BoundedValue(tmin, tmax, t0);
                    this.timeRange = null;
                    SliderPanel timePanel = new SliderPanel("t", this.timeValue, 1);
                    timePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                    this.add(timePanel);
                } else {
                    int t0 = Math.max(tmin, Math.min(tmax, options.values.getInitialMinTimepoint()));
                    int t1 = Math.max(t0, Math.min(tmax, options.values.getInitialMaxTimepoint()));
                    this.timeRange = new BoundedInterval(tmin, tmax, t0, t1, 0);
                    this.timeValue = null;
                    SliderPanel minPanel = new SliderPanel("t min", this.timeRange.getMinBoundedValue(), 1);
                    minPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                    this.add(minPanel);
                    SliderPanel maxPanel = new SliderPanel("t max", this.timeRange.getMaxBoundedValue(), 1);
                    maxPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                    this.add(maxPanel);
                }
            } else {
                this.timeValue = null;
                this.timeRange = null;
            }
        }
    }
}

