/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.brightness.SliderPanel;
import bdv.util.BoundedInterval;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;

public class BoxSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final BoundedInterval[] ranges;
    private final SliderPanel[] minSliderPanels;
    private final SliderPanel[] maxSliderPanels;
    private final Box selection;
    private int cols;
    private final int n;

    public BoxSelectionPanel(Box selection, Interval rangeInterval) {
        int d;
        this.n = selection.getInterval().numDimensions();
        this.selection = selection;
        this.ranges = new BoundedInterval[this.n];
        this.minSliderPanels = new SliderPanel[this.n];
        this.maxSliderPanels = new SliderPanel[this.n];
        this.cols = 2;
        for (d = 0; d < this.n; ++d) {
            this.cols = Math.max(this.cols, Long.toString(rangeInterval.min(d)).length());
            this.cols = Math.max(this.cols, Long.toString(rangeInterval.max(d)).length());
        }
        this.setLayout(new BoxLayout(this, 3));
        for (d = 0; d < this.n; ++d) {
            int rangeMin = (int)rangeInterval.min(d);
            int rangeMax = (int)rangeInterval.max(d);
            Interval interval = selection.getInterval();
            int initialMin = Math.max((int)interval.min(d), rangeMin);
            int initialMax = Math.min((int)interval.max(d), rangeMax);
            BoundedInterval range = new BoundedInterval(rangeMin, rangeMax, initialMin, initialMax, 0){

                @Override
                protected void updateInterval(int min, int max) {
                    BoxSelectionPanel.this.updateSelection();
                }
            };
            JPanel sliders = new JPanel();
            sliders.setLayout(new BoxLayout(sliders, 3));
            String axis = d == 0 ? "x" : (d == 1 ? "y" : "z");
            SliderPanel minPanel = new SliderPanel(axis + " min", range.getMinBoundedValue(), 1);
            minPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            minPanel.setNumColummns(this.cols);
            sliders.add(minPanel);
            SliderPanel maxPanel = new SliderPanel(axis + " max", range.getMaxBoundedValue(), 1);
            maxPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            maxPanel.setNumColummns(this.cols);
            sliders.add(maxPanel);
            this.add(sliders);
            this.minSliderPanels[d] = minPanel;
            this.maxSliderPanels[d] = maxPanel;
            this.ranges[d] = range;
        }
    }

    public void setBoundsInterval(Interval interval) {
        int d;
        int oldCols = this.cols;
        for (d = 0; d < this.n; ++d) {
            this.cols = Math.max(this.cols, Long.toString(interval.min(d)).length());
            this.cols = Math.max(this.cols, Long.toString(interval.max(d)).length());
        }
        for (d = 0; d < this.n; ++d) {
            this.ranges[d].setRange((int)interval.min(d), (int)interval.max(d));
        }
        if (oldCols != this.cols) {
            for (d = 0; d < this.n; ++d) {
                this.minSliderPanels[d].setNumColummns(this.cols);
                this.maxSliderPanels[d].setNumColummns(this.cols);
            }
            this.invalidate();
        }
    }

    public void updateSelection() {
        long[] min = new long[this.n];
        long[] max = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.ranges[d].getMinBoundedValue().getCurrentValue();
            max[d] = this.ranges[d].getMaxBoundedValue().getCurrentValue();
        }
        this.selection.setInterval((Interval)new FinalInterval(min, max));
    }

    public void updateSliders(Interval interval) {
        if (interval.numDimensions() != this.n) {
            throw new IllegalArgumentException();
        }
        long[] min = new long[this.n];
        long[] max = new long[this.n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < this.n; ++d) {
            this.ranges[d].getMinBoundedValue().setCurrentValue((int)min[d]);
            this.ranges[d].getMaxBoundedValue().setCurrentValue((int)max[d]);
        }
    }

    public static interface Box {
        public Interval getInterval();

        public void setInterval(Interval var1);
    }
}

