/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.TransformedBox;
import bdv.tools.boundingbox.TransformedBoxOverlay;
import bdv.tools.boundingbox.TransformedBoxPlaceHolderSource;
import bdv.util.Bounds;
import bdv.util.PlaceHolderConverterSetup;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import java.awt.Color;
import net.imglib2.type.numeric.ARGBType;

public class TransformedBoxOverlaySource {
    private final TransformedBoxOverlay boxOverlay;
    private final PlaceHolderConverterSetup boxConverterSetup;
    private final SourceAndConverter<Void> boxSourceAndConverter;
    private final AbstractViewerPanel viewer;
    private final ConverterSetups setups;
    private boolean isVisible;
    private final ViewerStateChangeListener viewerStateChangeListener = this::viewerStateChanged;

    public TransformedBoxOverlaySource(String name, TransformedBoxOverlay boxOverlay, TransformedBox bbSource, AbstractViewerPanel viewer, ConverterSetups converterSetups, int setupId) {
        this.boxOverlay = boxOverlay;
        this.viewer = viewer;
        this.setups = converterSetups;
        this.boxConverterSetup = new PlaceHolderConverterSetup(setupId, 0.0, 128.0, new ARGBType(0x994499));
        this.boxConverterSetup.setupChangeListeners().add(s -> this.repaint());
        this.boxSourceAndConverter = new SourceAndConverter<Void>(new TransformedBoxPlaceHolderSource(name, bbSource), (input, output) -> output.set(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToViewer() {
        ViewerState state;
        ViewerState viewerState = state = this.viewer.state();
        synchronized (viewerState) {
            if (state.getDisplayMode() != DisplayMode.FUSED) {
                for (SourceAndConverter<?> source : state.getSources()) {
                    state.setSourceActive(source, state.isSourceVisible(source));
                }
                state.setDisplayMode(DisplayMode.FUSED);
            }
            state.addSource(this.boxSourceAndConverter);
            state.changeListeners().add((Object)this.viewerStateChangeListener);
            state.setSourceActive(this.boxSourceAndConverter, true);
            state.setCurrentSource(this.boxSourceAndConverter);
            this.isVisible = state.isSourceVisible(this.boxSourceAndConverter);
        }
        this.setups.put(this.boxSourceAndConverter, this.boxConverterSetup);
        this.setups.getBounds().setBounds(this.boxConverterSetup, new Bounds(0.0, 255.0));
        this.repaint();
    }

    public void removeFromViewer() {
        this.viewer.state().changeListeners().remove((Object)this.viewerStateChangeListener);
        this.viewer.state().removeSource(this.boxSourceAndConverter);
    }

    private void viewerStateChanged(ViewerStateChange change) {
        if (change == ViewerStateChange.VISIBILITY_CHANGED) {
            boolean wasVisible = this.isVisible;
            this.isVisible = this.viewer.state().isSourceVisible(this.boxSourceAndConverter);
            if (wasVisible != this.isVisible) {
                this.repaint();
            }
        }
    }

    private void repaint() {
        System.out.println("TransformedBoxOverlaySource.repaint");
        this.boxOverlay.fillIntersection(this.isVisible);
        if (this.isVisible) {
            int alpha = Math.min(255, (int)this.boxConverterSetup.getDisplayRangeMax());
            int argb = this.boxConverterSetup.getColor().get() & 0xFFFFFF | alpha << 24;
            this.boxOverlay.setIntersectionFillColor(new Color(argb, true));
        }
        this.viewer.getDisplayComponent().repaint();
    }
}

