/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.brightness;

import bdv.tools.brightness.ColorIcon;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.brightness.SliderPanelDouble;
import bdv.util.DelayedPackDialog;
import bdv.util.InvokeOnEDT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.type.numeric.ARGBType;

@Deprecated
public class BrightnessDialog
extends DelayedPackDialog {
    private static final long serialVersionUID = 7963632306732311403L;

    public BrightnessDialog(Frame owner, SetupAssignments setupAssignments) {
        super(owner, "brightness and color", false);
        Container content = this.getContentPane();
        final MinMaxPanels minMaxPanels = new MinMaxPanels(setupAssignments, this, true);
        final ColorsPanel colorsPanel = new ColorsPanel(setupAssignments);
        content.add((Component)minMaxPanels, "North");
        content.add((Component)colorsPanel, "South");
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        Object hideKey = new Object();
        AbstractAction hideAction = new AbstractAction(){
            private static final long serialVersionUID = 3904286091931838921L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BrightnessDialog.this.setVisible(false);
            }
        };
        im.put(KeyStroke.getKeyStroke(27, 0), hideKey);
        am.put(hideKey, hideAction);
        final AtomicBoolean recreateContentPending = new AtomicBoolean();
        setupAssignments.setUpdateListener(new SetupAssignments.UpdateListener(){

            @Override
            public void update() {
                try {
                    if (BrightnessDialog.this.isVisible()) {
                        InvokeOnEDT.invokeAndWait(() -> {
                            System.out.println("colorsPanel.recreateContent()");
                            colorsPanel.recreateContent();
                            minMaxPanels.recreateContent();
                            recreateContentPending.set(false);
                        });
                    } else {
                        recreateContentPending.set(true);
                    }
                }
                catch (InterruptedException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (recreateContentPending.getAndSet(false)) {
                    colorsPanel.recreateContent();
                    minMaxPanels.recreateContent();
                }
            }
        });
        this.pack();
    }

    public static class MinMaxPanel
    extends JPanel
    implements MinMaxGroup.UpdateListener {
        private final SetupAssignments setupAssignments;
        private final MinMaxGroup minMaxGroup;
        private final ArrayList<JCheckBox> boxes;
        private final JPanel sliders;
        private final Runnable showAdvanced;
        private final Runnable hideAdvanced;
        private boolean isShowingAdvanced;
        private final boolean rememberSizes;
        private static final long serialVersionUID = -5209143847804383789L;

        public MinMaxPanel(MinMaxGroup group, final SetupAssignments assignments, final MinMaxPanels minMaxPanels, boolean rememberSizes) {
            this.setupAssignments = assignments;
            this.minMaxGroup = group;
            this.rememberSizes = rememberSizes;
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
            this.setLayout(new BorderLayout(10, 10));
            this.sliders = new JPanel();
            this.sliders.setLayout(new BoxLayout(this.sliders, 3));
            double spinnerStepSize = 1.0;
            SliderPanelDouble minPanel = new SliderPanelDouble("min", group.getMinBoundedValue(), 1.0);
            minPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.sliders.add(minPanel);
            SliderPanelDouble maxPanel = new SliderPanelDouble("max", group.getMaxBoundedValue(), 1.0);
            maxPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.sliders.add(maxPanel);
            if (rememberSizes && !minMaxPanels.minMaxPanels.isEmpty()) {
                Dimension dim = ((MinMaxPanel)((MinMaxPanels)minMaxPanels).minMaxPanels.get((int)0)).sliders.getSize();
                if (dim.width > 0) {
                    this.sliders.setPreferredSize(dim);
                }
            }
            this.add((Component)this.sliders, "Center");
            this.boxes = new ArrayList();
            JPanel boxesPanel = new JPanel();
            boxesPanel.setLayout(new BoxLayout(boxesPanel, 2));
            for (final ConverterSetup setup : assignments.getConverterSetups()) {
                final JCheckBox box = new JCheckBox();
                box.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        if (box.isSelected()) {
                            assignments.moveSetupToGroup(setup, minMaxGroup);
                        } else if (!assignments.removeSetupFromGroup(setup, minMaxGroup)) {
                            box.setSelected(true);
                        }
                    }
                });
                boxesPanel.add(box);
                this.boxes.add(box);
            }
            this.minMaxGroup.setUpdateListener(this);
            final JPanel advancedPanel = new JPanel();
            advancedPanel.setLayout(new BoxLayout(advancedPanel, 3));
            JSpinner dummy = new JSpinner();
            dummy.setModel(new SpinnerNumberModel(this.minMaxGroup.getRangeMax(), this.minMaxGroup.getFullRangeMin(), this.minMaxGroup.getFullRangeMax(), 1.0));
            dummy.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            Dimension ps = dummy.getPreferredSize();
            final JSpinner spinnerRangeMin = new JSpinner();
            spinnerRangeMin.setModel(new SpinnerNumberModel(this.minMaxGroup.getRangeMin(), -2.147483648E9, 2.147483647E9, 1.0));
            spinnerRangeMin.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    double value = ((Number)spinnerRangeMin.getValue()).doubleValue();
                    if (value < minMaxGroup.getFullRangeMin()) {
                        spinnerRangeMin.setValue(minMaxGroup.getFullRangeMin());
                    } else if (value > minMaxGroup.getRangeMax() - 1.0) {
                        spinnerRangeMin.setValue(minMaxGroup.getRangeMax() - 1.0);
                    } else {
                        minMaxGroup.setRange(value, minMaxGroup.getRangeMax());
                    }
                }
            });
            spinnerRangeMin.setPreferredSize(ps);
            spinnerRangeMin.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            final JSpinner spinnerRangeMax = new JSpinner();
            spinnerRangeMax.setModel(new SpinnerNumberModel(this.minMaxGroup.getRangeMax(), -2.147483648E9, 2.147483647E9, 1.0));
            spinnerRangeMax.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    double value = ((Number)spinnerRangeMax.getValue()).doubleValue();
                    if (value < minMaxGroup.getRangeMin() + 1.0) {
                        spinnerRangeMax.setValue(minMaxGroup.getRangeMin() + 1.0);
                    } else if (value > minMaxGroup.getFullRangeMax()) {
                        spinnerRangeMax.setValue(minMaxGroup.getFullRangeMax());
                    } else {
                        minMaxGroup.setRange(minMaxGroup.getRangeMin(), value);
                    }
                }
            });
            spinnerRangeMax.setPreferredSize(ps);
            spinnerRangeMax.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            final JButton advancedButton = new JButton(">>");
            advancedButton.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.isShowingAdvanced = false;
            advancedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    minMaxPanels.showAdvanced(!isShowingAdvanced);
                }
            });
            boxesPanel.add(advancedButton);
            this.showAdvanced = new Runnable(){

                @Override
                public void run() {
                    advancedPanel.add(spinnerRangeMin);
                    advancedPanel.add(spinnerRangeMax);
                    advancedButton.setText("<<");
                    isShowingAdvanced = true;
                }
            };
            this.hideAdvanced = new Runnable(){

                @Override
                public void run() {
                    advancedPanel.remove(spinnerRangeMin);
                    advancedPanel.remove(spinnerRangeMax);
                    advancedButton.setText(">>");
                    isShowingAdvanced = false;
                }
            };
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.storeSliderSize();
                }
            });
            minPanel.setRangeListener(() -> spinnerRangeMin.setValue(this.minMaxGroup.getRangeMin()));
            maxPanel.setRangeListener(() -> spinnerRangeMax.setValue(this.minMaxGroup.getRangeMax()));
            JPanel eastPanel = new JPanel();
            eastPanel.setLayout(new BoxLayout(eastPanel, 2));
            eastPanel.add((Component)boxesPanel, "Center");
            eastPanel.add((Component)advancedPanel, "East");
            this.add((Component)eastPanel, "East");
        }

        public void showAdvanced(boolean b) {
            if (b) {
                this.showAdvanced.run();
            } else {
                this.hideAdvanced.run();
            }
        }

        public void storeSliderSize() {
            if (this.rememberSizes) {
                Dimension dim = this.sliders.getSize();
                if (dim.width > 0) {
                    this.sliders.setPreferredSize(dim);
                }
            }
        }

        @Override
        public void update() {
            for (int i = 0; i < this.boxes.size(); ++i) {
                int setupId = this.setupAssignments.getConverterSetups().get(i).getSetupId();
                boolean b = false;
                for (ConverterSetup s : this.minMaxGroup.setups) {
                    if (s.getSetupId() != setupId) continue;
                    b = true;
                    break;
                }
                this.boxes.get(i).setSelected(b);
            }
        }
    }

    public static class MinMaxPanels
    extends JPanel {
        private final SetupAssignments setupAssignments;
        private final ArrayList<MinMaxPanel> minMaxPanels;
        private final JDialog dialog;
        private final boolean rememberSizes;
        private boolean isShowingAdvanced = false;
        private static final long serialVersionUID = 6538962298579455010L;

        public MinMaxPanels(SetupAssignments assignments, JDialog dialog, boolean rememberSizes) {
            this.setupAssignments = assignments;
            this.rememberSizes = rememberSizes;
            this.minMaxPanels = new ArrayList();
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.recreateContent();
            this.dialog = dialog;
        }

        public void recreateContent() {
            Dimension sliderSize = this.rememberSizes && !this.minMaxPanels.isEmpty() ? this.minMaxPanels.get(0).sliders.getPreferredSize() : null;
            this.removeAll();
            this.minMaxPanels.clear();
            for (MinMaxGroup group : this.setupAssignments.getMinMaxGroups()) {
                MinMaxPanel panel = new MinMaxPanel(group, this.setupAssignments, this, this.rememberSizes);
                if (sliderSize != null) {
                    panel.sliders.setPreferredSize(sliderSize);
                }
                this.minMaxPanels.add(panel);
                this.add(panel);
            }
            for (MinMaxPanel panel : this.minMaxPanels) {
                panel.update();
                panel.showAdvanced(this.isShowingAdvanced);
            }
            this.invalidate();
            Window frame = SwingUtilities.getWindowAncestor(this);
            if (frame != null) {
                frame.pack();
            }
        }

        public void showAdvanced(boolean b) {
            this.isShowingAdvanced = b;
            for (MinMaxPanel panel : this.minMaxPanels) {
                panel.storeSliderSize();
                panel.showAdvanced(this.isShowingAdvanced);
            }
            if (this.dialog != null) {
                this.dialog.pack();
            }
        }
    }

    public static class ColorsPanel
    extends JPanel {
        private final SetupAssignments setupAssignments;
        private final ArrayList<JButton> buttons;
        private final JColorChooser colorChooser;
        private static final long serialVersionUID = 6408468837346789676L;

        public ColorsPanel(SetupAssignments assignments) {
            this.setupAssignments = assignments;
            this.buttons = new ArrayList();
            this.colorChooser = new JColorChooser();
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.recreateContent();
        }

        public void recreateContent() {
            this.removeAll();
            this.buttons.clear();
            this.add(new JLabel("set view colors:"));
            for (final ConverterSetup setup : this.setupAssignments.getConverterSetups()) {
                final JButton button = new JButton(new ColorIcon(ColorsPanel.getColor(setup)));
                button.addActionListener(e -> {
                    this.colorChooser.setColor(ColorsPanel.getColor(setup));
                    JDialog d = JColorChooser.createDialog(button, "Choose a color", true, this.colorChooser, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            Color c = colorChooser.getColor();
                            if (c != null) {
                                button.setIcon(new ColorIcon(c));
                                ColorsPanel.setColor(setup, c);
                            }
                        }
                    }, null);
                    d.setVisible(true);
                });
                button.setEnabled(setup.supportsColor());
                this.buttons.add(button);
                this.add(button);
            }
            this.invalidate();
            Window frame = SwingUtilities.getWindowAncestor(this);
            if (frame != null) {
                frame.pack();
            }
        }

        private static Color getColor(ConverterSetup setup) {
            if (setup.supportsColor()) {
                int value = setup.getColor().get();
                return new Color(value);
            }
            return null;
        }

        private static void setColor(ConverterSetup setup, Color color) {
            setup.setColor(new ARGBType(color.getRGB() | 0xFF000000));
        }
    }
}

