/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.keymap;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class KeymapsListData {
    public String defaultKeymapName;
    public LinkedHashMap<String, String> keymapNameToFileName;

    public KeymapsListData(String defaultName, List<String> keymapNames) {
        this.defaultKeymapName = defaultName;
        this.keymapNameToFileName = new LinkedHashMap();
        HashSet<String> existingNames = new HashSet<String>();
        existingNames.add("keymaps");
        for (String keymapName : keymapNames) {
            String name = keymapName.replaceAll("\\W+", "");
            if (existingNames.contains(name)) {
                String prefix;
                int n;
                Pattern pattern = Pattern.compile("(.+)_(\\d+)$");
                Matcher matcher = pattern.matcher(name);
                if (matcher.matches()) {
                    String nstr = matcher.group(2);
                    n = Integer.parseInt(nstr);
                    prefix = matcher.group(1);
                } else {
                    n = 1;
                    prefix = name;
                }
                while (existingNames.contains(name = prefix + "_" + ++n)) {
                }
            }
            this.keymapNameToFileName.put(keymapName, name + ".yaml");
        }
    }

    public Map<String, String> getFileNameToKeymapName() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.keymapNameToFileName.entrySet()) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    public KeymapsListData() {
    }
}

