/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.viewer.Source;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class MipmapTransforms {
    public static AffineTransform3D getMipmapTransformDefault(double[] resolution) {
        assert (resolution.length == 3);
        AffineTransform3D mipmapTransform = new AffineTransform3D();
        for (int d = 0; d < 3; ++d) {
            mipmapTransform.set(resolution[d], d, d);
            mipmapTransform.set(0.5 * (resolution[d] - 1.0), d, 3);
        }
        return mipmapTransform;
    }

    public static double getVoxelScreenSize(AffineTransform3D screenTransform, Source<?> source, int timepoint, int mipmapIndex) {
        double pixelSize = 0.0;
        AffineTransform3D sourceToScreen = new AffineTransform3D();
        sourceToScreen.set(screenTransform);
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(timepoint, mipmapIndex, sourceTransform);
        sourceToScreen.concatenate(sourceTransform);
        double[] zero = new double[]{0.0, 0.0, 0.0};
        double[] tzero = new double[3];
        double[] one = new double[3];
        double[] tone = new double[3];
        double[] diff = new double[2];
        sourceToScreen.apply(zero, tzero);
        for (int i = 0; i < 3; ++i) {
            for (int d = 0; d < 3; ++d) {
                one[d] = d == i ? 1.0 : 0.0;
            }
            sourceToScreen.apply(one, tone);
            LinAlgHelpers.subtract((double[])tone, (double[])tzero, (double[])tone);
            diff[0] = tone[0];
            diff[1] = tone[1];
            double l = LinAlgHelpers.length((double[])diff);
            if (!(l > pixelSize)) continue;
            pixelSize = l;
        }
        return pixelSize;
    }

    public static double[] getPixelSourceSize(AffineTransform3D screenTransform, Source<?> source, int timepoint, int mipmapIndex) {
        double[] sourcePixelSize = new double[2];
        AffineTransform3D sourceToScreen = new AffineTransform3D();
        sourceToScreen.set(screenTransform);
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(timepoint, mipmapIndex, sourceTransform);
        sourceToScreen.concatenate(sourceTransform);
        double[] zero = new double[]{0.0, 0.0, 0.0};
        double[] tzero = new double[3];
        double[] one = new double[3];
        double[] tone = new double[3];
        double[] diff = new double[3];
        sourceToScreen.applyInverse(tzero, zero);
        for (int i = 0; i < 2; ++i) {
            for (int d = 0; d < 3; ++d) {
                one[d] = d == i ? 1.0 : 0.0;
            }
            sourceToScreen.applyInverse(tone, one);
            LinAlgHelpers.subtract((double[])tone, (double[])tzero, (double[])diff);
            sourcePixelSize[i] = LinAlgHelpers.length((double[])diff);
        }
        return sourcePixelSize;
    }

    public static int getBestMipMapLevel(AffineTransform3D screenTransform, Source<?> source, int timepoint) {
        int numLevels = source.getNumMipmapLevels();
        double[] bestPixelSourceSize = new double[]{1.0, 1.0};
        int targetLevel = numLevels;
        double minDist = Double.POSITIVE_INFINITY;
        for (int level = 0; level < numLevels; ++level) {
            double[] pixelSourceSize = MipmapTransforms.getPixelSourceSize(screenTransform, source, timepoint, level);
            double dist = LinAlgHelpers.squareDistance((double[])pixelSourceSize, (double[])bestPixelSourceSize);
            if (!(minDist > dist)) continue;
            minDist = dist;
            targetLevel = level;
        }
        return targetLevel;
    }
}

