/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import bdv.ui.UIUtils;
import bdv.util.Affine3DHelpers;
import bdv.util.IntervalBoundingBox;
import bdv.viewer.overlay.RenderBoxHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class MultiBoxOverlay {
    private final Color activeBackColor = new Color(0x994499);
    private final Color activeFrontColor = Color.GREEN;
    private final Color inactiveBackColor = Color.DARK_GRAY;
    private final Color inactiveFrontColor = Color.LIGHT_GRAY;
    private final Color canvasColor = new Color(-1329873989, true);
    private final RenderBoxHelper renderBoxHelper = new RenderBoxHelper();
    private volatile boolean highlightInProgress;
    private int highlightIndex = -1;
    private long highlighStartTime = -1L;
    private final int highlightDuration = 300;

    public <I extends IntervalAndTransform> void paint(Graphics2D graphics, List<I> sources, Interval targetInterval, Interval boxScreen) {
        assert (targetInterval.numDimensions() >= 2);
        if (sources.isEmpty()) {
            return;
        }
        double perspective = 3.0;
        double screenBoxRatio = 0.75;
        ArrayList<RealPoint> transformedCorners = new ArrayList<RealPoint>();
        double[] viewerToFirstSourceRotation = this.getViewerToFirstSourceRotation(((IntervalAndTransform)sources.get(0)).getSourceToViewer());
        double[] p = new double[3];
        double[] q = new double[3];
        for (IntervalAndTransform source : sources) {
            for (RealLocalizable corner : IntervalBoundingBox.getCorners((RealInterval)source.getSourceInterval())) {
                corner.localize(p);
                source.getSourceToViewer().apply(p, q);
                LinAlgHelpers.quaternionApply((double[])viewerToFirstSourceRotation, (double[])q, (double[])p);
                transformedCorners.add(new RealPoint(p));
            }
        }
        RealInterval boundingBox = IntervalBoundingBox.getBoundingBox(transformedCorners);
        double sourceSize = 0.0;
        for (int d = 0; d < 3; ++d) {
            sourceSize = Math.max(sourceSize, boundingBox.realMax(d) - boundingBox.realMin(d));
        }
        long targetSize = Math.max(targetInterval.dimension(0), targetInterval.dimension(1));
        this.renderBoxHelper.setDepth(3.0 * sourceSize);
        double bw = 0.75 * (double)boxScreen.dimension(0);
        double bh = 0.75 * (double)boxScreen.dimension(1);
        double scale = Math.min(bw / (double)targetInterval.dimension(0), bh / (double)targetInterval.dimension(1));
        double tsScale = sourceSize / (double)targetSize;
        if (tsScale > 1.0) {
            scale /= tsScale;
        }
        this.renderBoxHelper.setScale(scale);
        long x = boxScreen.min(0) + boxScreen.dimension(0) / 2L;
        long y = boxScreen.min(1) + boxScreen.dimension(1) / 2L;
        AffineTransform t = graphics.getTransform();
        AffineTransform translate = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        translate.preConcatenate(t);
        graphics.setTransform(translate);
        this.paint(graphics, sources, targetInterval);
        graphics.setTransform(t);
    }

    private double[] getViewerToFirstSourceRotation(AffineTransform3D sourceToViewer) {
        double[] q = new double[4];
        double[] qinv = new double[4];
        Affine3DHelpers.extractRotationAnisotropic(sourceToViewer, q);
        LinAlgHelpers.quaternionInvert((double[])q, (double[])qinv);
        return qinv;
    }

    public boolean isHighlightInProgress() {
        return this.highlightInProgress;
    }

    public void highlight(int sourceIndex) {
        this.highlightIndex = sourceIndex;
        this.highlighStartTime = -1L;
    }

    private <I extends IntervalAndTransform> void paint(Graphics2D graphics, List<I> sources, Interval targetInterval) {
        double ox = targetInterval.min(0) + targetInterval.dimension(0) / 2L;
        double oy = targetInterval.min(1) + targetInterval.dimension(1) / 2L;
        this.renderBoxHelper.setOrigin(ox, oy);
        GeneralPath canvas = new GeneralPath();
        this.renderBoxHelper.renderCanvas(targetInterval, canvas);
        GeneralPath activeFront = new GeneralPath();
        GeneralPath activeBack = new GeneralPath();
        GeneralPath inactiveFront = new GeneralPath();
        GeneralPath inactiveBack = new GeneralPath();
        GeneralPath highlightFront = new GeneralPath();
        GeneralPath highlightBack = new GeneralPath();
        boolean highlight = false;
        Color highlightFrontColor = null;
        Color highlightBackColor = null;
        for (int i = 0; i < sources.size(); ++i) {
            IntervalAndTransform source = (IntervalAndTransform)sources.get(i);
            if (this.highlightIndex == i) {
                double t;
                highlight = true;
                if (this.highlighStartTime == -1L) {
                    this.highlighStartTime = System.currentTimeMillis();
                }
                if ((t = (double)(System.currentTimeMillis() - this.highlighStartTime) / 300.0) >= 1.0) {
                    this.highlightInProgress = false;
                    this.highlightIndex = -1;
                    this.highlighStartTime = -1L;
                    t = 1.0;
                } else {
                    this.highlightInProgress = true;
                }
                double fadeInTime = 0.2;
                double fadeOutTime = 0.5;
                float alpha = t <= 0.2 ? (float)Math.sin(1.5707963267948966 * t / 0.2) : (t >= 0.5 ? (float)Math.sin(1.5707963267948966 * (1.0 - t) / 0.5) : 1.0f);
                Color c = source.isVisible() ? this.activeFrontColor : this.inactiveFrontColor;
                int r = (int)(alpha * 255.0f + (1.0f - alpha) * (float)c.getRed());
                int g = (int)(alpha * 255.0f + (1.0f - alpha) * (float)c.getGreen());
                int b = (int)(alpha * 255.0f + (1.0f - alpha) * (float)c.getBlue());
                highlightFrontColor = new Color(r, g, b);
                c = source.isVisible() ? this.activeBackColor : this.inactiveBackColor;
                r = (int)(alpha * 255.0f + (1.0f - alpha) * (float)c.getRed());
                g = (int)(alpha * 255.0f + (1.0f - alpha) * (float)c.getGreen());
                b = (int)(alpha * 255.0f + (1.0f - alpha) * (float)c.getBlue());
                highlightBackColor = new Color(r, g, b);
                this.renderBoxHelper.renderBox(source.getSourceInterval(), source.getSourceToViewer(), highlightFront, highlightBack);
                continue;
            }
            if (source.isVisible()) {
                this.renderBoxHelper.renderBox(source.getSourceInterval(), source.getSourceToViewer(), activeFront, activeBack);
                continue;
            }
            this.renderBoxHelper.renderBox(source.getSourceInterval(), source.getSourceToViewer(), inactiveFront, inactiveBack);
        }
        if (this.highlightIndex >= sources.size()) {
            this.highlightInProgress = false;
            this.highlightIndex = -1;
            this.highlighStartTime = -1L;
        }
        double uiScale = UIUtils.getUIScaleFactor(this);
        BasicStroke stroke = new BasicStroke((float)uiScale);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setStroke(stroke);
        graphics.setPaint(this.inactiveBackColor);
        graphics.draw(inactiveBack);
        graphics.setPaint(this.activeBackColor);
        graphics.draw(activeBack);
        if (highlight) {
            graphics.setPaint(highlightBackColor);
            graphics.draw(highlightBack);
        }
        graphics.setPaint(this.canvasColor);
        graphics.fill(canvas);
        graphics.setPaint(this.inactiveFrontColor);
        graphics.draw(inactiveFront);
        graphics.setPaint(this.activeFrontColor);
        graphics.draw(activeFront);
        if (highlight) {
            graphics.setPaint(highlightFrontColor);
            graphics.draw(highlightFront);
        }
        IntervalAndTransform source = (IntervalAndTransform)sources.get(0);
        double sX0 = source.getSourceInterval().min(0);
        double sY0 = source.getSourceInterval().min(1);
        double sZ0 = source.getSourceInterval().min(2);
        double[] px = new double[]{sX0 + (double)(source.getSourceInterval().dimension(0) / 2L), sY0, sZ0};
        double[] py = new double[]{sX0, sY0 + (double)(source.getSourceInterval().dimension(1) / 2L), sZ0};
        double[] pz = new double[]{sX0, sY0, sZ0 + (double)(source.getSourceInterval().dimension(2) / 2L)};
        double[] qx = new double[3];
        double[] qy = new double[3];
        double[] qz = new double[3];
        source.getSourceToViewer().apply(px, qx);
        source.getSourceToViewer().apply(py, qy);
        source.getSourceToViewer().apply(pz, qz);
        graphics.setPaint(Color.WHITE);
        graphics.setFont(UIUtils.getFont("mini.font"));
        graphics.drawString("x", (float)this.renderBoxHelper.perspectiveX(qx), (float)(this.renderBoxHelper.perspectiveY(qx) - uiScale * 2.0));
        graphics.drawString("y", (float)this.renderBoxHelper.perspectiveX(qy), (float)(this.renderBoxHelper.perspectiveY(qy) - uiScale * 2.0));
        graphics.drawString("z", (float)this.renderBoxHelper.perspectiveX(qz), (float)(this.renderBoxHelper.perspectiveY(qz) - uiScale * 2.0));
    }

    public static interface IntervalAndTransform {
        public boolean isVisible();

        public Interval getSourceInterval();

        public AffineTransform3D getSourceToViewer();
    }
}

