/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.cache.CacheControl;
import bdv.util.MovingAverage;
import bdv.viewer.RequestRepaint;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bdv.viewer.render.AccumulateProjectorFactory;
import bdv.viewer.render.DebugTilingOverlay;
import bdv.viewer.render.ProjectorFactory;
import bdv.viewer.render.RenderResult;
import bdv.viewer.render.RenderStorage;
import bdv.viewer.render.RenderTarget;
import bdv.viewer.render.ScreenScales;
import bdv.viewer.render.Tile;
import bdv.viewer.render.TiledProjector;
import bdv.viewer.render.Tiling;
import bdv.viewer.render.VisibleSourcesOnScreenBounds;
import bdv.viewer.render.VolatileProjector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.iotiming.CacheIoTiming;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class MultiResolutionRenderer {
    private final RenderTarget<?> display;
    private final RequestRepaint painterThread;
    private final ProjectorFactory projectorFactory;
    private final CacheControl cacheControl;
    private final long[] iobudget = new long[]{100000000L, 10000000L};
    private final ScreenScales screenScales;
    private final MovingAverage renderNanosPerPixelAndSource;
    private final ForkJoinPool renderingForkJoinPool;
    private final boolean createdForkJoinPool;
    private VolatileProjector projector;
    private boolean renderingMayBeCancelled;
    private ViewerState currentViewerState;
    private double currentAverageNumSourcesPerPixel;
    private RenderResult currentRenderResult;
    private boolean intervalMode;
    private int currentScreenScaleIndex;
    private int requestedScreenScaleIndex;
    private boolean newFrameRequest;
    private int currentIntervalScaleIndex;
    private int requestedIntervalScaleIndex;
    private boolean newIntervalRequest;
    private final RenderResult intervalResult;
    private ScreenScales.IntervalRenderData intervalRenderData;
    DebugTilingOverlay debugTileOverlay;

    public MultiResolutionRenderer(RenderTarget<?> display, RequestRepaint painterThread, double[] screenScaleFactors, long targetRenderNanos, int numRenderingThreads, ExecutorService renderingExecutorService, boolean useVolatileIfAvailable, AccumulateProjectorFactory<ARGBType> accumulateProjectorFactory, CacheControl cacheControl) {
        this.display = display;
        this.painterThread = painterThread;
        this.projector = null;
        this.currentScreenScaleIndex = -1;
        this.screenScales = new ScreenScales(screenScaleFactors, targetRenderNanos);
        this.renderNanosPerPixelAndSource = new MovingAverage(3);
        this.renderNanosPerPixelAndSource.init(500.0);
        this.requestedScreenScaleIndex = this.screenScales.size() - 1;
        this.renderingMayBeCancelled = false;
        this.cacheControl = cacheControl;
        this.newFrameRequest = false;
        this.intervalResult = display.createRenderResult();
        if (renderingExecutorService instanceof ForkJoinPool) {
            this.renderingForkJoinPool = (ForkJoinPool)renderingExecutorService;
            this.createdForkJoinPool = false;
        } else {
            this.renderingForkJoinPool = new ForkJoinPool(numRenderingThreads);
            this.createdForkJoinPool = true;
        }
        this.projectorFactory = new ProjectorFactory(numRenderingThreads, this.renderingForkJoinPool, useVolatileIfAvailable, accumulateProjectorFactory);
    }

    public synchronized void requestRepaint() {
        if (this.renderingMayBeCancelled && this.projector != null) {
            this.projector.cancel();
        }
        this.newFrameRequest = true;
        this.painterThread.requestRepaint();
    }

    public synchronized void requestRepaint(Interval interval) {
        if (Intervals.isEmpty((Interval)this.screenScales.clipToScreen(interval))) {
            return;
        }
        if (this.renderingMayBeCancelled && this.projector != null) {
            this.projector.cancel();
        }
        this.screenScales.requestInterval(interval);
        this.newIntervalRequest = true;
        this.painterThread.requestRepaint();
    }

    public void kill() {
        this.projector = null;
        this.currentViewerState = null;
        this.currentRenderResult = null;
        if (this.createdForkJoinPool) {
            this.renderingForkJoinPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paint(ViewerState viewerState) {
        boolean createProjector;
        boolean prepareNextFrame;
        boolean newFrame;
        int screenW = this.display.getWidth();
        int screenH = this.display.getHeight();
        if (screenW <= 0 || screenH <= 0) {
            return false;
        }
        MultiResolutionRenderer multiResolutionRenderer = this;
        synchronized (multiResolutionRenderer) {
            boolean newInterval;
            boolean resized = this.screenScales.checkResize(screenW, screenH);
            boolean bl = newFrame = this.newFrameRequest || resized;
            if (newFrame) {
                this.intervalMode = false;
                this.screenScales.clearRequestedIntervals();
            }
            boolean bl2 = newInterval = this.newIntervalRequest && !newFrame;
            if (newInterval) {
                this.intervalMode = true;
                double renderNanosPerPixel = this.renderNanosPerPixelAndSource.getAverage() * this.currentAverageNumSourcesPerPixel;
                this.requestedIntervalScaleIndex = this.screenScales.suggestIntervalScreenScale(renderNanosPerPixel, this.currentScreenScaleIndex);
            }
            prepareNextFrame = newFrame || newInterval;
            boolean bl3 = this.renderingMayBeCancelled = !prepareNextFrame;
            if (this.intervalMode) {
                boolean bl4 = createProjector = newInterval || this.requestedIntervalScaleIndex != this.currentIntervalScaleIndex;
                if (createProjector) {
                    this.intervalRenderData = this.screenScales.pullIntervalRenderData(this.requestedIntervalScaleIndex, this.currentScreenScaleIndex);
                }
            } else {
                createProjector = newFrame || this.requestedScreenScaleIndex != this.currentScreenScaleIndex;
            }
            this.newFrameRequest = false;
            this.newIntervalRequest = false;
        }
        if (prepareNextFrame) {
            this.cacheControl.prepareNextFrame();
        }
        if (newFrame) {
            this.currentViewerState = viewerState.snapshot();
            VisibleSourcesOnScreenBounds screenBounds = new VisibleSourcesOnScreenBounds(this.currentViewerState, this.screenScales.get(0));
            this.currentAverageNumSourcesPerPixel = screenBounds.estimateNumSourcesPerPixel();
            double renderNanosPerPixel = this.renderNanosPerPixelAndSource.getAverage() * this.currentAverageNumSourcesPerPixel;
            this.requestedScreenScaleIndex = this.screenScales.suggestScreenScale(renderNanosPerPixel);
        }
        if (!this.intervalMode && this.requestedScreenScaleIndex < 0) {
            return true;
        }
        return this.intervalMode ? this.paintInterval(createProjector) : this.paintFullFrame(createProjector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean paintFullFrame(boolean createProjector) {
        VolatileProjector p;
        RenderResult renderResult = null;
        boolean requestNewFrameIfIncomplete = false;
        MultiResolutionRenderer multiResolutionRenderer = this;
        synchronized (multiResolutionRenderer) {
            if (createProjector) {
                ScreenScales.ScreenScale screenScale = this.screenScales.get(this.requestedScreenScaleIndex);
                renderResult = (RenderResult)this.display.getReusableRenderResult();
                renderResult.init(screenScale.width(), screenScale.height());
                renderResult.setScaleFactor(screenScale.scale());
                this.currentViewerState.getViewerTransform(renderResult.getViewerTransform());
                this.projector = this.createProjector(this.currentViewerState, this.requestedScreenScaleIndex, renderResult.getTargetImage(), 0, 0);
                requestNewFrameIfIncomplete = this.projectorFactory.requestNewFrameIfIncomplete();
            }
            p = this.projector;
        }
        boolean success = this.renderingForkJoinPool.invoke(ForkJoinTask.adapt(() -> p.map(createProjector)));
        long rendertime = p.getLastFrameRenderNanoTime();
        MultiResolutionRenderer multiResolutionRenderer2 = this;
        synchronized (multiResolutionRenderer2) {
            if (success) {
                this.currentScreenScaleIndex = this.requestedScreenScaleIndex;
                if (createProjector) {
                    renderResult.setUpdated();
                    this.display.setRenderResult(renderResult);
                    this.currentRenderResult = renderResult;
                    this.recordRenderTime(renderResult, rendertime);
                    if (this.debugTileOverlay != null) {
                        this.debugTileOverlay.setRenderTime(rendertime);
                        this.debugTileOverlay.setRenderTimePerPixelAndSource(this.renderNanosPerPixelAndSource.getAverage());
                    }
                } else {
                    this.currentRenderResult.setUpdated();
                }
                if (!p.isValid() && requestNewFrameIfIncomplete) {
                    this.requestRepaint();
                } else if (p.isValid() && this.currentScreenScaleIndex == 0) {
                    this.requestedScreenScaleIndex = -1;
                } else {
                    this.iterateRepaint(Math.max(0, this.currentScreenScaleIndex - 1));
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean paintInterval(boolean createProjector) {
        VolatileProjector p;
        MultiResolutionRenderer multiResolutionRenderer = this;
        synchronized (multiResolutionRenderer) {
            if (createProjector) {
                this.intervalResult.init(this.intervalRenderData.width(), this.intervalRenderData.height());
                this.intervalResult.setScaleFactor(this.intervalRenderData.scale());
                this.projector = this.createProjector(this.currentViewerState, this.requestedIntervalScaleIndex, this.intervalResult.getTargetImage(), this.intervalRenderData.offsetX(), this.intervalRenderData.offsetY());
            }
            p = this.projector;
        }
        boolean success = this.renderingForkJoinPool.invoke(ForkJoinTask.adapt(() -> p.map(createProjector)));
        long rendertime = p.getLastFrameRenderNanoTime();
        MultiResolutionRenderer multiResolutionRenderer2 = this;
        synchronized (multiResolutionRenderer2) {
            if (success) {
                this.currentIntervalScaleIndex = this.requestedIntervalScaleIndex;
                this.currentRenderResult.patch(this.intervalResult, this.intervalRenderData.targetInterval(), this.intervalRenderData.tx(), this.intervalRenderData.ty());
                if (createProjector) {
                    this.recordRenderTime(this.intervalResult, rendertime);
                }
                if (this.currentIntervalScaleIndex > this.currentScreenScaleIndex) {
                    this.iterateRepaintInterval(this.currentIntervalScaleIndex - 1);
                } else if (p.isValid()) {
                    if (this.requestedScreenScaleIndex >= 0) {
                        this.intervalMode = false;
                        if (this.requestedScreenScaleIndex == this.currentScreenScaleIndex) {
                            ++this.currentScreenScaleIndex;
                        }
                        this.painterThread.requestRepaint();
                    }
                } else {
                    this.iterateRepaintInterval(this.currentIntervalScaleIndex);
                }
            } else {
                this.intervalRenderData.reRequest();
            }
        }
        return success;
    }

    private void recordRenderTime(RenderResult result, long renderNanos) {
        int numRenderPixels = (int)((double)Intervals.numElements(result.getTargetImage()) * this.currentAverageNumSourcesPerPixel);
        if (numRenderPixels >= 4096) {
            this.renderNanosPerPixelAndSource.add((double)renderNanos / (double)numRenderPixels);
        }
    }

    private void iterateRepaint(int screenScaleIndex) {
        if (screenScaleIndex == this.currentScreenScaleIndex) {
            this.usleep();
        }
        this.requestedScreenScaleIndex = screenScaleIndex;
        this.painterThread.requestRepaint();
    }

    private void iterateRepaintInterval(int intervalScaleIndex) {
        if (intervalScaleIndex == this.currentIntervalScaleIndex) {
            this.intervalRenderData.reRequest();
            this.usleep();
        }
        this.requestedIntervalScaleIndex = intervalScaleIndex;
        this.painterThread.requestRepaint();
    }

    private void usleep() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private VolatileProjector createProjector(ViewerState viewerState, int screenScaleIndex, RandomAccessibleInterval<ARGBType> screenImage, int offsetX, int offsetY) {
        ScreenScales.ScreenScale screenScale = this.screenScales.get(screenScaleIndex);
        AffineTransform3D screenTransform = viewerState.getViewerTransform().preConcatenate(screenScale.scaleTransform());
        screenTransform.translate(new double[]{-offsetX, -offsetY, 0.0});
        VisibleSourcesOnScreenBounds onScreenBounds = new VisibleSourcesOnScreenBounds(viewerState, (Interval)screenImage, screenTransform);
        List<Tile> tiles = Tiling.findTiles(onScreenBounds);
        List<Tile> renderTiles = Tiling.splitForRendering(tiles);
        this.currentAverageNumSourcesPerPixel = onScreenBounds.estimateNumSourcesPerPixel();
        int numTiles = renderTiles.size();
        ArrayList<VolatileProjector> tileProjectors = new ArrayList<VolatileProjector>(numTiles);
        for (int t = 0; t < numTiles; ++t) {
            Tile tile = renderTiles.get(t);
            int w = tile.tileSizeX();
            int h = tile.tileSizeY();
            int ox = tile.tileMinX();
            int oy = tile.tileMinY();
            List<SourceAndConverter<?>> sources = tile.sources();
            RenderStorage tileRenderStorage = new RenderStorage(w, h, sources.size());
            IntervalView tileImage = Views.interval(screenImage, (Interval)Intervals.createMinSize((long[])new long[]{ox, oy, w, h}));
            tileProjectors.add(this.projectorFactory.createProjector(viewerState, sources, (RandomAccessibleInterval<ARGBType>)tileImage, screenTransform, tileRenderStorage));
        }
        if (this.debugTileOverlay != null) {
            this.debugTileOverlay.setTiling(tiles, screenScale.scale(), offsetX, offsetY);
        }
        CacheIoTiming.getIoTimeBudget().reset(this.iobudget);
        return new TiledProjector(tileProjectors);
    }
}

