/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.RequestRepaint;
import java.util.concurrent.RejectedExecutionException;

public class PainterThread
extends Thread
implements RequestRepaint {
    private final Paintable paintable;
    private boolean pleaseRepaint;

    public PainterThread(Paintable paintable) {
        this(null, "PainterThread", paintable);
    }

    public PainterThread(ThreadGroup group, Paintable paintable) {
        this(group, "PainterThread", paintable);
    }

    public PainterThread(ThreadGroup group, String name, Paintable paintable) {
        super(group, name);
        this.paintable = paintable;
        this.pleaseRepaint = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            boolean b;
            PainterThread painterThread = this;
            synchronized (painterThread) {
                b = this.pleaseRepaint;
                this.pleaseRepaint = false;
            }
            if (b) {
                try {
                    this.paintable.paint();
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            painterThread = this;
            synchronized (painterThread) {
                block12: {
                    try {
                        if (this.pleaseRepaint) break block12;
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRepaint() {
        PainterThread painterThread = this;
        synchronized (painterThread) {
            this.pleaseRepaint = true;
            this.notify();
        }
    }

    public static interface Paintable {
        public void paint();
    }
}

