/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.img.cache.VolatileCachedCellImg;
import bdv.util.MipmapTransforms;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import bdv.viewer.render.AccumulateProjectorFactory;
import bdv.viewer.render.DefaultMipmapOrdering;
import bdv.viewer.render.EmptyProjector;
import bdv.viewer.render.MipmapOrdering;
import bdv.viewer.render.Prefetcher;
import bdv.viewer.render.RenderStorage;
import bdv.viewer.render.SimpleVolatileProjector;
import bdv.viewer.render.VolatileHierarchyProjector;
import bdv.viewer.render.VolatileProjector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.list.AbstractLongListImg;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.view.Views;

class ProjectorFactory {
    private final int numRenderingThreads;
    private final ExecutorService renderingExecutorService;
    private final boolean useVolatileIfAvailable;
    private final AccumulateProjectorFactory<ARGBType> accumulateProjectorFactory;
    private boolean newFrameRequest;
    private int previousTimepoint = -1;
    private final boolean prefetchCells = true;

    public ProjectorFactory(int numRenderingThreads, ExecutorService renderingExecutorService, boolean useVolatileIfAvailable, AccumulateProjectorFactory<ARGBType> accumulateProjectorFactory) {
        this.numRenderingThreads = numRenderingThreads;
        this.renderingExecutorService = renderingExecutorService;
        this.useVolatileIfAvailable = useVolatileIfAvailable;
        this.accumulateProjectorFactory = accumulateProjectorFactory;
    }

    public VolatileProjector createProjector(ViewerState viewerState, List<SourceAndConverter<?>> visibleSourcesOnScreen, RandomAccessibleInterval<ARGBType> screenImage, AffineTransform3D screenTransform, RenderStorage renderStorage) {
        VolatileProjector projector;
        this.newFrameRequest = false;
        int width = (int)screenImage.dimension(0);
        int height = (int)screenImage.dimension(1);
        if (visibleSourcesOnScreen.isEmpty()) {
            projector = new EmptyProjector<ARGBType>(screenImage);
        } else if (visibleSourcesOnScreen.size() == 1) {
            byte[] maskArray = renderStorage.getMaskArray(0);
            projector = this.createSingleSourceProjector(viewerState, visibleSourcesOnScreen.get(0), screenImage, screenTransform, maskArray);
        } else {
            int offsetX = (int)screenImage.min(0);
            int offsetY = (int)screenImage.min(1);
            ArrayList<VolatileProjector> sourceProjectors = new ArrayList<VolatileProjector>();
            ArrayList<RandomAccessibleInterval<ARGBType>> sourceImages = new ArrayList<RandomAccessibleInterval<ARGBType>>();
            int j = 0;
            for (SourceAndConverter<?> source : visibleSourcesOnScreen) {
                RandomAccessibleInterval<ARGBType> renderImage = renderStorage.getRenderImage(width, height, j);
                byte[] maskArray = renderStorage.getMaskArray(j);
                ++j;
                AffineTransform3D renderTransform = screenTransform.copy();
                renderTransform.translate(new double[]{-offsetX, -offsetY, 0.0});
                VolatileProjector p = this.createSingleSourceProjector(viewerState, source, renderImage, renderTransform, maskArray);
                sourceProjectors.add(p);
                sourceImages.add(renderImage);
            }
            projector = this.accumulateProjectorFactory.createProjector(sourceProjectors, visibleSourcesOnScreen, sourceImages, (RandomAccessibleInterval<ARGBType>)Views.zeroMin(screenImage), this.numRenderingThreads, this.renderingExecutorService);
        }
        this.previousTimepoint = viewerState.getCurrentTimepoint();
        return projector;
    }

    private <T> VolatileProjector createSingleSourceProjector(ViewerState viewerState, SourceAndConverter<T> source, RandomAccessibleInterval<ARGBType> screenImage, AffineTransform3D screenTransform, byte[] maskArray) {
        if (this.useVolatileIfAvailable) {
            if (source.asVolatile() != null) {
                return this.createSingleSourceVolatileProjector(viewerState, source.asVolatile(), screenImage, screenTransform, maskArray);
            }
            if (source.getSpimSource().getType() instanceof Volatile) {
                SourceAndConverter<T> vsource = source;
                return this.createSingleSourceVolatileProjector(viewerState, vsource, screenImage, screenTransform, maskArray);
            }
        }
        int bestLevel = ProjectorFactory.getBestMipMapLevel(viewerState, source, screenTransform);
        return new SimpleVolatileProjector<T, ARGBType>(ProjectorFactory.getTransformedSource(viewerState, source.getSpimSource(), screenTransform, bestLevel, null), source.getConverter(), screenImage);
    }

    private <T extends Volatile<?>> VolatileProjector createSingleSourceVolatileProjector(ViewerState viewerState, SourceAndConverter<T> source, RandomAccessibleInterval<ARGBType> screenImage, AffineTransform3D screenTransform, byte[] maskArray) {
        ArrayList<RandomAccessible<T>> renderList = new ArrayList<RandomAccessible<T>>();
        Source<T> spimSource = source.getSpimSource();
        int t = viewerState.getCurrentTimepoint();
        MipmapOrdering ordering = spimSource instanceof MipmapOrdering ? (MipmapOrdering)((Object)spimSource) : new DefaultMipmapOrdering(spimSource);
        MipmapOrdering.MipmapHints hints = ordering.getMipmapHints(screenTransform, t, this.previousTimepoint);
        List<MipmapOrdering.Level> levels = hints.getLevels();
        levels.sort(MipmapOrdering.prefetchOrderComparator);
        for (MipmapOrdering.Level l : levels) {
            CacheHints cacheHints = l.getPrefetchCacheHints();
            if (cacheHints != null && cacheHints.getLoadingStrategy() == LoadingStrategy.DONTLOAD) continue;
            ProjectorFactory.prefetch(viewerState, spimSource, screenTransform, l.getMipmapLevel(), cacheHints, screenImage);
        }
        levels.sort(MipmapOrdering.renderOrderComparator);
        for (MipmapOrdering.Level l : levels) {
            renderList.add(ProjectorFactory.getTransformedSource(viewerState, spimSource, screenTransform, l.getMipmapLevel(), l.getRenderCacheHints()));
        }
        if (hints.renewHintsAfterPaintingOnce()) {
            this.newFrameRequest = true;
        }
        return new VolatileHierarchyProjector<T, ARGBType>(renderList, source.getConverter(), screenImage, maskArray);
    }

    private static int getBestMipMapLevel(ViewerState viewerState, SourceAndConverter<?> source, AffineTransform3D screenTransform) {
        return MipmapTransforms.getBestMipMapLevel(screenTransform, source.getSpimSource(), viewerState.getCurrentTimepoint());
    }

    private static <T> RandomAccessible<T> getTransformedSource(ViewerState viewerState, Source<T> source, AffineTransform3D screenTransform, int mipmapIndex, CacheHints cacheHints) {
        int timepoint = viewerState.getCurrentTimepoint();
        RandomAccessibleInterval<T> img = source.getSource(timepoint, mipmapIndex);
        if (img instanceof VolatileCachedCellImg) {
            ((VolatileCachedCellImg)img).setCacheHints(cacheHints);
        }
        Interpolation interpolation = viewerState.getInterpolation();
        RealRandomAccessible<T> ipimg = source.getInterpolatedSource(timepoint, mipmapIndex, interpolation);
        AffineTransform3D sourceToScreen = new AffineTransform3D();
        source.getSourceTransform(timepoint, mipmapIndex, sourceToScreen);
        sourceToScreen.preConcatenate(screenTransform);
        return RealViews.affine(ipimg, (AffineGet)sourceToScreen);
    }

    private static <T> void prefetch(ViewerState viewerState, Source<T> source, AffineTransform3D screenTransform, int mipmapIndex, CacheHints prefetchCacheHints, Dimensions screenInterval) {
        int timepoint = viewerState.getCurrentTimepoint();
        RandomAccessibleInterval<T> img = source.getSource(timepoint, mipmapIndex);
        if (img instanceof VolatileCachedCellImg) {
            VolatileCachedCellImg cellImg = (VolatileCachedCellImg)img;
            CacheHints hints = prefetchCacheHints;
            if (hints == null) {
                CacheHints d = cellImg.getDefaultCacheHints();
                hints = new CacheHints(LoadingStrategy.VOLATILE, d.getQueuePriority(), false);
            }
            cellImg.setCacheHints(hints);
            int[] cellDimensions = new int[3];
            cellImg.getCellGrid().cellDimensions(cellDimensions);
            long[] dimensions = new long[3];
            cellImg.dimensions(dimensions);
            AbstractLongListImg.LongListRandomAccess cellsRandomAccess = ((VolatileCachedCellImg.VolatileCachedCells)cellImg.getCells()).randomAccess();
            Interpolation interpolation = viewerState.getInterpolation();
            AffineTransform3D sourceToScreen = new AffineTransform3D();
            source.getSourceTransform(timepoint, mipmapIndex, sourceToScreen);
            sourceToScreen.preConcatenate(screenTransform);
            Prefetcher.fetchCells(sourceToScreen, cellDimensions, dimensions, screenInterval, interpolation, cellsRandomAccess);
        }
    }

    public boolean requestNewFrameIfIncomplete() {
        return this.newFrameRequest;
    }
}

