/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.render.VolatileProjector;
import java.util.List;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.imglib2.util.StopWatch;

class TiledProjector
implements VolatileProjector {
    private List<VolatileProjector> tileProjectors;
    private long lastFrameRenderNanoTime;
    private volatile boolean canceled = false;
    private boolean valid = false;

    public TiledProjector(List<VolatileProjector> tileProjectors) {
        this.tileProjectors = tileProjectors;
        this.lastFrameRenderNanoTime = -1L;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        for (VolatileProjector tileProjector : this.tileProjectors) {
            tileProjector.cancel();
        }
    }

    @Override
    public long getLastFrameRenderNanoTime() {
        return this.lastFrameRenderNanoTime;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean map(boolean clearUntouchedTargetPixels) {
        if (this.canceled) {
            return false;
        }
        if (this.isValid()) {
            return true;
        }
        StopWatch stopWatch = StopWatch.createAndStart();
        ForkJoinTask.invokeAll(this.tileProjectors.stream().map(p -> ForkJoinTask.adapt(() -> p.map(clearUntouchedTargetPixels))).collect(Collectors.toList()));
        if (this.canceled) {
            return false;
        }
        this.tileProjectors = this.tileProjectors.stream().filter(p -> !p.isValid()).collect(Collectors.toList());
        this.lastFrameRenderNanoTime = stopWatch.nanoTime();
        this.valid = this.tileProjectors.isEmpty();
        return !this.canceled;
    }
}

