/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render.awt;

import bdv.util.TripleBuffer;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.TransformListener;
import bdv.viewer.render.RenderTarget;
import bdv.viewer.render.awt.BufferedImageRenderResult;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.listeners.Listeners;

public class BufferedImageOverlayRenderer
implements OverlayRenderer,
RenderTarget<BufferedImageRenderResult> {
    private final TripleBuffer<BufferedImageRenderResult> tripleBuffer = new TripleBuffer<BufferedImageRenderResult>(BufferedImageRenderResult::new);
    private final Listeners.List<TransformListener<AffineTransform3D>> paintedTransformListeners;
    private final AffineTransform3D paintedTransform = new AffineTransform3D();
    private volatile int width = 0;
    private volatile int height = 0;

    public BufferedImageOverlayRenderer() {
        this.paintedTransformListeners = new Listeners.SynchronizedList(l -> l.transformChanged(this.paintedTransform));
    }

    @Override
    public BufferedImageRenderResult getReusableRenderResult() {
        return this.tripleBuffer.getWritableBuffer();
    }

    @Override
    public BufferedImageRenderResult createRenderResult() {
        return new BufferedImageRenderResult();
    }

    @Override
    public synchronized void setRenderResult(BufferedImageRenderResult result) {
        this.tripleBuffer.doneWriting(result);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void drawOverlays(Graphics g) {
        BufferedImage image;
        TripleBuffer.ReadableBuffer<BufferedImageRenderResult> rb = this.tripleBuffer.getReadableBuffer();
        BufferedImageRenderResult result = rb.getBuffer();
        BufferedImage bufferedImage = image = result != null ? result.getBufferedImage() : null;
        if (image != null) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            double scaleFactor = result.getScaleFactor();
            int w = Math.max(this.width, (int)((double)image.getWidth() / scaleFactor + 0.5));
            int h = Math.max(this.height, (int)((double)image.getHeight() / scaleFactor + 0.5));
            g.drawImage(image, 0, 0, w, h, null);
            if (rb.isUpdated()) {
                this.paintedTransform.set(result.getViewerTransform());
                this.paintedTransformListeners.list.forEach(listener -> listener.transformChanged(this.paintedTransform));
            }
        }
    }

    @Override
    public void setCanvasSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Listeners<TransformListener<AffineTransform3D>> transformListeners() {
        return this.paintedTransformListeners;
    }

    public void kill() {
        this.tripleBuffer.clear();
    }
}

