/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;

public final class FileUtils {
    private static final String LOG_TAG = "FileUtils";
    private static final int DEFAULT_BUFFER_SIZE_IN_BYTES = 4096;

    private FileUtils() {
    }

    @NonNull
    public static File getFile(@NonNull Context context, @NonNull String fileName) {
        return new File(context.getFilesDir(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static String readFromFile(@NonNull File file) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter output = new StringWriter();
        try {
            int count;
            char[] buffer = new char[4096];
            while ((count = inputStreamReader.read(buffer)) != -1) {
                output.write(buffer, 0, count);
            }
        }
        catch (IOException ioe) {
            Log.w((String)LOG_TAG, (String)ioe.toString());
        }
        finally {
            try {
                ((Reader)inputStreamReader).close();
            }
            catch (IOException ioe) {
                Log.e((String)LOG_TAG, (String)ioe.toString());
            }
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(@NonNull File file, @NonNull String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(content);
            writer.flush();
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)ioe.toString());
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                Log.e((String)LOG_TAG, (String)ioe.toString());
            }
        }
    }

    public static void deleteFile(@NonNull File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            Log.w((String)LOG_TAG, (String)("Could not delete file: " + file));
        }
    }

    @NonNull
    public static File[] listAllFiles(File directory) {
        if (directory == null) {
            return new File[0];
        }
        File[] files = directory.listFiles();
        return files != null ? files : new File[]{};
    }

    public static void deleteFirst(@NonNull File[] files, @NonNull Comparator<File> sortedBy, int numFiles) {
        Arrays.sort(files, sortedBy);
        int size = Math.min(files.length, numFiles);
        for (int i = 0; i < size; ++i) {
            if (files[i].delete()) continue;
            Log.w((String)LOG_TAG, (String)("Failed to delete file: " + files[i]));
        }
    }

    public static final class LastModifiedComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            long o2LastModified;
            long o1LastModified = o1.lastModified();
            return o1LastModified < (o2LastModified = o2.lastModified()) ? -1 : (o1LastModified == o2LastModified ? 0 : 1);
        }
    }
}

