/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.core.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.UiThread;
import com.mapbox.services.android.core.connectivity.ConnectivityListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private Context context;
    private CopyOnWriteArrayList<ConnectivityListener> connectivityListeners;
    private Boolean connectedFlag;
    private int activationCounter;

    public ConnectivityReceiver(Context context) {
        this.context = context;
        this.connectivityListeners = new CopyOnWriteArrayList();
        this.connectedFlag = null;
    }

    private static boolean getSystemConnectivity(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return false;
            }
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            return activeNetwork.isConnectedOrConnecting();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getManagedConnectivity() {
        if (this.connectedFlag == null) {
            return ConnectivityReceiver.getSystemConnectivity(this.context);
        }
        return this.connectedFlag;
    }

    public static boolean isConnected(Context context) {
        return ConnectivityReceiver.getSystemConnectivity(context);
    }

    public boolean isConnected() {
        return this.getManagedConnectivity();
    }

    public Boolean getConnectedFlag() {
        return this.connectedFlag;
    }

    public void setConnectedFlag(Boolean connectedFlag) {
        this.connectedFlag = connectedFlag;
    }

    public void addConnectivityListener(ConnectivityListener listener) {
        if (!this.connectivityListeners.contains(listener)) {
            this.connectivityListeners.add(listener);
        }
    }

    public boolean removeConnectivityListener(ConnectivityListener listener) {
        return this.connectivityListeners.remove(listener);
    }

    @UiThread
    public void requestConnectivityUpdates() {
        if (this.activationCounter == 0) {
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        ++this.activationCounter;
    }

    @UiThread
    public void removeConnectivityUpdates() {
        --this.activationCounter;
        if (this.activationCounter == 0) {
            this.context.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public void onReceive(Context context, Intent intent) {
        boolean connected = this.getManagedConnectivity();
        for (ConnectivityListener listener : this.connectivityListeners) {
            listener.onConnectivityChanged(connected);
        }
    }
}

