/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location;

import android.location.Location;
import androidx.annotation.NonNull;

public class LocationValidator {
    private Location lastValidLocation;
    private final int accuracyThreshold;

    public LocationValidator(int accuracyThreshold) {
        this.accuracyThreshold = accuracyThreshold;
    }

    public boolean isValidUpdate(@NonNull Location location) {
        return this.checkLastValidLocation(location) || location.getAccuracy() < (float)this.accuracyThreshold;
    }

    private boolean checkLastValidLocation(@NonNull Location location) {
        if (this.lastValidLocation == null) {
            this.lastValidLocation = location;
            return true;
        }
        return false;
    }
}

