/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.engine;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.mapbox.mapboxsdk.location.engine.LocationEngineCallback;
import com.mapbox.mapboxsdk.location.engine.LocationEngineImpl;
import com.mapbox.mapboxsdk.location.engine.LocationEngineRequest;
import com.mapbox.mapboxsdk.location.engine.LocationEngineResult;
import java.util.Collections;
import java.util.List;

class GoogleLocationEngineImpl
implements LocationEngineImpl<LocationCallback> {
    private final FusedLocationProviderClient fusedLocationProviderClient;

    @VisibleForTesting
    GoogleLocationEngineImpl(FusedLocationProviderClient fusedLocationProviderClient) {
        this.fusedLocationProviderClient = fusedLocationProviderClient;
    }

    GoogleLocationEngineImpl(@NonNull Context context) {
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
    }

    @NonNull
    public LocationCallback createListener(LocationEngineCallback<LocationEngineResult> callback) {
        return new GoogleLocationEngineCallbackTransport(callback);
    }

    @SuppressLint(value={"MissingPermission"})
    public void getLastLocation(@NonNull LocationEngineCallback<LocationEngineResult> callback) throws SecurityException {
        GoogleLastLocationEngineCallbackTransport transport = new GoogleLastLocationEngineCallbackTransport(callback);
        this.fusedLocationProviderClient.getLastLocation().addOnSuccessListener((OnSuccessListener)transport).addOnFailureListener((OnFailureListener)transport);
    }

    @SuppressLint(value={"MissingPermission"})
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull LocationCallback listener, @Nullable Looper looper) throws SecurityException {
        this.fusedLocationProviderClient.requestLocationUpdates(GoogleLocationEngineImpl.toGMSLocationRequest(request), listener, looper);
    }

    @SuppressLint(value={"MissingPermission"})
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull PendingIntent pendingIntent) throws SecurityException {
        this.fusedLocationProviderClient.requestLocationUpdates(GoogleLocationEngineImpl.toGMSLocationRequest(request), pendingIntent);
    }

    public void removeLocationUpdates(@NonNull LocationCallback listener) {
        if (listener != null) {
            this.fusedLocationProviderClient.removeLocationUpdates(listener);
        }
    }

    public void removeLocationUpdates(PendingIntent pendingIntent) {
        if (pendingIntent != null) {
            this.fusedLocationProviderClient.removeLocationUpdates(pendingIntent);
        }
    }

    private static LocationRequest toGMSLocationRequest(LocationEngineRequest request) {
        LocationRequest.Builder builder = new LocationRequest.Builder(request.getInterval());
        builder.setMinUpdateIntervalMillis(request.getFastestInterval());
        builder.setMinUpdateDistanceMeters(request.getDisplacement());
        builder.setMaxUpdateDelayMillis(request.getMaxWaitTime());
        builder.setWaitForAccurateLocation(true);
        builder.setPriority(GoogleLocationEngineImpl.toGMSLocationPriority(request.getPriority()));
        return builder.build();
    }

    private static int toGMSLocationPriority(int enginePriority) {
        switch (enginePriority) {
            case 0: {
                return 100;
            }
            case 1: {
                return 102;
            }
            case 2: {
                return 104;
            }
        }
        return 105;
    }

    @VisibleForTesting
    static final class GoogleLastLocationEngineCallbackTransport
    implements OnSuccessListener<Location>,
    OnFailureListener {
        private final LocationEngineCallback<LocationEngineResult> callback;

        GoogleLastLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> callback) {
            this.callback = callback;
        }

        public void onSuccess(Location location) {
            this.callback.onSuccess((Object)(location != null ? LocationEngineResult.create((Location)location) : LocationEngineResult.create(Collections.emptyList())));
        }

        public void onFailure(@NonNull Exception e) {
            this.callback.onFailure(e);
        }
    }

    private static final class GoogleLocationEngineCallbackTransport
    extends LocationCallback {
        private final LocationEngineCallback<LocationEngineResult> callback;

        GoogleLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> callback) {
            this.callback = callback;
        }

        public void onLocationResult(LocationResult locationResult) {
            super.onLocationResult(locationResult);
            List locations = locationResult.getLocations();
            if (!locations.isEmpty()) {
                this.callback.onSuccess((Object)LocationEngineResult.create((List)locations));
            } else {
                this.callback.onFailure(new Exception("Unavailable location"));
            }
        }
    }
}

