/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.engine;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GoogleApiAvailability;
import com.mapbox.mapboxsdk.location.engine.LocationEngine;
import com.mapbox.mapboxsdk.location.engine.LocationEngineImpl;
import com.mapbox.mapboxsdk.location.engine.LocationEngineProxy;
import com.mapbox.mapboxsdk.location.engine.MapboxFusedLocationEngineImpl;
import com.mapbox.services.android.navigation.v5.location.engine.GoogleLocationEngineImpl;
import com.mapbox.services.android.navigation.v5.location.engine.Utils;

public final class LocationEngineProvider {
    private static final String GOOGLE_LOCATION_SERVICES = "com.google.android.gms.location.LocationServices";
    private static final String GOOGLE_API_AVAILABILITY = "com.google.android.gms.common.GoogleApiAvailability";

    private LocationEngineProvider() {
    }

    @Deprecated
    @NonNull
    public static LocationEngine getBestLocationEngine(@NonNull Context context, boolean background) {
        return LocationEngineProvider.getBestLocationEngine(context);
    }

    @NonNull
    public static LocationEngine getBestLocationEngine(@NonNull Context context) {
        Utils.checkNotNull(context, "context == null");
        boolean hasGoogleLocationServices = Utils.isOnClasspath(GOOGLE_LOCATION_SERVICES);
        if (Utils.isOnClasspath(GOOGLE_API_AVAILABILITY)) {
            hasGoogleLocationServices &= GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        }
        return LocationEngineProvider.getLocationEngine(context, hasGoogleLocationServices);
    }

    private static LocationEngine getLocationEngine(Context context, boolean isGoogle) {
        return isGoogle ? new LocationEngineProxy((LocationEngineImpl)new GoogleLocationEngineImpl(context.getApplicationContext())) : new LocationEngineProxy((LocationEngineImpl)new MapboxFusedLocationEngineImpl(context.getApplicationContext()));
    }
}

