/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.replay;

import android.location.Location;
import android.os.Handler;
import androidx.annotation.NonNull;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayLocationListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

class ReplayLocationDispatcher
implements Runnable {
    private static final String NON_NULL_AND_NON_EMPTY_LOCATION_LIST_REQUIRED = "Non-null and non-empty location list required.";
    private static final int HEAD = 0;
    private List<Location> locationsToReplay;
    private Location current;
    private Handler handler;
    private CopyOnWriteArraySet<ReplayLocationListener> replayLocationListeners;

    ReplayLocationDispatcher(@NonNull List<Location> locationsToReplay) {
        this.checkValidInput(locationsToReplay);
        this.locationsToReplay = new CopyOnWriteArrayList<Location>(locationsToReplay);
        this.initialize();
        this.replayLocationListeners = new CopyOnWriteArraySet();
        this.handler = new Handler();
    }

    ReplayLocationDispatcher(List<Location> locationsToReplay, Handler handler) {
        this.checkValidInput(locationsToReplay);
        this.locationsToReplay = locationsToReplay;
        this.initialize();
        this.replayLocationListeners = new CopyOnWriteArraySet();
        this.handler = handler;
    }

    @Override
    public void run() {
        this.dispatchLocation(this.current);
        this.scheduleNextDispatch();
    }

    void stop() {
        this.clearLocations();
        this.stopDispatching();
    }

    void pause() {
        this.stopDispatching();
    }

    void update(@NonNull List<Location> locationsToReplay) {
        this.checkValidInput(locationsToReplay);
        this.locationsToReplay = new CopyOnWriteArrayList<Location>(locationsToReplay);
        this.initialize();
    }

    void add(@NonNull List<Location> toReplay) {
        boolean shouldRedispatch = this.locationsToReplay.isEmpty();
        this.addLocations(toReplay);
        if (shouldRedispatch) {
            this.stopDispatching();
            this.scheduleNextDispatch();
        }
    }

    void addReplayLocationListener(ReplayLocationListener listener) {
        this.replayLocationListeners.add(listener);
    }

    void removeReplayLocationListener(ReplayLocationListener listener) {
        this.replayLocationListeners.remove(listener);
    }

    private void checkValidInput(List<Location> locations) {
        boolean isValidInput;
        boolean bl = isValidInput = locations == null || locations.isEmpty();
        if (isValidInput) {
            throw new IllegalArgumentException(NON_NULL_AND_NON_EMPTY_LOCATION_LIST_REQUIRED);
        }
    }

    private void initialize() {
        this.current = this.locationsToReplay.remove(0);
    }

    private void addLocations(List<Location> toReplay) {
        this.locationsToReplay.addAll(toReplay);
    }

    private void dispatchLocation(Location location) {
        for (ReplayLocationListener listener : this.replayLocationListeners) {
            listener.onLocationReplay(location);
        }
    }

    private void scheduleNextDispatch() {
        if (this.locationsToReplay.isEmpty()) {
            this.stopDispatching();
            return;
        }
        long currentTime = this.current.getTime();
        this.current = this.locationsToReplay.remove(0);
        long nextTime = this.current.getTime();
        long diff = nextTime - currentTime;
        this.handler.postDelayed((Runnable)this, diff);
    }

    private void clearLocations() {
        this.locationsToReplay.clear();
    }

    private void stopDispatching() {
        this.handler.removeCallbacks((Runnable)this);
    }
}

