/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.replay;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.location.engine.LocationEngine;
import com.mapbox.mapboxsdk.location.engine.LocationEngineCallback;
import com.mapbox.mapboxsdk.location.engine.LocationEngineRequest;
import com.mapbox.mapboxsdk.location.engine.LocationEngineResult;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayLocationDispatcher;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayLocationListener;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayRouteLocationConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ReplayRouteLocationEngine
implements LocationEngine,
Runnable {
    private static final int HEAD = 0;
    private static final int MOCKED_POINTS_LEFT_THRESHOLD = 5;
    private static final int ONE_SECOND_IN_MILLISECONDS = 1000;
    private static final int FORTY_FIVE_KM_PER_HOUR = 45;
    private static final int DEFAULT_SPEED = 45;
    private static final int ONE_SECOND = 1;
    private static final int DEFAULT_DELAY = 1;
    private static final int DO_NOT_DELAY = 0;
    private static final int ZERO = 0;
    private static final String SPEED_MUST_BE_GREATER_THAN_ZERO_KM_H = "Speed must be greater than 0 km/h.";
    private static final String DELAY_MUST_BE_GREATER_THAN_ZERO_SECONDS = "Delay must be greater than 0 seconds.";
    private static final String REPLAY_ROUTE = "ReplayRouteLocation";
    private ReplayRouteLocationConverter converter;
    private int speed = 45;
    private int delay = 1;
    private Handler handler;
    private List<Location> mockedLocations;
    private ReplayLocationDispatcher dispatcher;
    private Location lastLocation = null;
    private CopyOnWriteArrayList<LocationEngineCallback<LocationEngineResult>> callbackList = new CopyOnWriteArrayList();
    private final ReplayLocationListener replayLocationListener = new ReplayLocationListener(){

        @Override
        public void onLocationReplay(Location location) {
            ReplayRouteLocationEngine.this.lastLocation = location;
            for (LocationEngineCallback result : ReplayRouteLocationEngine.this.callbackList) {
                result.onSuccess((Object)LocationEngineResult.create((Location)location));
            }
            ReplayRouteLocationEngine.this.lastLocation = location;
            if (!ReplayRouteLocationEngine.this.mockedLocations.isEmpty()) {
                ReplayRouteLocationEngine.this.mockedLocations.remove(0);
            }
        }
    };

    public ReplayRouteLocationEngine() {
        this.handler = new Handler();
    }

    @SuppressLint(value={"MissingPermission"})
    public void assign(DirectionsRoute route) {
        this.start(route);
    }

    @SuppressLint(value={"MissingPermission"})
    public void moveTo(Point point) {
        Location lastLocation = this.getLastLocation();
        if (lastLocation == null) {
            return;
        }
        this.startRoute(point, lastLocation);
    }

    public void assignLastLocation(Point currentPosition) {
        this.initializeLastLocation();
        this.lastLocation.setLongitude(currentPosition.longitude());
        this.lastLocation.setLatitude(currentPosition.latitude());
    }

    public void updateSpeed(int customSpeedInKmPerHour) {
        if (customSpeedInKmPerHour <= 0) {
            throw new IllegalArgumentException(SPEED_MUST_BE_GREATER_THAN_ZERO_KM_H);
        }
        this.speed = customSpeedInKmPerHour;
    }

    public void updateDelay(int customDelayInSeconds) {
        if (customDelayInSeconds <= 0) {
            throw new IllegalArgumentException(DELAY_MUST_BE_GREATER_THAN_ZERO_SECONDS);
        }
        this.delay = customDelayInSeconds;
    }

    @Override
    public void run() {
        List<Location> nextMockedLocations = this.converter.toLocations();
        if (nextMockedLocations.isEmpty()) {
            if (this.converter.isMultiLegRoute()) {
                nextMockedLocations = this.converter.toLocations();
            } else {
                this.handler.removeCallbacks((Runnable)this);
                return;
            }
        }
        this.dispatcher.add(nextMockedLocations);
        this.mockedLocations.addAll(nextMockedLocations);
        this.scheduleNextDispatch();
    }

    private void start(DirectionsRoute route) {
        this.handler.removeCallbacks((Runnable)this);
        this.converter = new ReplayRouteLocationConverter(route, this.speed, this.delay);
        this.converter.initializeTime();
        this.mockedLocations = this.converter.toLocations();
        this.dispatcher = this.obtainDispatcher();
        this.dispatcher.run();
        this.scheduleNextDispatch();
    }

    private ReplayLocationDispatcher obtainDispatcher() {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
            this.dispatcher.removeReplayLocationListener(this.replayLocationListener);
        }
        this.dispatcher = new ReplayLocationDispatcher(this.mockedLocations);
        this.dispatcher.addReplayLocationListener(this.replayLocationListener);
        return this.dispatcher;
    }

    private void startRoute(Point point, Location lastLocation) {
        this.handler.removeCallbacks((Runnable)this);
        this.converter.updateSpeed(this.speed);
        this.converter.updateDelay(this.delay);
        this.converter.initializeTime();
        LineString route = this.obtainRoute(point, lastLocation);
        this.mockedLocations = this.converter.calculateMockLocations(this.converter.sliceRoute(route));
        this.dispatcher = this.obtainDispatcher();
        this.dispatcher.run();
    }

    @NonNull
    private LineString obtainRoute(Point point, Location lastLocation) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        pointList.add(Point.fromLngLat((double)lastLocation.getLongitude(), (double)lastLocation.getLatitude()));
        pointList.add(point);
        return LineString.fromLngLats(pointList);
    }

    private void scheduleNextDispatch() {
        int currentMockedPoints = this.mockedLocations.size();
        if (currentMockedPoints == 0) {
            this.handler.postDelayed((Runnable)this, 0L);
        } else if (currentMockedPoints <= 5) {
            this.handler.postDelayed((Runnable)this, 1000L);
        } else {
            this.handler.postDelayed((Runnable)this, (long)((currentMockedPoints - 5) * 1000));
        }
    }

    private void initializeLastLocation() {
        if (this.lastLocation == null) {
            this.lastLocation = new Location(REPLAY_ROUTE);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public Location getLastLocation() {
        return this.lastLocation;
    }

    public void onStop() {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        this.handler.removeCallbacks((Runnable)this);
        for (LocationEngineCallback<LocationEngineResult> callback : this.callbackList) {
            this.callbackList.remove(callback);
        }
        if (this.dispatcher != null) {
            this.dispatcher.removeReplayLocationListener(this.replayLocationListener);
        }
    }

    public void getLastLocation(@NonNull LocationEngineCallback<LocationEngineResult> callback) throws SecurityException {
        if (this.lastLocation != null) {
            callback.onSuccess((Object)LocationEngineResult.create((Location)this.lastLocation));
        } else {
            callback.onFailure(new Exception("No last location"));
        }
    }

    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull LocationEngineCallback<LocationEngineResult> callback, @Nullable Looper looper) throws SecurityException {
        this.callbackList.add(callback);
    }

    public void requestLocationUpdates(@NonNull LocationEngineRequest request, PendingIntent pendingIntent) throws SecurityException {
    }

    public void removeLocationUpdates(@NonNull LocationEngineCallback<LocationEngineResult> callback) {
        this.callbackList.remove(callback);
    }

    public void removeLocationUpdates(PendingIntent pendingIntent) {
    }
}

