/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.milestone;

import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.Trigger;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;

public class BannerInstructionMilestone
extends Milestone {
    private BannerInstructions instructions;
    private RouteUtils routeUtils = new RouteUtils();

    BannerInstructionMilestone(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isOccurring(RouteProgress previousRouteProgress, RouteProgress routeProgress) {
        double stepDistanceRemaining;
        RouteLegProgress legProgress = routeProgress.currentLegProgress();
        LegStep currentStep = legProgress.currentStep();
        BannerInstructions instructions = this.routeUtils.findCurrentBannerInstructions(currentStep, stepDistanceRemaining = legProgress.currentStepProgress().distanceRemaining());
        if (this.shouldBeShown(instructions, stepDistanceRemaining)) {
            this.instructions = instructions;
            return true;
        }
        return false;
    }

    public BannerInstructions getBannerInstructions() {
        return this.instructions;
    }

    private boolean shouldBeShown(BannerInstructions instructions, double stepDistanceRemaining) {
        boolean isNewInstruction = this.instructions == null || !this.instructions.equals(instructions);
        boolean isValidNewInstruction = instructions != null && isNewInstruction;
        boolean withinDistanceAlongGeometry = isValidNewInstruction && instructions.distanceAlongGeometry() >= stepDistanceRemaining;
        boolean isFirstInstruction = this.instructions == null && instructions != null;
        return isFirstInstruction || withinDistanceAlongGeometry;
    }

    public static final class Builder
    extends Milestone.Builder {
        private Trigger.Statement trigger;

        @Override
        Trigger.Statement getTrigger() {
            return this.trigger;
        }

        @Override
        public Builder setTrigger(Trigger.Statement trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public BannerInstructionMilestone build() {
            return new BannerInstructionMilestone(this);
        }
    }
}

