/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.milestone;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.VoiceInstructions;
import com.mapbox.services.android.navigation.v5.instruction.Instruction;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.Trigger;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;

public class VoiceInstructionMilestone
extends Milestone {
    private static final String EMPTY_STRING = "";
    private VoiceInstructions instructions;
    private DirectionsRoute currentRoute;
    private RouteUtils routeUtils = new RouteUtils();

    VoiceInstructionMilestone(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isOccurring(RouteProgress previousRouteProgress, RouteProgress routeProgress) {
        double stepDistanceRemaining;
        LegStep currentStep = routeProgress.currentLegProgress().currentStep();
        VoiceInstructions instructions = this.routeUtils.findCurrentVoiceInstructions(currentStep, stepDistanceRemaining = routeProgress.currentLegProgress().currentStepProgress().distanceRemaining());
        if (this.shouldBeVoiced(instructions, stepDistanceRemaining)) {
            return this.updateInstructions(routeProgress, instructions);
        }
        return false;
    }

    @Override
    public Instruction getInstruction() {
        return new Instruction(){

            @Override
            public String buildInstruction(RouteProgress routeProgress) {
                if (VoiceInstructionMilestone.this.instructions == null) {
                    return routeProgress.currentLegProgress().currentStep().name();
                }
                return VoiceInstructionMilestone.this.instructions.announcement();
            }
        };
    }

    public String getSsmlAnnouncement() {
        if (this.instructions == null) {
            return EMPTY_STRING;
        }
        return this.instructions.ssmlAnnouncement();
    }

    public String getAnnouncement() {
        if (this.instructions == null) {
            return EMPTY_STRING;
        }
        return this.instructions.announcement();
    }

    private boolean isNewRoute(RouteProgress routeProgress) {
        boolean newRoute = this.currentRoute == null || !this.currentRoute.equals(routeProgress.directionsRoute());
        this.currentRoute = routeProgress.directionsRoute();
        return newRoute;
    }

    private boolean shouldBeVoiced(VoiceInstructions instructions, double stepDistanceRemaining) {
        boolean isNewInstruction = this.instructions == null || !this.instructions.equals(instructions);
        boolean isValidNewInstruction = instructions != null && isNewInstruction;
        return isValidNewInstruction && instructions.distanceAlongGeometry() >= stepDistanceRemaining;
    }

    private boolean updateInstructions(RouteProgress routeProgress, VoiceInstructions instructions) {
        this.instructions = instructions;
        return true;
    }

    public static final class Builder
    extends Milestone.Builder {
        private Trigger.Statement trigger;

        @Override
        Trigger.Statement getTrigger() {
            return this.trigger;
        }

        @Override
        public Builder setTrigger(Trigger.Statement trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public VoiceInstructionMilestone build() {
            return new VoiceInstructionMilestone(this);
        }
    }
}

