/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.mapboxsdk.location.engine.LocationEngine;
import com.mapbox.services.android.navigation.v5.location.engine.LocationEngineProvider;
import com.mapbox.services.android.navigation.v5.milestone.BannerInstructionMilestone;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.milestone.MilestoneEventListener;
import com.mapbox.services.android.navigation.v5.milestone.VoiceInstructionMilestone;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEngineFactory;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationService;
import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.offroute.OffRoute;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteListener;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.route.FasterRouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.snap.Snap;
import com.mapbox.services.android.navigation.v5.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import timber.log.Timber;

public class MapboxNavigation
implements ServiceConnection {
    private NavigationEventDispatcher navigationEventDispatcher;
    private NavigationEngineFactory navigationEngineFactory;
    private NavigationService navigationService;
    private DirectionsRoute directionsRoute;
    private MapboxNavigationOptions options;
    private LocationEngine locationEngine = null;
    private Set<Milestone> milestones;
    private Context applicationContext;
    private boolean isBound;

    public MapboxNavigation(@NonNull Context context) {
        this(context, MapboxNavigationOptions.builder().build());
    }

    public MapboxNavigation(@NonNull Context context, @NonNull MapboxNavigationOptions options) {
        this.initializeContext(context);
        this.options = options;
        this.initialize();
    }

    public MapboxNavigation(@NonNull Context context, @NonNull MapboxNavigationOptions options, @NonNull LocationEngine locationEngine) {
        this.initializeContext(context);
        this.options = options;
        this.locationEngine = locationEngine;
        this.initialize();
    }

    MapboxNavigation(@NonNull Context context, LocationEngine locationEngine) {
        this.initializeContext(context);
        this.options = MapboxNavigationOptions.builder().build();
        this.locationEngine = locationEngine;
        this.initialize();
    }

    private void initialize() {
        this.navigationEventDispatcher = new NavigationEventDispatcher();
        this.navigationEngineFactory = new NavigationEngineFactory();
        this.initializeDefaultLocationEngine();
        this.milestones = new HashSet<Milestone>();
        if (this.options.defaultMilestonesEnabled()) {
            this.addMilestone(new VoiceInstructionMilestone.Builder().setIdentifier(1).build());
            this.addMilestone(new BannerInstructionMilestone.Builder().setIdentifier(2).build());
        }
    }

    private void initializeContext(Context context) {
        if (context == null || context.getApplicationContext() == null) {
            throw new IllegalArgumentException("Non-null application context required.");
        }
        this.applicationContext = context.getApplicationContext();
    }

    private void initializeDefaultLocationEngine() {
        this.locationEngine = this.obtainLocationEngine();
    }

    private LocationEngine obtainLocationEngine() {
        if (this.locationEngine == null) {
            return LocationEngineProvider.getBestLocationEngine(this.applicationContext);
        }
        return this.locationEngine;
    }

    public void onDestroy() {
        this.stopNavigation();
        this.removeOffRouteListener(null);
        this.removeProgressChangeListener(null);
        this.removeMilestoneEventListener(null);
        this.removeNavigationEventListener(null);
    }

    public void addMilestone(@NonNull Milestone milestone) {
        boolean milestoneAdded = this.milestones.add(milestone);
        if (!milestoneAdded) {
            Timber.w((String)"Milestone has already been added to the stack.", (Object[])new Object[0]);
        }
    }

    public void addMilestones(@NonNull List<Milestone> milestones) {
        boolean milestonesAdded = this.milestones.addAll(milestones);
        if (!milestonesAdded) {
            Timber.w((String)"These milestones have already been added to the stack.", (Object[])new Object[0]);
        }
    }

    public void removeMilestone(@Nullable Milestone milestone) {
        if (milestone == null) {
            this.milestones.clear();
            return;
        }
        if (!this.milestones.contains(milestone)) {
            Timber.w((String)"Milestone attempting to remove does not exist in stack.", (Object[])new Object[0]);
            return;
        }
        this.milestones.remove(milestone);
    }

    public void removeMilestone(int milestoneIdentifier) {
        for (Milestone milestone : this.milestones) {
            if (milestoneIdentifier != milestone.getIdentifier()) continue;
            this.removeMilestone(milestone);
            return;
        }
        Timber.w((String)"No milestone found with the specified identifier.", (Object[])new Object[0]);
    }

    public void setLocationEngine(@NonNull LocationEngine locationEngine) {
        this.locationEngine = locationEngine;
        if (this.isServiceAvailable()) {
            this.navigationService.updateLocationEngine(locationEngine);
        }
    }

    @NonNull
    public LocationEngine getLocationEngine() {
        return this.locationEngine;
    }

    public void startNavigation(@NonNull DirectionsRoute directionsRoute) {
        ValidationUtils.validDirectionsRoute(directionsRoute, this.options.defaultMilestonesEnabled());
        this.directionsRoute = directionsRoute;
        Timber.d((String)"MapboxNavigation startNavigation called.", (Object[])new Object[0]);
        if (!this.isBound) {
            Intent intent = this.getServiceIntent();
            if (Build.VERSION.SDK_INT >= 26) {
                this.applicationContext.startForegroundService(intent);
            } else {
                this.applicationContext.startService(intent);
            }
            this.applicationContext.bindService(intent, (ServiceConnection)this, 1);
            this.navigationEventDispatcher.onNavigationEvent(true);
        }
    }

    public void stopNavigation() {
        Timber.d((String)"MapboxNavigation stopNavigation called", (Object[])new Object[0]);
        if (this.isServiceAvailable()) {
            this.applicationContext.unbindService((ServiceConnection)this);
            this.isBound = false;
            this.navigationService.endNavigation();
            this.navigationService.stopSelf();
            this.navigationEventDispatcher.onNavigationEvent(false);
        }
    }

    public void addMilestoneEventListener(@NonNull MilestoneEventListener milestoneEventListener) {
        this.navigationEventDispatcher.addMilestoneEventListener(milestoneEventListener);
    }

    public void removeMilestoneEventListener(@Nullable MilestoneEventListener milestoneEventListener) {
        this.navigationEventDispatcher.removeMilestoneEventListener(milestoneEventListener);
    }

    public void addProgressChangeListener(@NonNull ProgressChangeListener progressChangeListener) {
        this.navigationEventDispatcher.addProgressChangeListener(progressChangeListener);
    }

    public void removeProgressChangeListener(@Nullable ProgressChangeListener progressChangeListener) {
        this.navigationEventDispatcher.removeProgressChangeListener(progressChangeListener);
    }

    public void addOffRouteListener(@NonNull OffRouteListener offRouteListener) {
        this.navigationEventDispatcher.addOffRouteListener(offRouteListener);
    }

    public void removeOffRouteListener(@Nullable OffRouteListener offRouteListener) {
        this.navigationEventDispatcher.removeOffRouteListener(offRouteListener);
    }

    public void addNavigationEventListener(@NonNull NavigationEventListener navigationEventListener) {
        this.navigationEventDispatcher.addNavigationEventListener(navigationEventListener);
    }

    public void removeNavigationEventListener(@Nullable NavigationEventListener navigationEventListener) {
        this.navigationEventDispatcher.removeNavigationEventListener(navigationEventListener);
    }

    public void addFasterRouteListener(@NonNull FasterRouteListener fasterRouteListener) {
        this.navigationEventDispatcher.addFasterRouteListener(fasterRouteListener);
    }

    public void removeFasterRouteListener(@Nullable FasterRouteListener fasterRouteListener) {
        this.navigationEventDispatcher.removeFasterRouteListener(fasterRouteListener);
    }

    public void setCameraEngine(@NonNull Camera cameraEngine) {
        this.navigationEngineFactory.updateCameraEngine(cameraEngine);
    }

    @NonNull
    public Camera getCameraEngine() {
        return this.navigationEngineFactory.retrieveCameraEngine();
    }

    public void setSnapEngine(@NonNull Snap snapEngine) {
        this.navigationEngineFactory.updateSnapEngine(snapEngine);
    }

    public Snap getSnapEngine() {
        return this.navigationEngineFactory.retrieveSnapEngine();
    }

    public void setOffRouteEngine(@NonNull OffRoute offRouteEngine) {
        this.navigationEngineFactory.updateOffRouteEngine(offRouteEngine);
    }

    @NonNull
    public OffRoute getOffRouteEngine() {
        return this.navigationEngineFactory.retrieveOffRouteEngine();
    }

    public void setFasterRouteEngine(@NonNull FasterRoute fasterRouteEngine) {
        this.navigationEngineFactory.updateFasterRouteEngine(fasterRouteEngine);
    }

    @NonNull
    public FasterRoute getFasterRouteEngine() {
        return this.navigationEngineFactory.retrieveFasterRouteEngine();
    }

    DirectionsRoute getRoute() {
        return this.directionsRoute;
    }

    List<Milestone> getMilestones() {
        return new ArrayList<Milestone>(this.milestones);
    }

    MapboxNavigationOptions options() {
        return this.options;
    }

    NavigationEventDispatcher getEventDispatcher() {
        return this.navigationEventDispatcher;
    }

    NavigationEngineFactory retrieveEngineProvider() {
        return this.navigationEngineFactory;
    }

    private Intent getServiceIntent() {
        return new Intent(this.applicationContext, NavigationService.class);
    }

    private boolean isServiceAvailable() {
        return this.navigationService != null && this.isBound;
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        Timber.d((String)"Connected to service.", (Object[])new Object[0]);
        NavigationService.LocalBinder binder = (NavigationService.LocalBinder)service;
        this.navigationService = binder.getService();
        this.navigationService.startNavigation(this);
        this.isBound = true;
    }

    public void onServiceDisconnected(ComponentName name) {
        Timber.d((String)"Disconnected from service.", (Object[])new Object[0]);
        this.navigationService = null;
        this.isBound = false;
    }
}

