/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.SpannableString;
import android.text.format.DateFormat;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.services.android.navigation.R;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import com.mapbox.services.android.navigation.v5.utils.ManeuverUtils;
import com.mapbox.services.android.navigation.v5.utils.time.TimeFormatter;
import java.util.Calendar;

class MapboxNavigationNotification
implements NavigationNotification {
    private static final int INTENT_FLAGS = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
    private NotificationCompat.Builder notificationBuilder;
    private NotificationManager notificationManager;
    private Notification notification;
    private RemoteViews collapsedNotificationRemoteViews;
    private RemoteViews expandedNotificationRemoteViews;
    private MapboxNavigation mapboxNavigation;
    private SpannableString currentDistanceText;
    private DistanceFormatter distanceFormatter;
    private String instructionText;
    private int currentManeuverId;
    private boolean isTwentyFourHourFormat;
    private String etaFormat;
    private BroadcastReceiver endNavigationBtnReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            MapboxNavigationNotification.this.onEndNavigationBtnClick();
        }
    };

    MapboxNavigationNotification(Context context, MapboxNavigation mapboxNavigation) {
        this.initialize(context, mapboxNavigation);
    }

    @Override
    public Notification getNotification() {
        return this.notification;
    }

    @Override
    public int getNotificationId() {
        return 5678;
    }

    @Override
    public void updateNotification(RouteProgress routeProgress) {
        this.updateNotificationViews(routeProgress);
    }

    @Override
    public void onNavigationStopped(Context context) {
        this.unregisterReceiver(context);
    }

    private void initialize(Context context, MapboxNavigation mapboxNavigation) {
        this.mapboxNavigation = mapboxNavigation;
        this.etaFormat = context.getString(R.string.eta_format);
        this.initializeDistanceFormatter(context, mapboxNavigation);
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
        this.isTwentyFourHourFormat = DateFormat.is24HourFormat((Context)context);
        this.createNotificationChannel(context);
        this.buildNotification(context);
        this.registerReceiver(context);
    }

    private void initializeDistanceFormatter(Context context, MapboxNavigation mapboxNavigation) {
        RouteOptions routeOptions = mapboxNavigation.getRoute().routeOptions();
        LocaleUtils localeUtils = new LocaleUtils();
        String language = localeUtils.inferDeviceLanguage(context);
        String unitType = localeUtils.getUnitTypeForDeviceLocale(context);
        if (routeOptions != null) {
            language = routeOptions.language();
            unitType = routeOptions.voiceUnits();
        }
        MapboxNavigationOptions mapboxNavigationOptions = mapboxNavigation.options();
        this.distanceFormatter = new DistanceFormatter(context, language, unitType, mapboxNavigationOptions.roundingIncrement());
    }

    private void createNotificationChannel(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel("NAVIGATION_NOTIFICATION_CHANNEL", (CharSequence)context.getString(R.string.channel_name), 2);
            this.notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    private void buildNotification(Context context) {
        this.collapsedNotificationRemoteViews = new RemoteViews(context.getPackageName(), R.layout.collapsed_navigation_notification_layout);
        this.expandedNotificationRemoteViews = new RemoteViews(context.getPackageName(), R.layout.expanded_navigation_notification_layout);
        PendingIntent pendingOpenIntent = this.createPendingOpenIntent(context);
        PendingIntent pendingCloseIntent = this.createPendingCloseIntent(context);
        this.expandedNotificationRemoteViews.setOnClickPendingIntent(R.id.endNavigationBtn, pendingCloseIntent);
        this.notificationBuilder = new NotificationCompat.Builder(context, "NAVIGATION_NOTIFICATION_CHANNEL").setContentIntent(pendingOpenIntent).setCategory("service").setPriority(2).setSmallIcon(R.drawable.ic_navigation).setCustomContentView(this.collapsedNotificationRemoteViews).setCustomBigContentView(this.expandedNotificationRemoteViews).setOngoing(true);
        this.notification = this.notificationBuilder.build();
    }

    private PendingIntent createPendingOpenIntent(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent intent = pm.getLaunchIntentForPackage(context.getPackageName());
        intent.setPackage(null);
        intent.setAction("com.mapbox.intent.action.OPEN_NAVIGATION");
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)INTENT_FLAGS);
    }

    private void registerReceiver(Context context) {
        if (context != null) {
            context.registerReceiver(this.endNavigationBtnReceiver, new IntentFilter("com.mapbox.intent.action.END_NAVIGATION"));
        }
    }

    private void updateNotificationViews(RouteProgress routeProgress) {
        this.updateInstructionText(routeProgress.currentLegProgress().currentStep());
        this.updateDistanceText(routeProgress);
        this.updateArrivalTime(routeProgress);
        LegStep step = routeProgress.currentLegProgress().upComingStep() != null ? routeProgress.currentLegProgress().upComingStep() : routeProgress.currentLegProgress().currentStep();
        this.updateManeuverImage(step);
        this.notificationManager.notify(5678, this.notificationBuilder.build());
    }

    private void unregisterReceiver(Context context) {
        if (context != null) {
            context.unregisterReceiver(this.endNavigationBtnReceiver);
        }
        if (this.notificationManager != null) {
            this.notificationManager.cancel(5678);
        }
    }

    private void updateInstructionText(LegStep step) {
        if (this.hasInstructions(step) && (this.instructionText == null || this.newInstructionText(step))) {
            this.instructionText = ((BannerInstructions)step.bannerInstructions().get(0)).primary().text();
            this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationInstructionText, (CharSequence)this.instructionText);
            this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationInstructionText, (CharSequence)this.instructionText);
        }
    }

    private boolean hasInstructions(LegStep step) {
        return step.bannerInstructions() != null && !step.bannerInstructions().isEmpty();
    }

    private boolean newInstructionText(LegStep step) {
        return !this.instructionText.equals(((BannerInstructions)step.bannerInstructions().get(0)).primary().text());
    }

    private void updateDistanceText(RouteProgress routeProgress) {
        if (this.currentDistanceText == null || this.newDistanceText(routeProgress)) {
            this.currentDistanceText = this.distanceFormatter.formatDistance(routeProgress.currentLegProgress().currentStepProgress().distanceRemaining());
            this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationDistanceText, (CharSequence)this.currentDistanceText);
            this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationDistanceText, (CharSequence)this.currentDistanceText);
        }
    }

    private boolean newDistanceText(RouteProgress routeProgress) {
        return this.currentDistanceText != null && !this.currentDistanceText.toString().equals(this.distanceFormatter.formatDistance(routeProgress.currentLegProgress().currentStepProgress().distanceRemaining()).toString());
    }

    private void updateArrivalTime(RouteProgress routeProgress) {
        MapboxNavigationOptions options = this.mapboxNavigation.options();
        Calendar time = Calendar.getInstance();
        double durationRemaining = routeProgress.durationRemaining();
        int timeFormatType = options.timeFormatType();
        String arrivalTime = TimeFormatter.formatTime(time, durationRemaining, timeFormatType, this.isTwentyFourHourFormat);
        String formattedArrivalTime = String.format(this.etaFormat, arrivalTime);
        this.collapsedNotificationRemoteViews.setTextViewText(R.id.notificationArrivalText, (CharSequence)formattedArrivalTime);
        this.expandedNotificationRemoteViews.setTextViewText(R.id.notificationArrivalText, (CharSequence)formattedArrivalTime);
    }

    private void updateManeuverImage(LegStep step) {
        if (this.newManeuverId(step)) {
            int maneuverResource;
            this.currentManeuverId = maneuverResource = ManeuverUtils.getManeuverResource(step);
            this.collapsedNotificationRemoteViews.setImageViewResource(R.id.maneuverImage, maneuverResource);
            this.expandedNotificationRemoteViews.setImageViewResource(R.id.maneuverImage, maneuverResource);
        }
    }

    private boolean newManeuverId(LegStep step) {
        return this.currentManeuverId != ManeuverUtils.getManeuverResource(step);
    }

    private PendingIntent createPendingCloseIntent(Context context) {
        Intent endNavigationBtn = new Intent("com.mapbox.intent.action.END_NAVIGATION");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)endNavigationBtn, (int)INTENT_FLAGS);
    }

    private void onEndNavigationBtnClick() {
        if (this.mapboxNavigation != null) {
            this.mapboxNavigation.stopNavigation();
        }
    }
}

