/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.mapbox.services.android.navigation.v5.navigation.AutoValue_MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.NavigationConstants;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;

@AutoValue
public abstract class MapboxNavigationOptions {
    public abstract double maxTurnCompletionOffset();

    public abstract double maneuverZoneRadius();

    public abstract double maximumDistanceOffRoute();

    public abstract double deadReckoningTimeInterval();

    public abstract double maxManipulatedCourseAngle();

    public abstract double userLocationSnapDistance();

    public abstract int secondsBeforeReroute();

    public abstract boolean defaultMilestonesEnabled();

    public abstract boolean snapToRoute();

    public abstract boolean enableOffRouteDetection();

    public abstract boolean enableFasterRouteDetection();

    public abstract boolean manuallyEndNavigationUponCompletion();

    public abstract double metersRemainingTillArrival();

    public abstract boolean isFromNavigationUi();

    public abstract double minimumDistanceBeforeRerouting();

    public abstract boolean isDebugLoggingEnabled();

    @Nullable
    public abstract NavigationNotification navigationNotification();

    @NavigationConstants.RoundingIncrement
    public abstract int roundingIncrement();

    public abstract int timeFormatType();

    public abstract int locationAcceptableAccuracyInMetersThreshold();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_MapboxNavigationOptions.Builder().maxTurnCompletionOffset(30.0).maneuverZoneRadius(40.0).maximumDistanceOffRoute(20.0).deadReckoningTimeInterval(1.0).maxManipulatedCourseAngle(25.0).userLocationSnapDistance(10.0).secondsBeforeReroute(3).enableOffRouteDetection(true).enableFasterRouteDetection(false).snapToRoute(true).manuallyEndNavigationUponCompletion(false).defaultMilestonesEnabled(true).minimumDistanceBeforeRerouting(50.0).metersRemainingTillArrival(40.0).isFromNavigationUi(false).isDebugLoggingEnabled(false).roundingIncrement(50).timeFormatType(-1).locationAcceptableAccuracyInMetersThreshold(100);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder maxTurnCompletionOffset(double var1);

        public abstract Builder maneuverZoneRadius(double var1);

        public abstract Builder maximumDistanceOffRoute(double var1);

        public abstract Builder deadReckoningTimeInterval(double var1);

        public abstract Builder maxManipulatedCourseAngle(double var1);

        public abstract Builder userLocationSnapDistance(double var1);

        public abstract Builder secondsBeforeReroute(int var1);

        public abstract Builder defaultMilestonesEnabled(boolean var1);

        public abstract Builder snapToRoute(boolean var1);

        public abstract Builder enableOffRouteDetection(boolean var1);

        public abstract Builder enableFasterRouteDetection(boolean var1);

        public abstract Builder manuallyEndNavigationUponCompletion(boolean var1);

        public abstract Builder metersRemainingTillArrival(double var1);

        public abstract Builder isFromNavigationUi(boolean var1);

        public abstract Builder minimumDistanceBeforeRerouting(double var1);

        public abstract Builder isDebugLoggingEnabled(boolean var1);

        public abstract Builder navigationNotification(NavigationNotification var1);

        public abstract Builder roundingIncrement(@NavigationConstants.RoundingIncrement int var1);

        public abstract Builder timeFormatType(int var1);

        public abstract Builder locationAcceptableAccuracyInMetersThreshold(int var1);

        public abstract MapboxNavigationOptions build();
    }
}

