/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.route.RouteListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import timber.log.Timber;

class NavigationFasterRouteListener
implements RouteListener {
    private static final int FIRST_ROUTE = 0;
    private final NavigationEventDispatcher eventDispatcher;
    private final FasterRoute fasterRouteEngine;

    NavigationFasterRouteListener(NavigationEventDispatcher eventDispatcher, FasterRoute fasterRouteEngine) {
        this.eventDispatcher = eventDispatcher;
        this.fasterRouteEngine = fasterRouteEngine;
    }

    @Override
    public void onResponseReceived(DirectionsResponse response, @Nullable RouteProgress routeProgress) {
        if (this.fasterRouteEngine.isFasterRoute(response, routeProgress)) {
            this.eventDispatcher.onFasterRouteEvent((DirectionsRoute)response.routes().get(0));
        }
    }

    @Override
    public void onErrorReceived(Throwable throwable) {
        Timber.e((Throwable)throwable);
    }
}

