/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import androidx.annotation.NonNull;
import com.mapbox.mapboxsdk.location.engine.LocationEngine;
import com.mapbox.mapboxsdk.location.engine.LocationEngineCallback;
import com.mapbox.mapboxsdk.location.engine.LocationEngineResult;
import com.mapbox.services.android.navigation.v5.location.LocationValidator;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLocationUpdate;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;

class NavigationLocationEngineListener
implements LocationEngineCallback<LocationEngineResult> {
    private final RouteProcessorBackgroundThread thread;
    private final LocationValidator validator;
    private final LocationEngine locationEngine;
    private MapboxNavigation mapboxNavigation;

    NavigationLocationEngineListener(RouteProcessorBackgroundThread thread, MapboxNavigation mapboxNavigation, LocationEngine locationEngine, LocationValidator validator) {
        this.thread = thread;
        this.mapboxNavigation = mapboxNavigation;
        this.locationEngine = locationEngine;
        this.validator = validator;
    }

    boolean isValidLocationUpdate(Location location) {
        return location != null && this.validator.isValidUpdate(location);
    }

    void queueLocationUpdate(Location location) {
        this.thread.queueUpdate(NavigationLocationUpdate.create(location, this.mapboxNavigation));
    }

    public void onSuccess(LocationEngineResult result) {
        if (this.isValidLocationUpdate(result.getLastLocation())) {
            this.queueLocationUpdate(result.getLastLocation());
        }
    }

    public void onFailure(@NonNull Exception exception) {
    }
}

