/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.annotation.SuppressLint;
import android.location.Location;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.mapboxsdk.location.engine.LocationEngine;
import com.mapbox.mapboxsdk.location.engine.LocationEngineCallback;
import com.mapbox.mapboxsdk.location.engine.LocationEngineRequest;
import com.mapbox.mapboxsdk.location.engine.LocationEngineResult;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLocationEngineListener;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;

class NavigationLocationEngineUpdater {
    private final NavigationLocationEngineListener listener;
    private RouteUtils routeUtils;
    private LocationEngine locationEngine;

    @SuppressLint(value={"MissingPermission"})
    NavigationLocationEngineUpdater(LocationEngine locationEngine, NavigationLocationEngineListener listener) {
        this.locationEngine = locationEngine;
        this.listener = listener;
        locationEngine.requestLocationUpdates(new LocationEngineRequest.Builder(1000L).build(), (LocationEngineCallback)listener, Looper.getMainLooper());
    }

    @SuppressLint(value={"MissingPermission"})
    void updateLocationEngine(LocationEngine locationEngine) {
        this.removeLocationEngineListener();
        this.locationEngine = locationEngine;
        locationEngine.requestLocationUpdates(new LocationEngineRequest.Builder(1000L).build(), (LocationEngineCallback)this.listener, Looper.getMainLooper());
    }

    void forceLocationUpdate(final DirectionsRoute route) {
        this.locationEngine.getLastLocation((LocationEngineCallback)new LocationEngineCallback<LocationEngineResult>(){

            public void onSuccess(LocationEngineResult result) {
                Location location = result.getLastLocation();
                if (!NavigationLocationEngineUpdater.this.listener.isValidLocationUpdate(location)) {
                    NavigationLocationEngineUpdater.this.routeUtils = NavigationLocationEngineUpdater.this.obtainRouteUtils();
                    location = NavigationLocationEngineUpdater.this.routeUtils.createFirstLocationFromRoute(route);
                }
                NavigationLocationEngineUpdater.this.listener.queueLocationUpdate(location);
            }

            public void onFailure(@NonNull Exception exception) {
            }
        });
    }

    void removeLocationEngineListener() {
        this.locationEngine.removeLocationUpdates((LocationEngineCallback)this.listener);
    }

    private RouteUtils obtainRouteUtils() {
        if (this.routeUtils == null) {
            return new RouteUtils();
        }
        return this.routeUtils;
    }
}

