/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.MathUtils;
import com.mapbox.services.android.navigation.R;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.route.MapRouteProgressChangeListener;
import com.mapbox.services.android.navigation.v5.route.OnRouteSelectionChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.MapImageUtils;
import com.mapbox.services.android.navigation.v5.utils.MapUtils;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class NavigationMapRoute
implements MapView.OnDidFinishLoadingStyleListener,
MapboxMap.OnMapClickListener,
LifecycleObserver {
    private static final String CONGESTION_KEY = "congestion";
    private static final String SOURCE_KEY = "source";
    private static final String INDEX_KEY = "index";
    private static final String GENERIC_ROUTE_SOURCE_ID = "mapbox-navigation-route-source";
    private static final String GENERIC_ROUTE_LAYER_ID = "mapbox-navigation-route-layer";
    private static final String WAYPOINT_SOURCE_ID = "mapbox-navigation-waypoint-source";
    private static final String WAYPOINT_LAYER_ID = "mapbox-navigation-waypoint-layer";
    private static final String ID_FORMAT = "%s-%d";
    private static final String GENERIC_ROUTE_SHIELD_LAYER_ID = "mapbox-navigation-route-shield-layer";
    private static final int TWO_POINTS = 2;
    private static final int THIRTY = 30;
    private static final String ARROW_BEARING = "mapbox-navigation-arrow-bearing";
    private static final String ARROW_SHAFT_SOURCE_ID = "mapbox-navigation-arrow-shaft-source";
    private static final String ARROW_HEAD_SOURCE_ID = "mapbox-navigation-arrow-head-source";
    private static final String ARROW_SHAFT_CASING_LINE_LAYER_ID = "mapbox-navigation-arrow-shaft-casing-layer";
    private static final String ARROW_SHAFT_LINE_LAYER_ID = "mapbox-navigation-arrow-shaft-layer";
    private static final String ARROW_HEAD_ICON = "mapbox-navigation-arrow-head-icon";
    private static final String ARROW_HEAD_ICON_CASING = "mapbox-navigation-arrow-head-icon-casing";
    private static final int MAX_DEGREES = 360;
    private static final String ARROW_HEAD_CASING_LAYER_ID = "mapbox-navigation-arrow-head-casing-layer";
    private static final Float[] ARROW_HEAD_CASING_OFFSET = new Float[]{Float.valueOf(0.0f), Float.valueOf(-7.0f)};
    private static final String ARROW_HEAD_LAYER_ID = "mapbox-navigation-arrow-head-layer";
    private static final Float[] ARROW_HEAD_OFFSET = new Float[]{Float.valueOf(0.0f), Float.valueOf(-7.0f)};
    private static final int MIN_ARROW_ZOOM = 10;
    private static final int MAX_ARROW_ZOOM = 22;
    private static final float MIN_ZOOM_ARROW_SHAFT_SCALE = 2.6f;
    private static final float MAX_ZOOM_ARROW_SHAFT_SCALE = 13.0f;
    private static final float MIN_ZOOM_ARROW_SHAFT_CASING_SCALE = 3.4f;
    private static final float MAX_ZOOM_ARROW_SHAFT_CASING_SCALE = 17.0f;
    private static final float MIN_ZOOM_ARROW_HEAD_SCALE = 0.2f;
    private static final float MAX_ZOOM_ARROW_HEAD_SCALE = 0.8f;
    private static final float MIN_ZOOM_ARROW_HEAD_CASING_SCALE = 0.2f;
    private static final float MAX_ZOOM_ARROW_HEAD_CASING_SCALE = 0.8f;
    private static final float OPAQUE = 0.0f;
    private static final int ARROW_HIDDEN_ZOOM_LEVEL = 14;
    private static final float TRANSPARENT = 1.0f;
    private static final String LAYER_ABOVE_UPCOMING_MANEUVER_ARROW = "com.mapbox.annotations.points";
    @StyleRes
    private int styleRes;
    @ColorInt
    private int routeDefaultColor;
    @ColorInt
    private int routeModerateColor;
    @ColorInt
    private int routeSevereColor;
    @ColorInt
    private int alternativeRouteDefaultColor;
    @ColorInt
    private int alternativeRouteModerateColor;
    @ColorInt
    private int alternativeRouteSevereColor;
    @ColorInt
    private int alternativeRouteShieldColor;
    @ColorInt
    private int routeShieldColor;
    @ColorInt
    private int arrowColor;
    @ColorInt
    private int arrowBorderColor;
    @DrawableRes
    private int originWaypointIcon;
    @DrawableRes
    private int destinationWaypointIcon;
    private MapboxNavigation navigation;
    private final MapboxMap mapboxMap;
    private final HashMap<LineString, DirectionsRoute> routeLineStrings;
    private final List<FeatureCollection> featureCollections;
    private final List<DirectionsRoute> directionsRoutes;
    private final List<String> layerIds;
    private final MapView mapView;
    private int primaryRouteIndex;
    private float routeScale;
    private float alternativeRouteScale;
    private String belowLayer;
    private boolean alternativesVisible;
    private OnRouteSelectionChangeListener onRouteSelectionChangeListener;
    private List<Layer> arrowLayers;
    private GeoJsonSource arrowShaftGeoJsonSource;
    private GeoJsonSource arrowHeadGeoJsonSource;
    private Feature arrowShaftGeoJsonFeature = Feature.fromGeometry((Geometry)Point.fromLngLat((double)0.0, (double)0.0));
    private Feature arrowHeadGeoJsonFeature = Feature.fromGeometry((Geometry)Point.fromLngLat((double)0.0, (double)0.0));
    private ProgressChangeListener progressChangeListener = new MapRouteProgressChangeListener(this);

    public NavigationMapRoute(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap) {
        this(null, mapView, mapboxMap, R.style.NavigationMapRoute);
    }

    public NavigationMapRoute(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable String belowLayer) {
        this(null, mapView, mapboxMap, R.style.NavigationMapRoute, belowLayer);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap) {
        this(navigation, mapView, mapboxMap, R.style.NavigationMapRoute);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @Nullable String belowLayer) {
        this(navigation, mapView, mapboxMap, R.style.NavigationMapRoute, belowLayer);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @StyleRes int styleRes) {
        this(navigation, mapView, mapboxMap, styleRes, null);
    }

    public NavigationMapRoute(@Nullable MapboxNavigation navigation, @NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @StyleRes int styleRes, @Nullable String belowLayer) {
        this.styleRes = styleRes;
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        this.navigation = navigation;
        this.belowLayer = belowLayer;
        this.featureCollections = new ArrayList<FeatureCollection>();
        this.directionsRoutes = new ArrayList<DirectionsRoute>();
        this.routeLineStrings = new HashMap();
        this.layerIds = new ArrayList<String>();
        this.initialize();
        this.addListeners();
    }

    public void addRoute(DirectionsRoute directionsRoute) {
        ArrayList<DirectionsRoute> routes = new ArrayList<DirectionsRoute>();
        routes.add(directionsRoute);
        this.addRoutes(routes);
    }

    public void addRoutes(@NonNull @Size(min=1L) List<DirectionsRoute> directionsRoutes) {
        this.clearRoutes();
        this.directionsRoutes.addAll(directionsRoutes);
        this.primaryRouteIndex = 0;
        this.alternativesVisible = directionsRoutes.size() > 1;
        this.generateFeatureCollectionList(directionsRoutes);
        this.drawRoutes();
        this.addDirectionWaypoints();
    }

    public void setOnRouteSelectionChangeListener(@Nullable OnRouteSelectionChangeListener onRouteSelectionChangeListener) {
        this.onRouteSelectionChangeListener = onRouteSelectionChangeListener;
    }

    public void showAlternativeRoutes(boolean alternativesVisible) {
        this.alternativesVisible = alternativesVisible;
        this.toggleAlternativeVisibility(alternativesVisible);
    }

    public void addProgressChangeListener(MapboxNavigation navigation) {
        this.navigation = navigation;
        navigation.addProgressChangeListener(this.progressChangeListener);
    }

    public void removeProgressChangeListener(MapboxNavigation navigation) {
        if (navigation != null) {
            navigation.removeProgressChangeListener(this.progressChangeListener);
        }
    }

    public void addUpcomingManeuverArrow(RouteProgress routeProgress) {
        boolean invalidCurrentStepPoints;
        boolean invalidUpcomingStepPoints = routeProgress.upcomingStepPoints() == null || routeProgress.upcomingStepPoints().size() < 2;
        boolean bl = invalidCurrentStepPoints = routeProgress.currentStepPoints().size() < 2;
        if (invalidUpcomingStepPoints || invalidCurrentStepPoints) {
            this.updateArrowLayersVisibilityTo(false);
            return;
        }
        this.updateArrowLayersVisibilityTo(true);
        List<Point> maneuverPoints = this.obtainArrowPointsFrom(routeProgress);
        this.updateArrowShaftWith(maneuverPoints);
        this.updateArrowHeadWith(maneuverPoints);
    }

    public List<DirectionsRoute> retrieveDirectionsRoutes() {
        return this.directionsRoutes;
    }

    public int retrievePrimaryRouteIndex() {
        return this.primaryRouteIndex;
    }

    private void toggleAlternativeVisibility(boolean visible) {
        for (String layerId : this.layerIds) {
            Layer layer;
            if (layerId.contains(String.valueOf(this.primaryRouteIndex)) || layerId.contains(WAYPOINT_LAYER_ID) || this.mapboxMap.getStyle() == null || (layer = this.mapboxMap.getStyle().getLayer(layerId)) == null) continue;
            layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)(visible ? "visible" : "none"))});
        }
    }

    private void drawRoutes() {
        for (int i = this.featureCollections.size() - 1; i >= 0; --i) {
            MapUtils.updateMapSourceFromFeatureCollection(this.mapboxMap, this.featureCollections.get(i), ((Feature)this.featureCollections.get(i).features().get(0)).getStringProperty(SOURCE_KEY));
            String sourceId = ((Feature)this.featureCollections.get(i).features().get(0)).getStringProperty(SOURCE_KEY);
            int index = this.featureCollections.indexOf(this.featureCollections.get(i));
            this.layerIds.add(String.format(Locale.US, ID_FORMAT, GENERIC_ROUTE_SHIELD_LAYER_ID, index));
            this.layerIds.add(String.format(Locale.US, ID_FORMAT, GENERIC_ROUTE_LAYER_ID, index));
            this.addRouteShieldLayer(this.layerIds.get(this.layerIds.size() - 2), sourceId, index);
            this.addRouteLayer(this.layerIds.get(this.layerIds.size() - 1), sourceId, index);
        }
    }

    private void clearRoutes() {
        this.removeLayerIds();
        this.updateArrowLayersVisibilityTo(false);
        this.clearRouteListData();
    }

    private void generateFeatureCollectionList(List<DirectionsRoute> directionsRoutes) {
        for (int i = 0; i < directionsRoutes.size(); ++i) {
            this.featureCollections.add(this.addTrafficToSource(directionsRoutes.get(i), i));
        }
        this.featureCollections.add(this.waypointFeatureCollection(directionsRoutes.get(this.primaryRouteIndex)));
    }

    private FeatureCollection waypointFeatureCollection(DirectionsRoute route) {
        ArrayList<Feature> waypointFeatures = new ArrayList<Feature>();
        for (RouteLeg leg : route.legs()) {
            waypointFeatures.add(this.getPointFromLineString(leg, 0));
            waypointFeatures.add(this.getPointFromLineString(leg, leg.steps().size() - 1));
        }
        return FeatureCollection.fromFeatures(waypointFeatures);
    }

    private void addDirectionWaypoints() {
        if (this.featureCollections.size() > 1) {
            MapUtils.updateMapSourceFromFeatureCollection(this.mapboxMap, this.featureCollections.get(this.featureCollections.size() - 1), WAYPOINT_SOURCE_ID);
            this.drawWaypointMarkers(this.mapboxMap, AppCompatResources.getDrawable((Context)this.mapView.getContext(), (int)this.originWaypointIcon), AppCompatResources.getDrawable((Context)this.mapView.getContext(), (int)this.destinationWaypointIcon));
        }
    }

    private void updateArrowLayersVisibilityTo(boolean visible) {
        if (this.arrowLayers != null) {
            Iterator<Layer> iterator = this.arrowLayers.iterator();
            while (iterator.hasNext()) {
                Layer layer;
                String targetVisibility = visible ? "visible" : "none";
                if (targetVisibility.equals((layer = iterator.next()).getVisibility().getValue())) continue;
                layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)targetVisibility)});
            }
        }
    }

    private List<Point> obtainArrowPointsFrom(RouteProgress routeProgress) {
        ArrayList<Point> reversedCurrent = new ArrayList<Point>(routeProgress.currentStepPoints());
        Collections.reverse(reversedCurrent);
        LineString arrowLineCurrent = LineString.fromLngLats(reversedCurrent);
        LineString arrowLineUpcoming = LineString.fromLngLats(routeProgress.upcomingStepPoints());
        LineString arrowCurrentSliced = TurfMisc.lineSliceAlong((LineString)arrowLineCurrent, (double)0.0, (double)30.0, (String)"meters");
        LineString arrowUpcomingSliced = TurfMisc.lineSliceAlong((LineString)arrowLineUpcoming, (double)0.0, (double)30.0, (String)"meters");
        Collections.reverse(arrowCurrentSliced.coordinates());
        ArrayList<Point> combined = new ArrayList<Point>();
        combined.addAll(arrowCurrentSliced.coordinates());
        combined.addAll(arrowUpcomingSliced.coordinates());
        return combined;
    }

    private void updateArrowShaftWith(List<Point> points) {
        LineString shaft = LineString.fromLngLats(points);
        this.arrowShaftGeoJsonFeature = Feature.fromGeometry((Geometry)shaft);
        if (this.arrowShaftGeoJsonSource != null) {
            this.arrowShaftGeoJsonSource.setGeoJson(this.arrowShaftGeoJsonFeature);
        }
    }

    private void updateArrowHeadWith(List<Point> points) {
        double azimuth = TurfMeasurement.bearing((Point)points.get(points.size() - 2), (Point)points.get(points.size() - 1));
        this.arrowHeadGeoJsonFeature = Feature.fromGeometry((Geometry)((Geometry)points.get(points.size() - 1)));
        this.arrowHeadGeoJsonFeature.addNumberProperty(ARROW_BEARING, (Number)Float.valueOf((float)MathUtils.wrap((double)azimuth, (double)0.0, (double)360.0)));
        if (this.arrowHeadGeoJsonSource != null) {
            this.arrowHeadGeoJsonSource.setGeoJson(this.arrowHeadGeoJsonFeature);
        }
    }

    private void initializeUpcomingManeuverArrow() {
        if (this.mapboxMap.getStyle() != null) {
            this.arrowShaftGeoJsonSource = (GeoJsonSource)this.mapboxMap.getStyle().getSource(ARROW_SHAFT_SOURCE_ID);
            this.arrowHeadGeoJsonSource = (GeoJsonSource)this.mapboxMap.getStyle().getSource(ARROW_HEAD_SOURCE_ID);
            LineLayer shaftLayer = this.createArrowShaftLayer();
            LineLayer shaftCasingLayer = this.createArrowShaftCasingLayer();
            SymbolLayer headLayer = this.createArrowHeadLayer();
            SymbolLayer headCasingLayer = this.createArrowHeadCasingLayer();
            if (this.arrowShaftGeoJsonSource == null && this.arrowHeadGeoJsonSource == null) {
                this.initializeArrowShaft();
                this.initializeArrowHead();
                this.addArrowHeadIcon();
                this.addArrowHeadIconCasing();
                this.mapboxMap.getStyle().addLayerBelow((Layer)shaftCasingLayer, LAYER_ABOVE_UPCOMING_MANEUVER_ARROW);
                this.mapboxMap.getStyle().addLayerAbove((Layer)headCasingLayer, shaftCasingLayer.getId());
                this.mapboxMap.getStyle().addLayerAbove((Layer)shaftLayer, headCasingLayer.getId());
                this.mapboxMap.getStyle().addLayerAbove((Layer)headLayer, shaftLayer.getId());
            }
            this.initializeArrowLayers(shaftLayer, shaftCasingLayer, headLayer, headCasingLayer);
        }
    }

    private void initializeArrowShaft() {
        this.arrowShaftGeoJsonSource = new GeoJsonSource(ARROW_SHAFT_SOURCE_ID, this.arrowShaftGeoJsonFeature, new GeoJsonOptions().withMaxZoom(16));
        try {
            this.mapboxMap.getStyle().addSource((Source)this.arrowShaftGeoJsonSource);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initializeArrowHead() {
        this.arrowHeadGeoJsonSource = new GeoJsonSource(ARROW_HEAD_SOURCE_ID, this.arrowShaftGeoJsonFeature, new GeoJsonOptions().withMaxZoom(16));
        if (this.mapboxMap.getStyle() != null) {
            this.mapboxMap.getStyle().addSource((Source)this.arrowHeadGeoJsonSource);
        }
    }

    private void addArrowHeadIcon() {
        Drawable head = DrawableCompat.wrap((Drawable)AppCompatResources.getDrawable((Context)this.mapView.getContext(), (int)R.drawable.ic_arrow_head));
        DrawableCompat.setTint((Drawable)head.mutate(), (int)this.arrowColor);
        Bitmap icon = MapImageUtils.getBitmapFromDrawable(head);
        if (this.mapboxMap.getStyle() != null) {
            this.mapboxMap.getStyle().addImage(ARROW_HEAD_ICON, icon);
        }
    }

    private void addArrowHeadIconCasing() {
        Drawable headCasing = DrawableCompat.wrap((Drawable)AppCompatResources.getDrawable((Context)this.mapView.getContext(), (int)R.drawable.ic_arrow_head_casting));
        DrawableCompat.setTint((Drawable)headCasing.mutate(), (int)this.arrowBorderColor);
        Bitmap icon = MapImageUtils.getBitmapFromDrawable(headCasing);
        if (this.mapboxMap.getStyle() != null) {
            this.mapboxMap.getStyle().addImage(ARROW_HEAD_ICON_CASING, icon);
        }
    }

    private LineLayer createArrowShaftLayer() {
        LineLayer shaftLayer;
        if (this.mapboxMap.getStyle() != null && (shaftLayer = (LineLayer)this.mapboxMap.getStyle().getLayer(ARROW_SHAFT_LINE_LAYER_ID)) != null) {
            return shaftLayer;
        }
        return new LineLayer(ARROW_SHAFT_LINE_LAYER_ID, ARROW_SHAFT_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.lineColor((Expression)Expression.color((int)this.arrowColor)), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(2.6f)), Expression.stop((Object)22, (Object)Float.valueOf(13.0f))})), PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.visibility((String)"none"), PropertyFactory.lineOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private LineLayer createArrowShaftCasingLayer() {
        LineLayer shaftCasingLayer;
        if (this.mapboxMap.getStyle() != null && (shaftCasingLayer = (LineLayer)this.mapboxMap.getStyle().getLayer(ARROW_SHAFT_CASING_LINE_LAYER_ID)) != null) {
            return shaftCasingLayer;
        }
        return new LineLayer(ARROW_SHAFT_CASING_LINE_LAYER_ID, ARROW_SHAFT_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.lineColor((Expression)Expression.color((int)this.arrowBorderColor)), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(3.4f)), Expression.stop((Object)22, (Object)Float.valueOf(17.0f))})), PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.visibility((String)"none"), PropertyFactory.lineOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private SymbolLayer createArrowHeadLayer() {
        SymbolLayer headLayer;
        if (this.mapboxMap.getStyle() != null && (headLayer = (SymbolLayer)this.mapboxMap.getStyle().getLayer(ARROW_HEAD_LAYER_ID)) != null) {
            return headLayer;
        }
        return new SymbolLayer(ARROW_HEAD_LAYER_ID, ARROW_HEAD_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)ARROW_HEAD_ICON), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(0.2f)), Expression.stop((Object)22, (Object)Float.valueOf(0.8f))})), PropertyFactory.iconOffset((Float[])ARROW_HEAD_OFFSET), PropertyFactory.iconRotationAlignment((String)"map"), PropertyFactory.iconRotate((Expression)Expression.get((String)ARROW_BEARING)), PropertyFactory.visibility((String)"none"), PropertyFactory.iconOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private SymbolLayer createArrowHeadCasingLayer() {
        SymbolLayer headCasingLayer;
        if (this.mapboxMap.getStyle() != null && (headCasingLayer = (SymbolLayer)this.mapboxMap.getStyle().getLayer(ARROW_HEAD_CASING_LAYER_ID)) != null) {
            return headCasingLayer;
        }
        return new SymbolLayer(ARROW_HEAD_CASING_LAYER_ID, ARROW_HEAD_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)ARROW_HEAD_ICON), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(0.2f)), Expression.stop((Object)22, (Object)Float.valueOf(0.8f))})), PropertyFactory.iconOffset((Float[])ARROW_HEAD_CASING_OFFSET), PropertyFactory.iconRotationAlignment((String)"map"), PropertyFactory.iconRotate((Expression)Expression.get((String)ARROW_BEARING)), PropertyFactory.visibility((String)"none"), PropertyFactory.iconOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private void initializeArrowLayers(LineLayer shaftLayer, LineLayer shaftCasingLayer, SymbolLayer headLayer, SymbolLayer headCasingLayer) {
        this.arrowLayers = new ArrayList<Layer>();
        this.arrowLayers.add((Layer)shaftCasingLayer);
        this.arrowLayers.add((Layer)shaftLayer);
        this.arrowLayers.add((Layer)headCasingLayer);
        this.arrowLayers.add((Layer)headLayer);
    }

    private void updatePrimaryRoute(String layerId, int index) {
        Layer layer;
        if (this.mapboxMap.getStyle() != null && (layer = this.mapboxMap.getStyle().getLayer(layerId)) != null) {
            layer.setProperties(new PropertyValue[]{PropertyFactory.lineColor((Expression)Expression.match((Expression)Expression.toString((Expression)Expression.get((String)CONGESTION_KEY)), (Expression)Expression.color((int)(index == this.primaryRouteIndex ? this.routeDefaultColor : this.alternativeRouteDefaultColor)), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"moderate", (Object)Expression.color((int)(index == this.primaryRouteIndex ? this.routeModerateColor : this.alternativeRouteModerateColor))), Expression.stop((Object)"heavy", (Object)Expression.color((int)(index == this.primaryRouteIndex ? this.routeSevereColor : this.alternativeRouteSevereColor))), Expression.stop((Object)"severe", (Object)Expression.color((int)(index == this.primaryRouteIndex ? this.routeSevereColor : this.alternativeRouteSevereColor)))}))});
            if (index == this.primaryRouteIndex) {
                this.mapboxMap.getStyle().removeLayer(layer);
                this.mapboxMap.getStyle().addLayerBelow(layer, WAYPOINT_LAYER_ID);
            }
        }
    }

    private void updatePrimaryShieldRoute(String layerId, int index) {
        Layer layer;
        if (this.mapboxMap.getStyle() != null && (layer = this.mapboxMap.getStyle().getLayer(layerId)) != null) {
            layer.setProperties(new PropertyValue[]{PropertyFactory.lineColor((int)(index == this.primaryRouteIndex ? this.routeShieldColor : this.alternativeRouteShieldColor))});
            if (index == this.primaryRouteIndex) {
                this.mapboxMap.getStyle().removeLayer(layer);
                this.mapboxMap.getStyle().addLayerBelow(layer, WAYPOINT_LAYER_ID);
            }
        }
    }

    private void addRouteLayer(String layerId, String sourceId, int index) {
        float scale = index == this.primaryRouteIndex ? this.routeScale : this.alternativeRouteScale;
        LineLayer routeLayer = new LineLayer(layerId, sourceId).withProperties(new PropertyValue[]{PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(4.0f), (Object)Float.valueOf(3.0f * scale)), Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(4.0f * scale)), Expression.stop((Object)Float.valueOf(13.0f), (Object)Float.valueOf(6.0f * scale)), Expression.stop((Object)Float.valueOf(16.0f), (Object)Float.valueOf(10.0f * scale)), Expression.stop((Object)Float.valueOf(19.0f), (Object)Float.valueOf(14.0f * scale)), Expression.stop((Object)Float.valueOf(22.0f), (Object)Float.valueOf(18.0f * scale))})), PropertyFactory.lineColor((Expression)Expression.match((Expression)Expression.toString((Expression)Expression.get((String)CONGESTION_KEY)), (Expression)Expression.color((int)(index == this.primaryRouteIndex ? this.routeDefaultColor : this.alternativeRouteDefaultColor)), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"moderate", (Object)Expression.color((int)(index == this.primaryRouteIndex ? this.routeModerateColor : this.alternativeRouteModerateColor))), Expression.stop((Object)"heavy", (Object)Expression.color((int)(index == this.primaryRouteIndex ? this.routeSevereColor : this.alternativeRouteSevereColor))), Expression.stop((Object)"severe", (Object)Expression.color((int)(index == this.primaryRouteIndex ? this.routeSevereColor : this.alternativeRouteSevereColor)))}))});
        MapUtils.addLayerToMap(this.mapboxMap, (Layer)routeLayer, this.belowLayer);
    }

    private void removeLayerIds() {
        if (!this.layerIds.isEmpty()) {
            try {
                for (String id2 : this.layerIds) {
                    this.mapboxMap.getStyle().removeLayer(id2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void clearRouteListData() {
        if (!this.directionsRoutes.isEmpty()) {
            this.directionsRoutes.clear();
        }
        if (!this.routeLineStrings.isEmpty()) {
            this.routeLineStrings.clear();
        }
        if (!this.featureCollections.isEmpty()) {
            this.featureCollections.clear();
        }
    }

    private void addRouteShieldLayer(String layerId, String sourceId, int index) {
        float scale = index == this.primaryRouteIndex ? this.routeScale : this.alternativeRouteScale;
        LineLayer routeLayer = new LineLayer(layerId, sourceId).withProperties(new PropertyValue[]{PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(7.0f)), Expression.stop((Object)Float.valueOf(14.0f), (Object)Float.valueOf(10.5f * scale)), Expression.stop((Object)Float.valueOf(16.5f), (Object)Float.valueOf(15.5f * scale)), Expression.stop((Object)Float.valueOf(19.0f), (Object)Float.valueOf(24.0f * scale)), Expression.stop((Object)Float.valueOf(22.0f), (Object)Float.valueOf(29.0f * scale))})), PropertyFactory.lineColor((int)(index == this.primaryRouteIndex ? this.routeShieldColor : this.alternativeRouteShieldColor))});
        MapUtils.addLayerToMap(this.mapboxMap, (Layer)routeLayer, this.belowLayer);
    }

    private void getAttributes() {
        Context context = this.mapView.getContext();
        TypedArray typedArray = context.obtainStyledAttributes(this.styleRes, R.styleable.NavigationMapRoute);
        this.routeDefaultColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_blue));
        this.routeModerateColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeModerateCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_congestion_yellow));
        this.routeSevereColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeSevereCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_congestion_red));
        this.routeShieldColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeShieldColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_shield_layer_color));
        this.routeScale = typedArray.getFloat(R.styleable.NavigationMapRoute_routeScale, 1.0f);
        this.alternativeRouteDefaultColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_color));
        this.alternativeRouteModerateColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteModerateCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_congestion_yellow));
        this.alternativeRouteSevereColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteSevereCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_congestion_red));
        this.alternativeRouteShieldColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteShieldColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_shield_color));
        this.alternativeRouteScale = typedArray.getFloat(R.styleable.NavigationMapRoute_alternativeRouteScale, 1.0f);
        this.originWaypointIcon = typedArray.getResourceId(R.styleable.NavigationMapRoute_originWaypointIcon, R.drawable.ic_route_origin);
        this.destinationWaypointIcon = typedArray.getResourceId(R.styleable.NavigationMapRoute_destinationWaypointIcon, R.drawable.ic_route_destination);
        this.arrowColor = typedArray.getColor(R.styleable.NavigationMapRoute_upcomingManeuverArrowColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_upcoming_maneuver_arrow_color));
        this.arrowBorderColor = typedArray.getColor(R.styleable.NavigationMapRoute_upcomingManeuverArrowBorderColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_upcoming_maneuver_arrow_border_color));
        typedArray.recycle();
    }

    private void placeRouteBelow() {
        if ((this.belowLayer == null || this.belowLayer.isEmpty()) && this.mapboxMap.getStyle() != null) {
            List styleLayers = this.mapboxMap.getStyle().getLayers();
            if (styleLayers.isEmpty()) {
                return;
            }
            for (int i = 0; i < styleLayers.size(); ++i) {
                if (styleLayers.get(i) instanceof SymbolLayer || ((Layer)styleLayers.get(i)).getId().contains("mapbox-location")) continue;
                this.belowLayer = ((Layer)styleLayers.get(i)).getId();
            }
        }
    }

    public void placeRouteBelow(String layerId) {
        this.belowLayer = layerId;
        this.initializeUpcomingManeuverArrow();
        this.drawRoutes();
        this.addDirectionWaypoints();
        this.showAlternativeRoutes(this.alternativesVisible);
    }

    private void drawWaypointMarkers(@NonNull MapboxMap mapboxMap, @Nullable Drawable originMarker, @Nullable Drawable destinationMarker) {
        SymbolLayer waypointLayer;
        if (originMarker == null || destinationMarker == null) {
            return;
        }
        if (mapboxMap.getStyle() != null && (waypointLayer = (SymbolLayer)mapboxMap.getStyle().getLayerAs(WAYPOINT_LAYER_ID)) == null) {
            Bitmap bitmap = MapImageUtils.getBitmapFromDrawable(originMarker);
            mapboxMap.getStyle().addImage("originMarker", bitmap);
            bitmap = MapImageUtils.getBitmapFromDrawable(destinationMarker);
            mapboxMap.getStyle().addImage("destinationMarker", bitmap);
            waypointLayer = new SymbolLayer(WAYPOINT_LAYER_ID, WAYPOINT_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((Expression)Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"waypoint")), (Expression)Expression.literal((String)"originMarker"), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"origin", (Object)Expression.literal((String)"originMarker")), Expression.stop((Object)"destination", (Object)Expression.literal((String)"destinationMarker"))})), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(22.0f), (Object)Float.valueOf(2.8f)), Expression.stop((Object)Float.valueOf(12.0f), (Object)Float.valueOf(1.3f)), Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(0.8f)), Expression.stop((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.6f))})), PropertyFactory.iconPitchAlignment((String)"map"), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true)});
            this.layerIds.add(WAYPOINT_LAYER_ID);
            MapUtils.addLayerToMap(mapboxMap, (Layer)waypointLayer, this.belowLayer);
        }
    }

    private Feature getPointFromLineString(RouteLeg leg, int index) {
        Feature feature = Feature.fromGeometry((Geometry)Point.fromLngLat((double)((LegStep)leg.steps().get(index)).maneuver().location().longitude(), (double)((LegStep)leg.steps().get(index)).maneuver().location().latitude()));
        feature.addStringProperty(SOURCE_KEY, WAYPOINT_SOURCE_ID);
        feature.addStringProperty("waypoint", index == 0 ? "origin" : "destination");
        return feature;
    }

    protected void initialize() {
        this.alternativesVisible = true;
        this.getAttributes();
        this.placeRouteBelow();
        this.initializeUpcomingManeuverArrow();
    }

    protected void addListeners() {
        this.mapboxMap.addOnMapClickListener((MapboxMap.OnMapClickListener)this);
        if (this.navigation != null) {
            this.navigation.addProgressChangeListener(this.progressChangeListener);
        }
        this.mapView.addOnDidFinishLoadingStyleListener((MapView.OnDidFinishLoadingStyleListener)this);
    }

    public void removeRoute() {
        this.clearRoutes();
    }

    public boolean onMapClick(LatLng point) {
        if (this.invalidMapClick()) {
            return false;
        }
        int currentRouteIndex = this.primaryRouteIndex;
        if (this.findClickedRoute(point)) {
            return true;
        }
        this.checkNewRouteFound(currentRouteIndex);
        return false;
    }

    private boolean invalidMapClick() {
        return this.routeLineStrings == null || this.routeLineStrings.isEmpty() || !this.alternativesVisible;
    }

    private boolean findClickedRoute(@NonNull LatLng point) {
        HashMap<Double, DirectionsRoute> routeDistancesAwayFromClick = new HashMap<Double, DirectionsRoute>();
        Point clickPoint = Point.fromLngLat((double)point.getLongitude(), (double)point.getLatitude());
        if (this.calculateClickDistancesFromRoutes(routeDistancesAwayFromClick, clickPoint)) {
            return true;
        }
        ArrayList<Double> distancesAwayFromClick = new ArrayList<Double>(routeDistancesAwayFromClick.keySet());
        Collections.sort(distancesAwayFromClick);
        DirectionsRoute clickedRoute = routeDistancesAwayFromClick.get(distancesAwayFromClick.get(0));
        this.primaryRouteIndex = this.directionsRoutes.indexOf(clickedRoute);
        return false;
    }

    private boolean calculateClickDistancesFromRoutes(HashMap<Double, DirectionsRoute> routeDistancesAwayFromClick, Point clickPoint) {
        for (LineString lineString : this.routeLineStrings.keySet()) {
            Point pointOnLine = this.findPointOnLine(clickPoint, lineString);
            if (pointOnLine == null) {
                return true;
            }
            double distance = TurfMeasurement.distance((Point)clickPoint, (Point)pointOnLine, (String)"meters");
            routeDistancesAwayFromClick.put(distance, this.routeLineStrings.get(lineString));
        }
        return false;
    }

    private Point findPointOnLine(Point clickPoint, LineString lineString) {
        List linePoints = lineString.coordinates();
        Feature feature = TurfMisc.nearestPointOnLine((Point)clickPoint, (List)linePoints);
        return (Point)feature.geometry();
    }

    private void checkNewRouteFound(int currentRouteIndex) {
        if (currentRouteIndex != this.primaryRouteIndex) {
            boolean isValidPrimaryIndex;
            this.updateRoute();
            boolean bl = isValidPrimaryIndex = this.primaryRouteIndex >= 0 && this.primaryRouteIndex < this.directionsRoutes.size();
            if (isValidPrimaryIndex && this.onRouteSelectionChangeListener != null) {
                DirectionsRoute selectedRoute = this.directionsRoutes.get(this.primaryRouteIndex);
                this.onRouteSelectionChangeListener.onNewPrimaryRouteSelected(selectedRoute);
            }
        }
    }

    private void updateRoute() {
        for (FeatureCollection featureCollection : this.featureCollections) {
            if (((Feature)featureCollection.features().get(0)).geometry() instanceof Point) continue;
            int index = ((Feature)featureCollection.features().get(0)).getNumberProperty(INDEX_KEY).intValue();
            this.updatePrimaryShieldRoute(String.format(Locale.US, ID_FORMAT, GENERIC_ROUTE_SHIELD_LAYER_ID, index), index);
            this.updatePrimaryRoute(String.format(Locale.US, ID_FORMAT, GENERIC_ROUTE_LAYER_ID, index), index);
        }
    }

    public void onDidFinishLoadingStyle() {
        this.placeRouteBelow();
        this.initializeUpcomingManeuverArrow();
        this.drawRoutes();
        this.addDirectionWaypoints();
        this.showAlternativeRoutes(this.alternativesVisible);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        if (this.navigation != null) {
            this.navigation.addProgressChangeListener(this.progressChangeListener);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        if (this.navigation != null) {
            this.navigation.removeProgressChangeListener(this.progressChangeListener);
        }
    }

    private FeatureCollection addTrafficToSource(DirectionsRoute route, int index) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        LineString originalGeometry = LineString.fromPolyline((String)route.geometry(), (int)6);
        this.buildRouteFeatureFromGeometry(index, features, originalGeometry);
        this.routeLineStrings.put(originalGeometry, route);
        LineString lineString = LineString.fromPolyline((String)route.geometry(), (int)6);
        this.buildTrafficFeaturesFromRoute(route, index, features, lineString);
        return FeatureCollection.fromFeatures(features);
    }

    private void buildRouteFeatureFromGeometry(int index, List<Feature> features, LineString originalGeometry) {
        Feature feat = Feature.fromGeometry((Geometry)originalGeometry);
        feat.addStringProperty(SOURCE_KEY, String.format(Locale.US, ID_FORMAT, GENERIC_ROUTE_SOURCE_ID, index));
        feat.addNumberProperty(INDEX_KEY, (Number)index);
        features.add(feat);
    }

    private void buildTrafficFeaturesFromRoute(DirectionsRoute route, int index, List<Feature> features, LineString lineString) {
        for (RouteLeg leg : route.legs()) {
            if (leg.annotation() != null && leg.annotation().congestion() != null) {
                for (int i = 0; i < leg.annotation().congestion().size(); ++i) {
                    if (leg.annotation().congestion().size() + 1 > lineString.coordinates().size()) continue;
                    ArrayList<Point> points = new ArrayList<Point>();
                    points.add((Point)lineString.coordinates().get(i));
                    points.add((Point)lineString.coordinates().get(i + 1));
                    LineString congestionLineString = LineString.fromLngLats(points);
                    Feature feature = Feature.fromGeometry((Geometry)congestionLineString);
                    feature.addStringProperty(CONGESTION_KEY, (String)leg.annotation().congestion().get(i));
                    feature.addStringProperty(SOURCE_KEY, String.format(Locale.US, ID_FORMAT, GENERIC_ROUTE_SOURCE_ID, index));
                    feature.addNumberProperty(INDEX_KEY, (Number)index);
                    features.add(feature);
                }
                continue;
            }
            Feature feature = Feature.fromGeometry((Geometry)lineString);
            features.add(feature);
        }
    }
}

