/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationNotification;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;

class NavigationNotificationProvider {
    private NavigationNotification navigationNotification;
    private boolean shouldUpdate = true;

    NavigationNotificationProvider(Context context, MapboxNavigation mapboxNavigation) {
        this.navigationNotification = this.buildNotificationFrom(context, mapboxNavigation);
    }

    NavigationNotification retrieveNotification() {
        return this.navigationNotification;
    }

    void updateNavigationNotification(RouteProgress routeProgress) {
        if (this.shouldUpdate) {
            this.navigationNotification.updateNotification(routeProgress);
        }
    }

    void shutdown(Context context) {
        this.navigationNotification.onNavigationStopped(context);
        this.navigationNotification = null;
        this.shouldUpdate = false;
    }

    private NavigationNotification buildNotificationFrom(Context context, MapboxNavigation mapboxNavigation) {
        MapboxNavigationOptions options = mapboxNavigation.options();
        if (options.navigationNotification() != null) {
            return options.navigationNotification();
        }
        return new MapboxNavigationNotification(context, mapboxNavigation);
    }
}

