/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.content.Context;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.api.directions.v5.MapboxDirections;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import java.util.List;
import java.util.Locale;
import okhttp3.Interceptor;
import retrofit2.Call;
import retrofit2.Callback;

public final class NavigationRoute {
    private final MapboxDirections mapboxDirections;

    private NavigationRoute(MapboxDirections mapboxDirections) {
        this.mapboxDirections = mapboxDirections;
    }

    public static Builder builder(Context context) {
        return NavigationRoute.builder(context, new LocaleUtils());
    }

    static Builder builder(Context context, LocaleUtils localeUtils) {
        return new Builder().annotations("congestion", "distance").language(context, localeUtils).voiceUnits(context, localeUtils).profile("driving-traffic");
    }

    public void getRoute(Callback<DirectionsResponse> callback) {
        this.mapboxDirections.enqueueCall(callback);
    }

    public Call<DirectionsResponse> getCall() {
        return this.mapboxDirections.cloneCall();
    }

    public void cancelCall() {
        this.getCall().cancel();
    }

    public static final class Builder {
        private final MapboxDirections.Builder directionsBuilder = MapboxDirections.builder();

        private Builder() {
        }

        public Builder user(@NonNull String user) {
            this.directionsBuilder.user(user);
            return this;
        }

        public Builder profile(@NonNull String profile) {
            this.directionsBuilder.profile(profile);
            return this;
        }

        public Builder origin(@NonNull Point origin) {
            this.origin(origin, null, null);
            return this;
        }

        public Builder origin(@NonNull Point origin, @Nullable Double angle, @Nullable Double tolerance) {
            this.directionsBuilder.origin(origin);
            this.directionsBuilder.addBearing(angle, tolerance);
            return this;
        }

        public Builder destination(@NonNull Point destination) {
            this.destination(destination, null, null);
            return this;
        }

        public Builder destination(@NonNull Point destination, @Nullable Double angle, @Nullable Double tolerance) {
            this.directionsBuilder.destination(destination);
            this.directionsBuilder.addBearing(angle, tolerance);
            return this;
        }

        public Builder addWaypoint(@NonNull Point waypoint) {
            this.directionsBuilder.addWaypoint(waypoint);
            this.directionsBuilder.addBearing(null, null);
            return this;
        }

        public Builder addWaypoint(@NonNull Point waypoint, @Nullable Double angle, @Nullable Double tolerance) {
            this.directionsBuilder.addWaypoint(waypoint);
            this.directionsBuilder.addBearing(angle, tolerance);
            return this;
        }

        public Builder alternatives(@Nullable Boolean alternatives) {
            this.directionsBuilder.alternatives(alternatives);
            return this;
        }

        public Builder language(Locale language) {
            this.directionsBuilder.language(language);
            return this;
        }

        Builder language(Context context, LocaleUtils localeUtils) {
            this.directionsBuilder.language(localeUtils.inferDeviceLocale(context));
            return this;
        }

        public Builder annotations(String ... annotations) {
            this.directionsBuilder.annotations(annotations);
            return this;
        }

        public Builder addBearing(@Nullable @FloatRange(from=0.0, to=360.0) Double angle, @Nullable @FloatRange(from=0.0, to=360.0) Double tolerance) {
            this.directionsBuilder.addBearing(angle, tolerance);
            return this;
        }

        public Builder radiuses(@FloatRange(from=0.0) List<Double> radiuses) {
            this.directionsBuilder.radiuses(radiuses);
            return this;
        }

        public Builder voiceUnits(String voiceUnits) {
            this.directionsBuilder.voiceUnits(voiceUnits);
            return this;
        }

        Builder voiceUnits(Context context, LocaleUtils localeUtils) {
            this.directionsBuilder.voiceUnits(localeUtils.getUnitTypeForDeviceLocale(context));
            return this;
        }

        public Builder exclude(@Nullable String exclude) {
            this.directionsBuilder.exclude(exclude);
            return this;
        }

        public Builder clientAppName(@NonNull String clientAppName) {
            this.directionsBuilder.clientAppName(clientAppName);
            return this;
        }

        public Builder interceptor(Interceptor interceptor) {
            this.directionsBuilder.interceptor(interceptor);
            return this;
        }

        public Builder accessToken(@NonNull String accessToken) {
            this.directionsBuilder.accessToken(accessToken);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.directionsBuilder.baseUrl(baseUrl);
            return this;
        }

        public Builder addApproaches(String ... approaches) {
            this.directionsBuilder.addApproaches(approaches);
            return this;
        }

        public Builder addWaypointNames(String ... waypointNames) {
            this.directionsBuilder.addWaypointNames(waypointNames);
            return this;
        }

        public Builder routeOptions(RouteOptions options) {
            if (!TextUtils.isEmpty((CharSequence)options.baseUrl())) {
                this.directionsBuilder.baseUrl(options.baseUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)options.language())) {
                this.directionsBuilder.language(new Locale(options.language()));
            }
            if (options.alternatives() != null) {
                this.directionsBuilder.alternatives(options.alternatives());
            }
            if (!TextUtils.isEmpty((CharSequence)options.profile())) {
                this.directionsBuilder.profile(options.profile());
            }
            if (options.alternatives() != null) {
                this.directionsBuilder.alternatives(options.alternatives());
            }
            if (!TextUtils.isEmpty((CharSequence)options.voiceUnits())) {
                this.directionsBuilder.voiceUnits(options.voiceUnits());
            }
            if (!TextUtils.isEmpty((CharSequence)options.user())) {
                this.directionsBuilder.user(options.user());
            }
            if (!TextUtils.isEmpty((CharSequence)options.accessToken())) {
                this.directionsBuilder.accessToken(options.accessToken());
            }
            if (!TextUtils.isEmpty((CharSequence)options.annotations())) {
                this.directionsBuilder.annotations(new String[]{options.annotations()});
            }
            if (!TextUtils.isEmpty((CharSequence)options.approaches())) {
                String[] approaches = options.approaches().split(";");
                this.directionsBuilder.addApproaches(approaches);
            }
            if (!TextUtils.isEmpty((CharSequence)options.waypointNames())) {
                String[] waypointNames = options.waypointNames().split(";");
                this.directionsBuilder.addWaypointNames(waypointNames);
            }
            return this;
        }

        public NavigationRoute build() {
            this.directionsBuilder.steps(Boolean.valueOf(true)).continueStraight(Boolean.valueOf(true)).geometries("polyline6").overview("full").voiceInstructions(Boolean.valueOf(true)).bannerInstructions(Boolean.valueOf(true)).roundaboutExits(Boolean.valueOf(true));
            return new NavigationRoute(this.directionsBuilder.build());
        }
    }
}

