/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.util.Pair;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.NavigationHelper;
import com.mapbox.services.android.navigation.v5.navigation.NavigationIndices;
import com.mapbox.services.android.navigation.v5.offroute.OffRoute;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteCallback;
import com.mapbox.services.android.navigation.v5.offroute.OffRouteDetector;
import com.mapbox.services.android.navigation.v5.routeprogress.CurrentLegAnnotation;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;
import java.util.List;

class NavigationRouteProcessor
implements OffRouteCallback {
    private static final int FIRST_LEG_INDEX = 0;
    private static final int FIRST_STEP_INDEX = 0;
    private static final int ONE_INDEX = 1;
    private RouteProgress routeProgress;
    private List<Point> currentStepPoints;
    private List<Point> upcomingStepPoints;
    private List<StepIntersection> currentIntersections;
    private List<Pair<StepIntersection, Double>> currentIntersectionDistances;
    private RouteLeg currentLeg;
    private LegStep currentStep;
    private LegStep upcomingStep;
    private CurrentLegAnnotation currentLegAnnotation;
    private NavigationIndices indices = NavigationIndices.create(0, 0);
    private double stepDistanceRemaining;
    private boolean shouldIncreaseIndex;
    private NavigationIndices shouldUpdateToIndex;
    private RouteUtils routeUtils = new RouteUtils();

    NavigationRouteProcessor() {
    }

    @Override
    public void onShouldIncreaseIndex() {
        this.shouldIncreaseIndex = true;
    }

    @Override
    public void onShouldUpdateToIndex(int legIndex, int stepIndex) {
        this.shouldUpdateToIndex = NavigationIndices.create(legIndex, stepIndex);
        this.onShouldIncreaseIndex();
    }

    RouteProgress buildNewRouteProgress(MapboxNavigation navigation, Location location) {
        DirectionsRoute directionsRoute = navigation.getRoute();
        MapboxNavigationOptions options = navigation.options();
        double completionOffset = options.maxTurnCompletionOffset();
        double maneuverZoneRadius = options.maneuverZoneRadius();
        this.checkNewRoute(navigation);
        this.stepDistanceRemaining = this.calculateStepDistanceRemaining(location, directionsRoute);
        this.checkManeuverCompletion(navigation, location, directionsRoute, completionOffset, maneuverZoneRadius);
        return this.assembleRouteProgress(directionsRoute);
    }

    RouteProgress getRouteProgress() {
        return this.routeProgress;
    }

    void setRouteProgress(RouteProgress routeProgress) {
        this.routeProgress = routeProgress;
    }

    void checkIncreaseIndex(MapboxNavigation navigation) {
        if (this.shouldIncreaseIndex) {
            this.advanceIndices(navigation);
            this.shouldIncreaseIndex = false;
            this.shouldUpdateToIndex = null;
        }
    }

    private void checkNewRoute(MapboxNavigation mapboxNavigation) {
        DirectionsRoute directionsRoute = mapboxNavigation.getRoute();
        if (this.routeUtils.isNewRoute(this.routeProgress, directionsRoute)) {
            this.createFirstIndices(mapboxNavigation);
            this.routeProgress = this.assembleRouteProgress(directionsRoute);
        }
    }

    private double calculateStepDistanceRemaining(Location location, DirectionsRoute directionsRoute) {
        Point snappedPosition = NavigationHelper.userSnappedToRoutePosition(location, this.currentStepPoints);
        return NavigationHelper.stepDistanceRemaining(snappedPosition, this.indices.legIndex(), this.indices.stepIndex(), directionsRoute, this.currentStepPoints);
    }

    private void checkManeuverCompletion(MapboxNavigation navigation, Location location, DirectionsRoute directionsRoute, double completionOffset, double maneuverZoneRadius) {
        boolean forceIncreaseIndices;
        boolean withinManeuverRadius = this.stepDistanceRemaining < maneuverZoneRadius;
        boolean bearingMatchesManeuver = NavigationHelper.checkBearingForStepCompletion(location, this.routeProgress, this.stepDistanceRemaining, completionOffset);
        boolean bl = forceIncreaseIndices = this.stepDistanceRemaining == 0.0 && !bearingMatchesManeuver;
        if (bearingMatchesManeuver && withinManeuverRadius || forceIncreaseIndices) {
            this.advanceIndices(navigation);
            this.stepDistanceRemaining = this.calculateStepDistanceRemaining(location, directionsRoute);
        }
    }

    private void advanceIndices(MapboxNavigation mapboxNavigation) {
        this.indices = this.shouldUpdateToIndex != null ? this.shouldUpdateToIndex : NavigationHelper.increaseIndex(this.routeProgress, this.indices);
        this.processNewIndex(mapboxNavigation);
    }

    private void createFirstIndices(MapboxNavigation mapboxNavigation) {
        this.indices = NavigationIndices.create(0, 0);
        this.processNewIndex(mapboxNavigation);
    }

    private void processNewIndex(MapboxNavigation mapboxNavigation) {
        DirectionsRoute route = mapboxNavigation.getRoute();
        int legIndex = this.indices.legIndex();
        int stepIndex = this.indices.stepIndex();
        int upcomingStepIndex = stepIndex + 1;
        if (route.legs().size() <= legIndex || ((RouteLeg)route.legs().get(legIndex)).steps().size() <= stepIndex) {
            this.createFirstIndices(mapboxNavigation);
            return;
        }
        this.updateSteps(route, legIndex, stepIndex, upcomingStepIndex);
        this.updateStepPoints(route, legIndex, stepIndex, upcomingStepIndex);
        this.updateIntersections();
        this.clearManeuverDistances(mapboxNavigation.getOffRouteEngine());
    }

    private RouteProgress assembleRouteProgress(DirectionsRoute route) {
        int legIndex = this.indices.legIndex();
        int stepIndex = this.indices.stepIndex();
        double legDistanceRemaining = NavigationHelper.legDistanceRemaining(this.stepDistanceRemaining, legIndex, stepIndex, route);
        double routeDistanceRemaining = NavigationHelper.routeDistanceRemaining(legDistanceRemaining, legIndex, route);
        this.currentLegAnnotation = NavigationHelper.createCurrentAnnotation(this.currentLegAnnotation, this.currentLeg, legDistanceRemaining);
        double stepDistanceTraveled = this.currentStep.distance() - this.stepDistanceRemaining;
        StepIntersection currentIntersection = NavigationHelper.findCurrentIntersection(this.currentIntersections, this.currentIntersectionDistances, stepDistanceTraveled);
        StepIntersection upcomingIntersection = NavigationHelper.findUpcomingIntersection(this.currentIntersections, this.upcomingStep, currentIntersection);
        RouteProgress.Builder progressBuilder = RouteProgress.builder().stepDistanceRemaining(this.stepDistanceRemaining).legDistanceRemaining(legDistanceRemaining).distanceRemaining(routeDistanceRemaining).directionsRoute(route).currentStepPoints(this.currentStepPoints).upcomingStepPoints(this.upcomingStepPoints).stepIndex(stepIndex).legIndex(legIndex).intersections(this.currentIntersections).currentIntersection(currentIntersection).upcomingIntersection(upcomingIntersection).intersectionDistancesAlongStep(this.currentIntersectionDistances).currentLegAnnotation(this.currentLegAnnotation);
        this.addUpcomingStepPoints(progressBuilder);
        return progressBuilder.build();
    }

    private void addUpcomingStepPoints(RouteProgress.Builder progressBuilder) {
        if (this.upcomingStepPoints != null && !this.upcomingStepPoints.isEmpty()) {
            progressBuilder.upcomingStepPoints(this.upcomingStepPoints);
        }
    }

    private void updateSteps(DirectionsRoute route, int legIndex, int stepIndex, int upcomingStepIndex) {
        this.currentLeg = (RouteLeg)route.legs().get(legIndex);
        List steps = this.currentLeg.steps();
        this.currentStep = (LegStep)steps.get(stepIndex);
        this.upcomingStep = upcomingStepIndex < steps.size() - 1 ? (LegStep)steps.get(upcomingStepIndex) : null;
    }

    private void updateStepPoints(DirectionsRoute route, int legIndex, int stepIndex, int upcomingStepIndex) {
        this.currentStepPoints = NavigationHelper.decodeStepPoints(route, this.currentStepPoints, legIndex, stepIndex);
        this.upcomingStepPoints = NavigationHelper.decodeStepPoints(route, null, legIndex, upcomingStepIndex);
    }

    private void updateIntersections() {
        this.currentIntersections = NavigationHelper.createIntersectionsList(this.currentStep, this.upcomingStep);
        this.currentIntersectionDistances = NavigationHelper.createDistancesToIntersections(this.currentStepPoints, this.currentIntersections);
    }

    private void clearManeuverDistances(OffRoute offRoute) {
        if (offRoute instanceof OffRouteDetector) {
            ((OffRouteDetector)offRoute).clearDistancesAwayFromManeuver();
        }
    }
}

