/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.mapbox.mapboxsdk.location.engine.LocationEngine;
import com.mapbox.services.android.navigation.v5.location.LocationValidator;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEngineFactory;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationFasterRouteListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLocationEngineListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLocationEngineUpdater;
import com.mapbox.services.android.navigation.v5.navigation.NavigationNotificationProvider;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorBackgroundThread;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorThreadListener;
import com.mapbox.services.android.navigation.v5.navigation.notification.NavigationNotification;
import com.mapbox.services.android.navigation.v5.route.FasterRoute;
import com.mapbox.services.android.navigation.v5.route.RouteFetcher;
import timber.log.Timber;

public class NavigationService
extends Service {
    private final IBinder localBinder = new LocalBinder();
    private RouteProcessorBackgroundThread thread;
    private NavigationLocationEngineUpdater locationEngineUpdater;
    private RouteFetcher routeFetcher;
    private NavigationNotificationProvider notificationProvider;

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.localBinder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public void onDestroy() {
        this.stopForeground(true);
        if (this.locationEngineUpdater != null) {
            this.locationEngineUpdater.removeLocationEngineListener();
        }
        super.onDestroy();
    }

    void startNavigation(MapboxNavigation mapboxNavigation) {
        this.initialize(mapboxNavigation);
        this.startForegroundNotification(this.notificationProvider.retrieveNotification());
        this.locationEngineUpdater.forceLocationUpdate(mapboxNavigation.getRoute());
    }

    void endNavigation() {
        this.routeFetcher.clearListeners();
        this.locationEngineUpdater.removeLocationEngineListener();
        this.notificationProvider.shutdown((Context)this.getApplication());
        this.thread.quit();
    }

    void updateLocationEngine(LocationEngine locationEngine) {
        this.locationEngineUpdater.updateLocationEngine(locationEngine);
    }

    private void initialize(MapboxNavigation mapboxNavigation) {
        NavigationEventDispatcher dispatcher = mapboxNavigation.getEventDispatcher();
        this.initializeRouteFetcher(dispatcher, mapboxNavigation.retrieveEngineProvider());
        this.initializeNotificationProvider(mapboxNavigation);
        this.initializeRouteProcessorThread(dispatcher, this.routeFetcher, this.notificationProvider);
        this.initializeLocationProvider(mapboxNavigation);
    }

    private void initializeRouteFetcher(NavigationEventDispatcher dispatcher, NavigationEngineFactory engineProvider) {
        FasterRoute fasterRouteEngine = engineProvider.retrieveFasterRouteEngine();
        NavigationFasterRouteListener listener = new NavigationFasterRouteListener(dispatcher, fasterRouteEngine);
        this.routeFetcher = new RouteFetcher((Context)this.getApplication());
        this.routeFetcher.addRouteListener(listener);
    }

    private void initializeNotificationProvider(MapboxNavigation mapboxNavigation) {
        this.notificationProvider = new NavigationNotificationProvider((Context)this.getApplication(), mapboxNavigation);
    }

    private void initializeRouteProcessorThread(NavigationEventDispatcher dispatcher, RouteFetcher routeFetcher, NavigationNotificationProvider notificationProvider) {
        RouteProcessorThreadListener listener = new RouteProcessorThreadListener(dispatcher, routeFetcher, notificationProvider);
        this.thread = new RouteProcessorBackgroundThread(new Handler(), listener);
    }

    private void initializeLocationProvider(MapboxNavigation mapboxNavigation) {
        LocationEngine locationEngine = mapboxNavigation.getLocationEngine();
        int accuracyThreshold = mapboxNavigation.options().locationAcceptableAccuracyInMetersThreshold();
        LocationValidator validator = new LocationValidator(accuracyThreshold);
        NavigationLocationEngineListener listener = new NavigationLocationEngineListener(this.thread, mapboxNavigation, locationEngine, validator);
        this.locationEngineUpdater = new NavigationLocationEngineUpdater(locationEngine, listener);
    }

    private void startForegroundNotification(NavigationNotification navigationNotification) {
        Notification notification = navigationNotification.getNotification();
        int notificationId = navigationNotification.getNotificationId();
        notification.flags = 64;
        this.startForeground(notificationId, notification);
    }

    class LocalBinder
    extends Binder {
        LocalBinder() {
        }

        NavigationService getService() {
            Timber.d((String)"Local binder called.", (Object[])new Object[0]);
            return NavigationService.this;
        }
    }
}

