/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.os.Handler;
import android.os.HandlerThread;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLocationUpdate;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteProcessor;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorHandlerCallback;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.List;

class RouteProcessorBackgroundThread
extends HandlerThread {
    private static final String MAPBOX_NAVIGATION_THREAD_NAME = "mapbox_navigation_thread";
    private static final int MSG_LOCATION_UPDATED = 1001;
    private Handler workerHandler;

    RouteProcessorBackgroundThread(Handler responseHandler, Listener listener) {
        super(MAPBOX_NAVIGATION_THREAD_NAME, 10);
        this.start();
        this.initialize(responseHandler, listener);
    }

    void queueUpdate(NavigationLocationUpdate navigationLocationUpdate) {
        this.workerHandler.obtainMessage(1001, (Object)navigationLocationUpdate).sendToTarget();
    }

    private void initialize(Handler responseHandler, Listener listener) {
        NavigationRouteProcessor routeProcessor = new NavigationRouteProcessor();
        this.workerHandler = new Handler(this.getLooper(), (Handler.Callback)new RouteProcessorHandlerCallback(routeProcessor, responseHandler, listener));
    }

    static interface Listener {
        public void onNewRouteProgress(Location var1, RouteProgress var2);

        public void onMilestoneTrigger(List<Milestone> var1, RouteProgress var2);

        public void onUserOffRoute(Location var1, boolean var2);

        public void onCheckFasterRoute(Location var1, RouteProgress var2, boolean var3);
    }
}

